/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.util.Objects;
import java.net.URI;

final class Dsn {
    private final String projectId;
    private final String path;
    private final String secretKey;
    private final String publicKey;
    private final URI sentryUri;

    public final String getSecretKey() {
        return this.secretKey;
    }

    public final String getPublicKey() {
        return this.publicKey;
    }

    final URI getSentryUri() {
        return this.sentryUri;
    }

    /*
     * WARNING - void declaration
     */
    Dsn(String dsn) throws IllegalArgumentException {
        try {
            void var2_3;
            void var3_4;
            int projectIdStart;
            String path;
            Objects.requireNonNull(dsn, "The DSN is required.");
            URI uri = new URI(dsn).normalize();
            String scheme = uri.getScheme();
            if (!"http".equalsIgnoreCase(scheme) && !"https".equalsIgnoreCase(scheme)) {
                throw new IllegalArgumentException("Invalid DSN scheme: " + scheme);
            }
            String userInfo = uri.getUserInfo();
            if (userInfo == null || userInfo.isEmpty()) {
                throw new IllegalArgumentException("Invalid DSN: No public key provided.");
            }
            String[] keys = userInfo.split(":", -1);
            this.publicKey = keys[0];
            if (this.publicKey == null || this.publicKey.isEmpty()) {
                throw new IllegalArgumentException("Invalid DSN: No public key provided.");
            }
            this.secretKey = keys.length > 1 ? keys[1] : null;
            String uriPath = uri.getPath();
            if (uriPath.endsWith("/")) {
                uriPath = uriPath.substring(0, uriPath.length() - 1);
            }
            if (!(path = uriPath.substring(0, projectIdStart = uriPath.lastIndexOf("/") + 1)).endsWith("/")) {
                path = path + "/";
            }
            this.path = path;
            this.projectId = var3_4.substring(projectIdStart);
            if (this.projectId.isEmpty()) {
                throw new IllegalArgumentException("Invalid DSN: A Project Id is required.");
            }
            this.sentryUri = new URI((String)var2_3, null, uri.getHost(), uri.getPort(), path + "api/" + this.projectId, null, null);
            return;
        }
        catch (Throwable e) {
            void var1_2;
            throw new IllegalArgumentException((Throwable)var1_2);
        }
    }
}

