/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation;

import androidx.compose.animation.AndroidFlingSpline;
import androidx.compose.animation.FlingCalculatorKt;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.unit.Density;
import kotlin.jvm.internal.Intrinsics;

@StabilityInferred(parameters=1)
public final class FlingCalculator {
    private final float friction;
    private final Density density;
    private final float magicPhysicalCoefficient;

    /*
     * WARNING - void declaration
     */
    public FlingCalculator(float friction, Density density) {
        void var2_3;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        this.friction = var1_1;
        Density density2 = this.density = var2_3;
        this.magicPhysicalCoefficient = FlingCalculatorKt.access$computeDeceleration(0.84f, density2.getDensity());
    }

    /*
     * WARNING - void declaration
     */
    private final double getSplineDeceleration(float velocity) {
        void var1_1;
        return AndroidFlingSpline.deceleration((float)var1_1, this.friction * this.magicPhysicalCoefficient);
    }

    /*
     * WARNING - void declaration
     */
    public final long flingDuration(float velocity) {
        void var2_2;
        void var1_1;
        double l = this.getSplineDeceleration((float)var1_1);
        double decelMinusOne = (double)FlingCalculatorKt.access$getDecelerationRate$p() - 1.0;
        return (long)(1000.0 * Math.exp((double)(var2_2 / decelMinusOne)));
    }

    /*
     * WARNING - void declaration
     */
    public final float flingDistance(float velocity) {
        void var2_2;
        void var1_1;
        double l = this.getSplineDeceleration((float)var1_1);
        double decelMinusOne = (double)FlingCalculatorKt.access$getDecelerationRate$p() - 1.0;
        return (float)((double)(this.friction * this.magicPhysicalCoefficient) * Math.exp((double)FlingCalculatorKt.access$getDecelerationRate$p() / decelMinusOne * var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public final FlingInfo flingInfo(float velocity) {
        void var2_2;
        void var1_1;
        double l = this.getSplineDeceleration(velocity);
        double decelMinusOne = (double)FlingCalculatorKt.access$getDecelerationRate$p() - 1.0;
        return new FlingInfo((float)var1_1, (float)((double)(this.friction * this.magicPhysicalCoefficient) * Math.exp((double)FlingCalculatorKt.access$getDecelerationRate$p() / decelMinusOne * l)), (long)(1000.0 * Math.exp((double)(var2_2 / decelMinusOne))));
    }

    @StabilityInferred(parameters=1)
    public static final class FlingInfo {
        private final float initialVelocity;
        private final float distance;
        private final long duration;

        /*
         * WARNING - void declaration
         */
        public FlingInfo(float initialVelocity, float distance, long duration) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.initialVelocity = var1_1;
            this.distance = var2_2;
            this.duration = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        public final float position(long time) {
            void var1_2;
            float splinePos = this.duration > 0L ? (float)time / (float)this.duration : 1.0f;
            return this.distance * Math.signum(this.initialVelocity) * AndroidFlingSpline.flingPosition((float)var1_2).getDistanceCoefficient();
        }

        /*
         * WARNING - void declaration
         */
        public final float velocity(long time) {
            void var1_2;
            float splinePos = this.duration > 0L ? (float)time / (float)this.duration : 1.0f;
            return AndroidFlingSpline.flingPosition((float)var1_2).getVelocityCoefficient() * Math.signum(this.initialVelocity) * this.distance / (float)this.duration * 1000.0f;
        }

        public final String toString() {
            return "FlingInfo(initialVelocity=" + this.initialVelocity + ", distance=" + this.distance + ", duration=" + this.duration + ')';
        }

        public final int hashCode() {
            int n = Float.hashCode(this.initialVelocity);
            n = n * 31 + Float.hashCode(this.distance);
            n = n * 31 + Long.hashCode(this.duration);
            return n;
        }

        public final boolean equals(Object other) {
            FlingInfo flingInfo;
            if (this == other) {
                return true;
            }
            if (!(other instanceof FlingInfo)) {
                return false;
            }
            flingInfo = flingInfo;
            if (Float.compare(this.initialVelocity, flingInfo.initialVelocity) != 0) {
                return false;
            }
            if (Float.compare(this.distance, flingInfo.distance) != 0) {
                return false;
            }
            return this.duration == flingInfo.duration;
        }
    }
}

