/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation;

import androidx.compose.animation.SplineBasedDecayKt;
import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.ranges.RangesKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0004\b\u00c1\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\b\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u0004\u00a2\u0006\u0004\b\f\u0010\rR\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0010"}, d2={"Landroidx/compose/animation/AndroidFlingSpline;", "", "<init>", "()V", "", "velocity", "friction", "", "deceleration", "(FF)D", "time", "Landroidx/compose/animation/AndroidFlingSpline$FlingResult;", "flingPosition", "(F)Landroidx/compose/animation/AndroidFlingSpline$FlingResult;", "", "SplinePositions", "[F", "SplineTimes", "FlingResult"})
@StabilityInferred(parameters=0)
public final class AndroidFlingSpline {
    public static final AndroidFlingSpline INSTANCE = new AndroidFlingSpline();
    private static final float[] SplinePositions = new float[101];
    private static final float[] SplineTimes = new float[101];
    public static final int $stable;

    private AndroidFlingSpline() {
    }

    /*
     * WARNING - void declaration
     */
    public static FlingResult flingPosition(float time) {
        float f;
        float f2;
        float clampedTime = RangesKt.coerceIn((float)time, (float)0.0f, (float)1.0f);
        int index = (int)(100.0f * clampedTime);
        float distanceCoef = 1.0f;
        float velocityCoef = 0.0f;
        if (index < 100) {
            float f3;
            void var1_1;
            float tInf = (float)index / 100.0f;
            float tSup = (float)(index + 1) / 100.0f;
            float dInf = SplinePositions[index];
            float f4 = SplinePositions[var1_1 + true];
            f2 = (f4 - dInf) / (f2 - tInf);
            f = dInf + (f3 - f) * f2;
        }
        return new FlingResult(f, f2);
    }

    /*
     * WARNING - void declaration
     */
    public static double deceleration(float velocity, float friction) {
        void var1_1;
        float f;
        return Math.log((double)(0.35f * Math.abs(f)) / (double)var1_1);
    }

    static {
        SplineBasedDecayKt.access$computeSplineInfo(SplinePositions, SplineTimes, 100);
        $stable = 8;
    }

    @StabilityInferred(parameters=1)
    public static final class FlingResult {
        private final float distanceCoefficient;
        private final float velocityCoefficient;

        /*
         * WARNING - void declaration
         */
        public FlingResult(float distanceCoefficient, float velocityCoefficient) {
            void var2_2;
            void var1_1;
            this.distanceCoefficient = var1_1;
            this.velocityCoefficient = var2_2;
        }

        public final float getDistanceCoefficient() {
            return this.distanceCoefficient;
        }

        public final float getVelocityCoefficient() {
            return this.velocityCoefficient;
        }

        public final String toString() {
            return "FlingResult(distanceCoefficient=" + this.distanceCoefficient + ", velocityCoefficient=" + this.velocityCoefficient + ')';
        }

        public final int hashCode() {
            int n = Float.hashCode(this.distanceCoefficient);
            n = n * 31 + Float.hashCode(this.velocityCoefficient);
            return n;
        }

        public final boolean equals(Object other) {
            FlingResult flingResult;
            if (this == other) {
                return true;
            }
            if (!(other instanceof FlingResult)) {
                return false;
            }
            flingResult = flingResult;
            if (Float.compare(this.distanceCoefficient, flingResult.distanceCoefficient) != 0) {
                return false;
            }
            return Float.compare(this.velocityCoefficient, flingResult.velocityCoefficient) == 0;
        }
    }
}

