/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.swing;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.DataBufferInt;
import java.awt.image.ImageObserver;
import java.awt.image.VolatileImage;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.skiko.swing.SwingLayerProperties;
import org.jetbrains.skiko.swing.SwingLayerPropertiesKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0018\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J5\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0087\u0001\u0010*\u001a\u00020)2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0011\u001a\u00020\u00172\b\u0010\u0019\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\b2\b\u0010\u001e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\b2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020\b2\u0006\u0010$\u001a\u00020\b2\b\u0010&\u001a\u0004\u0018\u00010%2\u0006\u0010(\u001a\u00020'H\u0002\u00a2\u0006\u0004\b*\u0010+J}\u0010-\u001a\u00020)2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\b2\u0006\u0010\"\u001a\u00020!2\u0006\u0010(\u001a\u00020'2\u0006\u0010#\u001a\u00020\b2\u0006\u0010$\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001a2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0011\u001a\u00020\u00172\b\u0010,\u001a\u0004\u0018\u00010\f2\b\u0010&\u001a\u0004\u0018\u00010%H\u0002\u00a2\u0006\u0004\b-\u0010.J-\u0010/\u001a\u00020)2\u0006\u0010\"\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b\u00a2\u0006\u0004\b/\u00100Jk\u00103\u001a\u00020)2\u0006\u0010\"\u001a\u00020!2\u0006\u0010\u0011\u001a\u00020\u00172\b\b\u0002\u00101\u001a\u00020\b2\b\b\u0002\u00102\u001a\u00020\b2\b\b\u0002\u0010\u001c\u001a\u00020\b2\b\b\u0002\u0010\u001d\u001a\u00020\b2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00152\n\b\u0002\u0010&\u001a\u0004\u0018\u00010%H\u0002\u00a2\u0006\u0004\b3\u00104J\u001f\u00106\u001a\u00020)2\u0006\u00105\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b6\u00107J\u001f\u00109\u001a\u00020\b2\u0006\u00108\u001a\u00020\b2\u0006\u0010(\u001a\u00020'H\u0002\u00a2\u0006\u0004\b9\u0010:R\u0018\u0010;\u001a\u0004\u0018\u00010\u000e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b;\u0010<R\u0018\u0010=\u001a\u0004\u0018\u00010\u00188\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b=\u0010>R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010?R\u0018\u0010@\u001a\u0004\u0018\u00010\u00128\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b@\u0010A"}, d2={"Lorg/jetbrains/skiko/swing/SwingOffscreenDrawer;", "", "Lorg/jetbrains/skiko/swing/SwingLayerProperties;", "swingLayerProperties", "<init>", "(Lorg/jetbrains/skiko/swing/SwingLayerProperties;)V", "", "bytes", "", "width", "height", "", "Ljava/awt/Rectangle;", "dirtyRectangles", "Ljava/awt/image/BufferedImage;", "createImageFromBytes", "([BIILjava/util/List;)Ljava/awt/image/BufferedImage;", "image", "Ljava/awt/image/VolatileImage;", "createVolatileImage", "(Ljava/awt/image/BufferedImage;)Ljava/awt/image/VolatileImage;", "Ljava/awt/image/BufferedImageOp;", "op", "Ljava/awt/Image;", "Ljava/awt/Graphics2D;", "invG", "", "hasDestinationSize", "dw", "dh", "sourceBounds", "userWidth", "userHeight", "Ljava/awt/Graphics;", "g", "dx", "dy", "Ljava/awt/image/ImageObserver;", "observer", "", "scale", "", "doDraw", "(Ljava/awt/image/BufferedImageOp;Ljava/awt/Image;Ljava/awt/Graphics2D;ZIILjava/awt/Rectangle;IILjava/awt/Graphics;IILjava/awt/image/ImageObserver;D)V", "srcBounds", "doDrawHiDpi", "(IILjava/awt/Graphics;DIIIIZLjava/awt/image/BufferedImageOp;Ljava/awt/Image;Ljava/awt/Rectangle;Ljava/awt/image/ImageObserver;)V", "draw", "(Ljava/awt/Graphics2D;[BII)V", "x", "y", "drawImage", "(Ljava/awt/Graphics;Ljava/awt/Image;IIIILjava/awt/Rectangle;Ljava/awt/image/BufferedImageOp;Ljava/awt/image/ImageObserver;)V", "vi", "drawVolatileImage", "(Ljava/awt/image/VolatileImage;Ljava/awt/image/BufferedImage;)V", "size", "scaleSize", "(ID)I", "bufferedImage", "Ljava/awt/image/BufferedImage;", "bufferedImageGraphics", "Ljava/awt/Graphics2D;", "Lorg/jetbrains/skiko/swing/SwingLayerProperties;", "volatileImage", "Ljava/awt/image/VolatileImage;"})
@SourceDebugExtension(value={"SMAP\nSwingOffscreenDrawer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwingOffscreenDrawer.kt\norg/jetbrains/skiko/swing/SwingOffscreenDrawer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,288:1\n1#2:289\n*E\n"})
public final class SwingOffscreenDrawer {
    private final SwingLayerProperties swingLayerProperties;
    private volatile VolatileImage volatileImage;
    private BufferedImage bufferedImage;
    private Graphics2D bufferedImageGraphics;

    /*
     * WARNING - void declaration
     */
    public SwingOffscreenDrawer(SwingLayerProperties swingLayerProperties2) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)swingLayerProperties2, (String)"swingLayerProperties");
        this.swingLayerProperties = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void draw(Graphics2D g, byte[] bytes, int width2, int height2) {
        void var3_4;
        VolatileImage volatileImage;
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        List dirtyRectangles = CollectionsKt.listOf((Object)new Rectangle(0, 0, width2, height2));
        BufferedImage image = this.createImageFromBytes(bytes, width2, height2, dirtyRectangles);
        VolatileImage vi = this.volatileImage;
        do {
            if (vi == null || vi.getWidth() != this.swingLayerProperties.getWidth() || vi.getHeight() != this.swingLayerProperties.getHeight()) {
                vi = this.createVolatileImage(image);
            }
            this.drawVolatileImage(vi, image);
            switch (vi.validate(this.swingLayerProperties.getGraphicsConfiguration())) {
                case 1: {
                    this.drawVolatileImage(vi, image);
                    break;
                }
                case 2: {
                    vi = this.createVolatileImage(image);
                }
            }
            g.drawImage(vi, 0, 0, null);
            volatileImage = vi;
            Intrinsics.checkNotNull((Object)volatileImage);
        } while (volatileImage.contentsLost());
        this.volatileImage = var3_4;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private final BufferedImage createImageFromBytes(byte[] bytes, int width, int height, List<? extends Rectangle> dirtyRectangles) {
        src = ByteBuffer.wrap(bytes);
        if (this.bufferedImage == null) ** GOTO lbl-1000
        v0 = this.bufferedImage;
        v1 = v0 != null ? v0.getWidth() == width : false;
        if (!v1) ** GOTO lbl-1000
        v2 = this.bufferedImage;
        if (!(v2 != null ? v2.getHeight() == height : false)) lbl-1000:
        // 3 sources

        {
            v3 = this.bufferedImage;
            if (v3 != null) {
                v3.flush();
            }
            v4 = this.bufferedImage = new BufferedImage(width, height, 3);
            this.bufferedImageGraphics = v4 != null ? v4.createGraphics() : null;
        } else {
            v5 = this.bufferedImageGraphics;
            if (v5 != null) {
                v5.clearRect(0, 0, width, height);
            }
        }
        v6 = this.bufferedImage;
        Intrinsics.checkNotNull((Object)v6);
        image = v6;
        v7 = v6.getRaster().getDataBuffer();
        Intrinsics.checkNotNull((Object)v7, (String)"null cannot be cast to non-null type java.awt.image.DataBufferInt");
        dstData = ((DataBufferInt)v7).getData();
        v8 = src.order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"asIntBuffer(...)");
        srcData = v8;
        for (Rectangle rect : dirtyRectangles) {
            if (rect.width < image.getWidth()) {
                var8_10 = rect.y + rect.height;
                for (line = rect.y; line < var8_10; ++line) {
                    offset = line * image.getWidth() + rect.x;
                    srcData.position(offset).get(dstData, offset, (int)Math.min((double)rect.width, (double)(src.capacity() - offset)));
                }
                continue;
            }
            offset = rect.y * image.getWidth();
            srcData.position(offset).get(dstData, offset, (int)Math.min((double)(rect.height * image.getWidth()), (double)(src.capacity() - offset)));
        }
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    private final VolatileImage createVolatileImage(BufferedImage image) {
        void var2_2;
        void var1_1;
        VolatileImage vi = this.swingLayerProperties.getGraphicsConfiguration().createCompatibleVolatileImage(this.swingLayerProperties.getWidth(), this.swingLayerProperties.getHeight(), 3);
        Intrinsics.checkNotNull((Object)vi);
        this.drawVolatileImage(vi, (BufferedImage)var1_1);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private final void drawVolatileImage(VolatileImage vi, BufferedImage image) {
        Graphics graphics = vi.getGraphics().create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g = (Graphics2D)graphics;
        try {
            void var3_3;
            void var2_2;
            g.setBackground(new Color(0, 0, 0, 0));
            g.setComposite(AlphaComposite.Src);
            g.clearRect(0, 0, this.swingLayerProperties.getWidth(), this.swingLayerProperties.getHeight());
            Rectangle imageClipRectangle = new Rectangle(0, 0, this.swingLayerProperties.getWidth(), this.swingLayerProperties.getHeight());
            SwingOffscreenDrawer.drawImage$default(this, g, (Image)var2_2, 0, 0, 0, 0, (Rectangle)var3_3, null, null, 444, null);
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.dispose();
            throw throwable;
        }
        g.dispose();
    }

    /*
     * WARNING - void declaration
     */
    private final void drawImage(Graphics g, Image image, int x2, int y2, int dw, int dh, Rectangle sourceBounds, BufferedImageOp op, ImageObserver observer) {
        void var2_2;
        void var3_3;
        void var1_1;
        boolean hasDestinationSize = dw >= 0 && dh >= 0;
        SwingOffscreenDrawer swingOffscreenDrawer = this;
        swingOffscreenDrawer.doDrawHiDpi(swingOffscreenDrawer.swingLayerProperties.getWidth(), this.swingLayerProperties.getHeight(), (Graphics)var1_1, SwingLayerPropertiesKt.getScale(this.swingLayerProperties), (int)var3_3, y2, dw, dh, hasDestinationSize, op, (Image)var2_2, sourceBounds, observer);
    }

    static /* synthetic */ void drawImage$default(SwingOffscreenDrawer swingOffscreenDrawer, Graphics graphics, Image image, int n, int n2, int n3, int n4, Rectangle rectangle, BufferedImageOp bufferedImageOp, ImageObserver imageObserver, int n5, Object object) {
        if ((n5 & 4) != 0) {
            n = 0;
        }
        if ((n5 & 8) != 0) {
            n2 = 0;
        }
        if ((n5 & 0x10) != 0) {
            n3 = -1;
        }
        if ((n5 & 0x20) != 0) {
            n4 = -1;
        }
        if ((n5 & 0x40) != 0) {
            rectangle = null;
        }
        if ((n5 & 0x80) != 0) {
            bufferedImageOp = null;
        }
        if ((n5 & 0x100) != 0) {
            imageObserver = null;
        }
        swingOffscreenDrawer.drawImage(graphics, image, n, n2, n3, n4, rectangle, bufferedImageOp, imageObserver);
    }

    /*
     * WARNING - void declaration
     */
    private final void doDrawHiDpi(int userWidth, int userHeight, Graphics g, double scale, int dx, int dy, int dw, int dh, boolean hasDestinationSize, BufferedImageOp op, Image image, Rectangle srcBounds, ImageObserver observer) {
        Graphics graphics;
        Graphics g1 = g;
        double scale1 = scale;
        int dx1 = dx;
        int dy1 = dy;
        double delta = 0.0;
        int maxSize = Math.max(userWidth, userHeight);
        if (maxSize < 0x3FFFFFFF) {
            void pow;
            int dotAccuracy = 1;
            while (true) {
                void it;
                double d;
                double d2 = d = Math.pow(10.0, dotAccuracy);
                double d3 = maxSize;
                pow = it;
                if (!(d3 > d)) break;
                ++dotAccuracy;
            }
            delta = 1.0 / pow;
        }
        Graphics graphics2 = g1;
        Intrinsics.checkNotNull((Object)graphics2, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        AffineTransform tx = ((Graphics2D)graphics2).getTransform();
        Graphics invG = null;
        if ((tx.getType() & 0x18) == 0 && Math.abs(scale - tx.getScaleX()) <= delta) {
            scale1 = tx.getScaleX();
            double gScaleX = tx.getScaleX();
            double gScaleY = tx.getScaleY();
            tx.scale(1.0 / gScaleX, 1.0 / gScaleY);
            tx.translate((double)dx * gScaleX, (double)dy * gScaleY);
            dy1 = 0;
            dx1 = 0;
            Graphics graphics3 = g1.create();
            Intrinsics.checkNotNull((Object)graphics3, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
            invG = (Graphics2D)graphics3;
            g1 = invG;
            ((Graphics2D)invG).setTransform(tx);
        }
        try {
            void var3_3;
            void var2_2;
            void var1_1;
            int dw2 = dw;
            int dh2 = dh;
            if (invG != null && hasDestinationSize) {
                dw2 = this.scaleSize(dw, scale1);
                dh2 = this.scaleSize(dh, scale1);
            }
            this.doDraw(op, image, (Graphics2D)invG, hasDestinationSize, dw2, dh2, srcBounds, (int)var1_1, (int)var2_2, (Graphics)var3_3, dx1, dy1, observer, scale1);
            graphics = invG;
        }
        catch (Throwable throwable) {
            Graphics graphics4 = invG;
            if (graphics4 != null) {
                graphics4.dispose();
            }
            throw throwable;
        }
        if (graphics == null) {
            return;
        }
        graphics.dispose();
    }

    /*
     * WARNING - void declaration
     */
    private final int scaleSize(int size2, double scale) {
        void var2_2;
        return MathKt.roundToInt((double)((double)size2 * var2_2));
    }

    /*
     * WARNING - void declaration
     */
    private final void doDraw(BufferedImageOp op, Image image, Graphics2D invG, boolean hasDestinationSize, int dw, int dh, Rectangle sourceBounds, int userWidth, int userHeight, Graphics g, int dx, int dy, ImageObserver observer, double scale) {
        void var2_3;
        void var3_4;
        if (op != null && image instanceof BufferedImage) {
            BufferedImage bufferedImage = op.filter((BufferedImage)image, null);
            Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"filter(...)");
            image = bufferedImage;
        }
        if (sourceBounds != null) {
            void var3_5;
            void var1_2;
            int sh;
            int sx = SwingOffscreenDrawer.doDraw$size(this, scale, sourceBounds.x);
            int sy = SwingOffscreenDrawer.doDraw$size(this, scale, sourceBounds.y);
            int sw = sourceBounds.width >= 0 ? SwingOffscreenDrawer.doDraw$size(this, scale, sourceBounds.width) : SwingOffscreenDrawer.doDraw$size(this, scale, userWidth) - sx;
            int n = sh = sourceBounds.height >= 0 ? SwingOffscreenDrawer.doDraw$size(this, scale, sourceBounds.height) : SwingOffscreenDrawer.doDraw$size(this, scale, userHeight) - sy;
            if (!hasDestinationSize) {
                dw = SwingOffscreenDrawer.doDraw$size(this, scale, userWidth);
                dh = SwingOffscreenDrawer.doDraw$size(this, scale, userHeight);
            }
            g.drawImage(image, dx, dy, dx + dw, dy + dh, sx, sy, (int)(var1_2 + sw), (int)(var3_5 + sh), observer);
            return;
        }
        if (hasDestinationSize) {
            void var6_8;
            void var5_7;
            g.drawImage(image, dx, dy, (int)var5_7, (int)var6_8, observer);
            return;
        }
        if (var3_4 == null) {
            g.drawImage(image, dx, dy, userWidth, userHeight, observer);
            return;
        }
        g.drawImage((Image)var2_3, dx, dy, observer);
    }

    /*
     * WARNING - void declaration
     */
    private static final int doDraw$size(SwingOffscreenDrawer this$0, double $scale, int size2) {
        void var1_1;
        void var3_2;
        return this$0.scaleSize((int)var3_2, (double)var1_1);
    }
}

