/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.swing;

import java.awt.Graphics2D;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.skia.BackendRenderTarget;
import org.jetbrains.skia.Bitmap;
import org.jetbrains.skia.Canvas;
import org.jetbrains.skia.ColorAlphaType;
import org.jetbrains.skia.ColorSpace;
import org.jetbrains.skia.DirectContext;
import org.jetbrains.skia.ImageInfo;
import org.jetbrains.skia.PixelGeometry;
import org.jetbrains.skia.Surface;
import org.jetbrains.skia.SurfaceColorFormat;
import org.jetbrains.skia.SurfaceOrigin;
import org.jetbrains.skia.SurfaceProps;
import org.jetbrains.skia.impl.Managed;
import org.jetbrains.skiko.CloseScope;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.Library;
import org.jetbrains.skiko.MetalAdapter;
import org.jetbrains.skiko.MetalApiKt;
import org.jetbrains.skiko.RenderException;
import org.jetbrains.skiko.ResourceUtilsKt;
import org.jetbrains.skiko.SkiaLayerAnalytics;
import org.jetbrains.skiko.SkikoRenderDelegate;
import org.jetbrains.skiko.swing.SwingLayerProperties;
import org.jetbrains.skiko.swing.SwingOffscreenDrawer;
import org.jetbrains.skiko.swing.SwingRedrawerBase;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0001\u0018\u0000 ;2\u00020\u0001:\u0001;B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0018\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0082 \u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001f\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0018\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0018\u0010\u0018\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\rH\u0082 \u00a2\u0006\u0004\b\u0018\u0010\u0010J\u0018\u0010\u001b\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0082 \u00a2\u0006\u0004\b\u001b\u0010\u0010J0\u0010 \u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u001dH\u0082 \u00a2\u0006\u0004\b \u0010!J\u000f\u0010#\u001a\u00020\"H\u0002\u00a2\u0006\u0004\b#\u0010$J/\u0010&\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\rH\u0014\u00a2\u0006\u0004\b&\u0010'J\u000f\u0010)\u001a\u00020(H\u0014\u00a2\u0006\u0004\b)\u0010*R\u0014\u0010\u001a\u001a\u00020+8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010,R\u0016\u0010.\u001a\u00020-8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b.\u0010/R\u0014\u00100\u001a\u00020\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b0\u00101R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u00102R\u0014\u00104\u001a\u0002038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b4\u00105R\u0014\u00107\u001a\u0002068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b7\u00108R\u0016\u00109\u001a\u00020\r8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b9\u0010:"}, d2={"Lorg/jetbrains/skiko/swing/MetalSwingRedrawer;", "Lorg/jetbrains/skiko/swing/SwingRedrawerBase;", "Lorg/jetbrains/skiko/swing/SwingLayerProperties;", "swingLayerProperties", "Lorg/jetbrains/skiko/SkikoRenderDelegate;", "renderDelegate", "Lorg/jetbrains/skiko/SkiaLayerAnalytics;", "analytics", "<init>", "(Lorg/jetbrains/skiko/swing/SwingLayerProperties;Lorg/jetbrains/skiko/SkikoRenderDelegate;Lorg/jetbrains/skiko/SkiaLayerAnalytics;)V", "", "dispose", "()V", "", "texture", "disposeMetalTexture", "(J)J", "Lorg/jetbrains/skia/Surface;", "surface", "Ljava/awt/Graphics2D;", "g", "flush", "(Lorg/jetbrains/skia/Surface;Ljava/awt/Graphics2D;)V", "Lorg/jetbrains/skia/DirectContext;", "makeMetalContext", "()Lorg/jetbrains/skia/DirectContext;", "adapter", "makeMetalRenderTargetOffScreen", "oldTexture", "", "width", "height", "makeMetalTexture", "(JJII)J", "Lorg/jetbrains/skia/BackendRenderTarget;", "makeRenderTarget", "()Lorg/jetbrains/skia/BackendRenderTarget;", "nanoTime", "onRender", "(Ljava/awt/Graphics2D;IIJ)V", "", "rendererInfo", "()Ljava/lang/String;", "Lorg/jetbrains/skiko/MetalAdapter;", "Lorg/jetbrains/skiko/MetalAdapter;", "", "bytesToDraw", "[B", "context", "Lorg/jetbrains/skia/DirectContext;", "Lorg/jetbrains/skiko/SkikoRenderDelegate;", "Lorg/jetbrains/skia/Bitmap;", "storage", "Lorg/jetbrains/skia/Bitmap;", "Lorg/jetbrains/skiko/swing/SwingOffscreenDrawer;", "swingOffscreenDrawer", "Lorg/jetbrains/skiko/swing/SwingOffscreenDrawer;", "texturePtr", "J", "Companion"})
@SourceDebugExtension(value={"SMAP\nMetalSwingRedrawer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MetalSwingRedrawer.kt\norg/jetbrains/skiko/swing/MetalSwingRedrawer\n+ 2 MetalApi.kt\norg/jetbrains/skiko/MetalApiKt\n*L\n1#1,124:1\n40#2,6:125\n*S KotlinDebug\n*F\n+ 1 MetalSwingRedrawer.kt\norg/jetbrains/skiko/swing/MetalSwingRedrawer\n*L\n58#1:125,6\n*E\n"})
public final class MetalSwingRedrawer
extends SwingRedrawerBase {
    public static final Companion Companion = new Companion(null);
    private final SkikoRenderDelegate renderDelegate;
    private final MetalAdapter adapter;
    private final DirectContext context;
    private long texturePtr;
    private final Bitmap storage;
    private byte[] bytesToDraw;
    private final SwingOffscreenDrawer swingOffscreenDrawer;

    /*
     * WARNING - void declaration
     */
    public MetalSwingRedrawer(SwingLayerProperties swingLayerProperties2, SkikoRenderDelegate renderDelegate, SkiaLayerAnalytics analytics) {
        void var1_1;
        void var3_3;
        MetalAdapter metalAdapter;
        Intrinsics.checkNotNullParameter((Object)swingLayerProperties2, (String)"swingLayerProperties");
        Intrinsics.checkNotNullParameter((Object)renderDelegate, (String)"renderDelegate");
        Intrinsics.checkNotNullParameter((Object)analytics, (String)"analytics");
        super(swingLayerProperties2, (SkiaLayerAnalytics)analytics, GraphicsApi.METAL);
        this.renderDelegate = metalAdapter;
        metalAdapter = MetalApiKt.chooseMetalAdapter(swingLayerProperties2.getAdapterPriority());
        analytics = metalAdapter;
        MetalSwingRedrawer metalSwingRedrawer = this;
        this.onDeviceChosen(var3_3.getName());
        metalSwingRedrawer.adapter = metalAdapter;
        this.context = this.makeMetalContext();
        this.storage = new Bitmap();
        this.bytesToDraw = new byte[0];
        this.onContextInit();
        this.swingOffscreenDrawer = new SwingOffscreenDrawer((SwingLayerProperties)var1_1);
    }

    @Override
    public final void dispose() {
        this.bytesToDraw = new byte[0];
        this.storage.close();
        MetalSwingRedrawer metalSwingRedrawer = this;
        metalSwingRedrawer.disposeMetalTexture(metalSwingRedrawer.texturePtr);
        this.context.close();
        MetalApiKt.dispose(this.adapter);
        super.dispose();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void onRender(Graphics2D g, int width2, int height2, long nanoTime) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        long handle$iv = MetalApiKt.access$openAutoreleasepool();
        try {
            void var1_1;
            void var3_4;
            void var2_3;
            ResourceUtilsKt.autoCloseScope((Function1<? super CloseScope, Unit>)((Function1)new Function1<CloseScope, Unit>(this, (int)var2_3, (int)var3_4, nanoTime, (Graphics2D)var1_1){
                final /* synthetic */ MetalSwingRedrawer this$0;
                final /* synthetic */ int $width;
                final /* synthetic */ int $height;
                final /* synthetic */ long $nanoTime;
                final /* synthetic */ Graphics2D $g;
                {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.this$0 = var1_1;
                    this.$width = var2_2;
                    this.$height = var3_3;
                    this.$nanoTime = $nanoTime;
                    this.$g = $g;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(CloseScope $this$autoCloseScope) {
                    void var1_1;
                    void var2_2;
                    Intrinsics.checkNotNullParameter((Object)$this$autoCloseScope, (String)"$this$autoCloseScope");
                    MetalSwingRedrawer.access$setTexturePtr$p(this.this$0, MetalSwingRedrawer.access$makeMetalTexture(this.this$0, MetalSwingRedrawer.access$getAdapter$p(this.this$0).getPtr(), MetalSwingRedrawer.access$getTexturePtr$p(this.this$0), this.$width, this.$height));
                    Managed renderTarget = (BackendRenderTarget)$this$autoCloseScope.autoClose((AutoCloseable)MetalSwingRedrawer.access$makeRenderTarget(this.this$0));
                    renderTarget = Surface.Companion.makeFromBackendRenderTarget(MetalSwingRedrawer.access$getContext$p(this.this$0), (BackendRenderTarget)renderTarget, SurfaceOrigin.TOP_LEFT, SurfaceColorFormat.BGRA_8888, ColorSpace.Companion.getSRGB(), new SurfaceProps(false, PixelGeometry.UNKNOWN, 1, null));
                    if (renderTarget == null || ($this$autoCloseScope = (Surface)$this$autoCloseScope.autoClose((AutoCloseable)renderTarget)) == null) {
                        throw new RenderException("Cannot create surface", null, 2, null);
                    }
                    Object surface = $this$autoCloseScope;
                    Canvas canvas = ((Surface)surface).getCanvas();
                    canvas.clear(0);
                    MetalSwingRedrawer.access$getRenderDelegate$p(this.this$0).onRender((Canvas)var2_2, this.$width, this.$height, this.$nanoTime);
                    MetalSwingRedrawer.access$flush(this.this$0, (Surface)var1_1, this.$g);
                }
            }));
            return;
        }
        finally {
            MetalApiKt.access$closeAutoreleasepool(handle$iv);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void flush(Surface surface, Graphics2D g) {
        void var1_1;
        surface.flushAndSubmit(true);
        int width2 = surface.getWidth();
        int height2 = surface.getHeight();
        int dstRowBytes = width2 * 4;
        if (this.storage.getWidth() != width2 || this.storage.getHeight() != height2) {
            this.storage.allocPixelsFlags(ImageInfo.Companion.makeS32(width2, height2, ColorAlphaType.PREMUL), false);
            this.bytesToDraw = new byte[Bitmap.getReadPixelsArraySize$skiko$default(this.storage, null, dstRowBytes, 0, 5, null)];
        }
        var1_1.readPixels(this.storage, 0, 0);
        boolean bl = Bitmap.readPixels$skiko$default(this.storage, this.bytesToDraw, null, dstRowBytes, 0, 0, 26, null);
        if (bl) {
            void var3_4;
            void var2_3;
            this.swingOffscreenDrawer.draw((Graphics2D)var2_3, this.bytesToDraw, (int)var3_4, height2);
        }
    }

    @Override
    protected final String rendererInfo() {
        return super.rendererInfo() + "Video card: " + this.adapter.getName() + "\nTotal VRAM: " + this.adapter.getMemorySize() / 1024L / 1024L + " MB\n";
    }

    private final BackendRenderTarget makeRenderTarget() {
        MetalSwingRedrawer metalSwingRedrawer = this;
        return new BackendRenderTarget(metalSwingRedrawer.makeMetalRenderTargetOffScreen(metalSwingRedrawer.texturePtr));
    }

    private final DirectContext makeMetalContext() {
        MetalSwingRedrawer metalSwingRedrawer = this;
        return new DirectContext(metalSwingRedrawer.makeMetalContext(metalSwingRedrawer.adapter.getPtr()));
    }

    private final native long makeMetalContext(long var1);

    private final native long makeMetalRenderTargetOffScreen(long var1);

    private final native long makeMetalTexture(long var1, long var3, int var5, int var6);

    private final native long disposeMetalTexture(long var1);

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setTexturePtr$p(MetalSwingRedrawer $this, long l) {
        void var1_1;
        $this.texturePtr = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ long access$makeMetalTexture(MetalSwingRedrawer $this, long adapter, long oldTexture, int width2, int height2) {
        void var3_2;
        void var1_1;
        return $this.makeMetalTexture((long)var1_1, (long)var3_2, width2, height2);
    }

    public static final /* synthetic */ MetalAdapter access$getAdapter$p(MetalSwingRedrawer $this) {
        return $this.adapter;
    }

    public static final /* synthetic */ long access$getTexturePtr$p(MetalSwingRedrawer $this) {
        return $this.texturePtr;
    }

    public static final /* synthetic */ BackendRenderTarget access$makeRenderTarget(MetalSwingRedrawer $this) {
        return $this.makeRenderTarget();
    }

    public static final /* synthetic */ DirectContext access$getContext$p(MetalSwingRedrawer $this) {
        return $this.context;
    }

    public static final /* synthetic */ SkikoRenderDelegate access$getRenderDelegate$p(MetalSwingRedrawer $this) {
        return $this.renderDelegate;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$flush(MetalSwingRedrawer $this, Surface surface, Graphics2D g) {
        void var2_2;
        void var1_1;
        $this.flush((Surface)var1_1, (Graphics2D)var2_2);
    }

    static {
        Library.INSTANCE.load();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003"}, d2={"Lorg/jetbrains/skiko/swing/MetalSwingRedrawer$Companion;", "", "<init>", "()V"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

