/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.websocket;

import io.ktor.websocket.FrameType;
import io.ktor.websocket.ProtocolViolationException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001:\u00015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0015\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\r\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\r\u0010\fJ\u0017\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000e\u0010\fJ\u0017\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000f\u0010\fR\u001e\u0010\u0012\u001a\f\u0012\b\u0012\u0006*\u00020\u00110\u00110\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R$\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\n8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R$\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\n8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u0019\u0010\u0016\u001a\u0004\b\u001a\u0010\u0018R$\u0010\u001b\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\n8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0016\u001a\u0004\b\u001c\u0010\u0018R$\u0010\u001d\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\n8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u001d\u0010\u0016\u001a\u0004\b\u001e\u0010\u0018R$\u0010\u001f\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\n8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u001f\u0010\u0016\u001a\u0004\b \u0010\u0018R\u0016\u0010\"\u001a\u00020!8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\u0016\u0010$\u001a\u00020!8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b$\u0010#R\u0016\u0010%\u001a\u00020!8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b%\u0010#R$\u0010'\u001a\u00020&2\u0006\u0010\u0014\u001a\u00020&8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b'\u0010(\u001a\u0004\b)\u0010*R(\u0010+\u001a\u0004\u0018\u00010!2\b\u0010\u0014\u001a\u0004\u0018\u00010!8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b+\u0010,\u001a\u0004\b-\u0010.R\u0011\u00102\u001a\u00020/8F\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u0011\u00104\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b3\u0010\u0018"}, d2={"Lio/ktor/websocket/FrameParser;", "", "<init>", "()V", "", "bodyComplete", "Ljava/nio/ByteBuffer;", "bb", "frame", "(Ljava/nio/ByteBuffer;)V", "", "handleStep", "(Ljava/nio/ByteBuffer;)Z", "parseHeader1", "parseLength", "parseMaskKey", "Ljava/util/concurrent/atomic/AtomicReference;", "Lio/ktor/websocket/FrameParser$State;", "state", "Ljava/util/concurrent/atomic/AtomicReference;", "value", "fin", "Z", "getFin", "()Z", "rsv1", "getRsv1", "rsv2", "getRsv2", "rsv3", "getRsv3", "mask", "getMask", "", "opcode", "I", "lastOpcode", "lengthLength", "", "length", "J", "getLength", "()J", "maskKey", "Ljava/lang/Integer;", "getMaskKey", "()Ljava/lang/Integer;", "Lio/ktor/websocket/FrameType;", "getFrameType", "()Lio/ktor/websocket/FrameType;", "frameType", "getBodyReady", "bodyReady", "State"})
@SourceDebugExtension(value={"SMAP\nFrameParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrameParser.kt\nio/ktor/websocket/FrameParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,154:1\n1#2:155\n*E\n"})
public final class FrameParser {
    private final AtomicReference<State> state = new AtomicReference<State>(State.HEADER0);
    private boolean fin;
    private boolean rsv1;
    private boolean rsv2;
    private boolean rsv3;
    private boolean mask;
    private int opcode;
    private int lastOpcode;
    private int lengthLength;
    private long length;
    private Integer maskKey;

    public final boolean getFin() {
        return this.fin;
    }

    public final boolean getRsv1() {
        return this.rsv1;
    }

    public final boolean getRsv2() {
        return this.rsv2;
    }

    public final boolean getRsv3() {
        return this.rsv3;
    }

    public final boolean getMask() {
        return this.mask;
    }

    public final long getLength() {
        return this.length;
    }

    public final Integer getMaskKey() {
        return this.maskKey;
    }

    public final FrameType getFrameType() {
        FrameType frameType = FrameType.Companion.get(this.opcode);
        if (frameType == null) {
            throw new IllegalStateException("Unsupported opcode " + Integer.toHexString(this.opcode));
        }
        return frameType;
    }

    public final boolean getBodyReady() {
        return this.state.get() == State.BODY;
    }

    public final void bodyComplete() {
        if (!this.state.compareAndSet(State.BODY, State.HEADER0)) {
            throw new IllegalStateException("It should be state BODY but it is " + (Object)((Object)this.state.get()));
        }
        this.opcode = 0;
        this.length = 0L;
        this.lengthLength = 0;
        this.maskKey = null;
    }

    public final void frame(ByteBuffer bb) {
        Intrinsics.checkNotNullParameter((Object)bb, (String)"bb");
        if (!Intrinsics.areEqual((Object)((ByteBuffer)bb).order(), (Object)ByteOrder.BIG_ENDIAN)) {
            bb = "Buffer order should be BIG_ENDIAN but it is " + ((ByteBuffer)bb).order();
            throw new IllegalArgumentException(bb.toString());
        }
        while (this.handleStep((ByteBuffer)bb)) {
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean handleStep(ByteBuffer bb) {
        State state = this.state.get();
        Intrinsics.checkNotNull((Object)((Object)state));
        switch (WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
            case 1: {
                return this.parseHeader1(bb);
            }
            case 2: {
                return this.parseLength(bb);
            }
            case 3: {
                void var1_1;
                return this.parseMaskKey((ByteBuffer)var1_1);
            }
            case 4: {
                return false;
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    /*
     * WARNING - void declaration
     */
    private final boolean parseHeader1(ByteBuffer bb) {
        void var1_2;
        int n;
        void var2_3;
        if (bb.remaining() < 2) {
            return false;
        }
        byte flagsAndOpcode = bb.get();
        byte maskAndLength1 = bb.get();
        this.fin = (flagsAndOpcode & 0x80) != 0;
        this.rsv1 = (flagsAndOpcode & 0x40) != 0;
        this.rsv2 = (flagsAndOpcode & 0x20) != 0;
        this.rsv3 = (flagsAndOpcode & 0x10) != 0;
        this.opcode = var2_3 & 0xF;
        if (this.opcode == 0 && this.lastOpcode == 0) {
            throw new ProtocolViolationException("Can't continue finished frames");
        }
        if (this.opcode == 0) {
            this.opcode = this.lastOpcode;
        } else if (this.lastOpcode != 0 && !this.getFrameType().getControlFrame()) {
            throw new ProtocolViolationException("Can't start new data frame before finishing previous one");
        }
        if (!this.getFrameType().getControlFrame()) {
            this.lastOpcode = this.fin ? 0 : this.opcode;
        } else if (!this.fin) {
            throw new ProtocolViolationException("control frames can't be fragmented");
        }
        this.mask = (maskAndLength1 & 0x80) != 0;
        int length1 = maskAndLength1 & 0x7F;
        if (this.getFrameType().getControlFrame() && length1 > 125) {
            throw new ProtocolViolationException("control frames can't be larger than 125 bytes");
        }
        switch (length1) {
            case 126: {
                n = 2;
                break;
            }
            case 127: {
                n = 8;
                break;
            }
            default: {
                n = 0;
            }
        }
        this.lengthLength = n;
        long l = this.length = this.lengthLength == 0 ? (long)var1_2 : 0L;
        if (this.lengthLength > 0) {
            this.state.set(State.LENGTH);
        } else if (this.mask) {
            this.state.set(State.MASK_KEY);
        } else {
            this.state.set(State.BODY);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean parseLength(ByteBuffer bb) {
        void var1_1;
        long l;
        if (bb.remaining() < this.lengthLength) {
            return false;
        }
        switch (this.lengthLength) {
            case 2: {
                l = (long)bb.getShort() & 0xFFFFL;
                break;
            }
            case 8: {
                l = bb.getLong();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.length = l;
        State mask = this.mask ? State.MASK_KEY : State.BODY;
        this.state.set((State)var1_1);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean parseMaskKey(ByteBuffer bb) {
        void var1_1;
        if (bb.remaining() < 4) {
            return false;
        }
        this.maskKey = var1_1.getInt();
        this.state.set(State.BODY);
        return true;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007"}, d2={"Lio/ktor/websocket/FrameParser$State;", "", "<init>", "(Ljava/lang/String;I)V", "HEADER0", "LENGTH", "MASK_KEY", "BODY"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State HEADER0 = new State();
        public static final /* enum */ State LENGTH = new State();
        public static final /* enum */ State MASK_KEY = new State();
        public static final /* enum */ State BODY = new State();
        private static final /* synthetic */ State[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        /*
         * WARNING - void declaration
         */
        private State() {
            void var2_2;
            void var1_1;
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            String string;
            return Enum.valueOf(State.class, string);
        }

        public static EnumEntries<State> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ State[] $values() {
            State[] stateArray = new State[4];
            State[] stateArray2 = stateArray;
            stateArray[0] = HEADER0;
            stateArray2[1] = LENGTH;
            stateArray2[2] = MASK_KEY;
            stateArray2[3] = BODY;
            return stateArray2;
        }

        static {
            $VALUES = State.$values();
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[State.values().length];
            try {
                nArray[State.HEADER0.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[State.LENGTH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[State.MASK_KEY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[State.BODY.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

