/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;

public abstract class AbstractByteArrayOutputStream
extends OutputStream {
    private final List<byte[]> buffers = new ArrayList<byte[]>();
    private int currentBufferIndex;
    private int filledBufferSum;
    private byte[] currentBuffer;
    protected int count;
    private boolean reuseBuffers = true;

    @Override
    public void close() throws IOException {
    }

    /*
     * WARNING - void declaration
     */
    protected final void needNewBuffer(int newCount) {
        void var1_1;
        if (this.currentBufferIndex < this.buffers.size() - 1) {
            this.filledBufferSum += this.currentBuffer.length;
            ++this.currentBufferIndex;
            this.currentBuffer = this.buffers.get(this.currentBufferIndex);
            return;
        }
        if (this.currentBuffer == null) {
            this.filledBufferSum = 0;
        } else {
            int newBufferSize;
            newBufferSize = Math.max(this.currentBuffer.length << 1, (int)(newBufferSize - this.filledBufferSum));
            this.filledBufferSum += this.currentBuffer.length;
        }
        ++this.currentBufferIndex;
        this.currentBuffer = IOUtils.byteArray((int)var1_1);
        this.buffers.add(this.currentBuffer);
    }

    public abstract byte[] toByteArray();

    /*
     * WARNING - void declaration
     */
    protected final byte[] toByteArrayImpl() {
        void var2_2;
        int remaining = this.count;
        if (remaining == 0) {
            return IOUtils.EMPTY_BYTE_ARRAY;
        }
        byte[] newBuf = IOUtils.byteArray(remaining);
        int pos = 0;
        for (byte[] buf : this.buffers) {
            int c = Math.min(buf.length, remaining);
            System.arraycopy(buf, 0, newBuf, pos, c);
            pos += c;
            if ((remaining -= c) != 0) continue;
        }
        return var2_2;
    }

    @Deprecated
    public String toString() {
        return new String(this.toByteArray(), Charset.defaultCharset());
    }

    protected final void writeImpl(byte[] b, int off, int len) {
        int newCount = this.count + len;
        int remaining = len;
        int inBufferPos = this.count - this.filledBufferSum;
        while (remaining > 0) {
            int part = Math.min(remaining, this.currentBuffer.length - inBufferPos);
            System.arraycopy(b, off + len - remaining, this.currentBuffer, inBufferPos, part);
            if ((remaining -= part) <= 0) continue;
            this.needNewBuffer(newCount);
            inBufferPos = 0;
        }
        this.count = newCount;
    }

    /*
     * WARNING - void declaration
     */
    protected final void writeImpl(int b) {
        void var1_1;
        int inBufferPos = this.count - this.filledBufferSum;
        if (inBufferPos == this.currentBuffer.length) {
            AbstractByteArrayOutputStream abstractByteArrayOutputStream = this;
            abstractByteArrayOutputStream.needNewBuffer(abstractByteArrayOutputStream.count + 1);
            inBufferPos = 0;
        }
        this.currentBuffer[var2_2] = (byte)var1_1;
        ++this.count;
    }
}

