/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.FromNativeContext;
import com.sun.jna.Klass;
import com.sun.jna.NativeMapped;

public abstract class IntegerType
extends Number
implements NativeMapped {
    private static final long serialVersionUID = 1L;
    private int size;
    private Number number;
    private boolean unsigned;
    private long value;

    /*
     * WARNING - void declaration
     */
    public IntegerType(int size) {
        this((int)var1_1, 0L, false);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public IntegerType(int size, boolean unsigned) {
        this((int)var1_1, 0L, (boolean)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public IntegerType(int size, long value) {
        this((int)var1_1, (long)var2_2, false);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public IntegerType(int size, long value, boolean unsigned) {
        void var2_2;
        void var1_1;
        this.size = var1_1;
        this.unsigned = unsigned;
        this.setValue((long)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void setValue(long value) {
        long truncated = value;
        this.value = value;
        switch (this.size) {
            case 1: {
                if (this.unsigned) {
                    this.value = value & 0xFFL;
                }
                truncated = (byte)value;
                this.number = (byte)value;
                break;
            }
            case 2: {
                if (this.unsigned) {
                    this.value = value & 0xFFFFL;
                }
                truncated = (short)value;
                this.number = (short)value;
                break;
            }
            case 4: {
                if (this.unsigned) {
                    this.value = value & 0xFFFFFFFFL;
                }
                truncated = (int)value;
                this.number = (int)value;
                break;
            }
            case 8: {
                this.number = value;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported size: " + this.size);
            }
        }
        if (this.size < 8) {
            void var3_2;
            long mask = (1L << this.size * 8) - 1L ^ 0xFFFFFFFFFFFFFFFFL;
            if (value < 0L && var3_2 != value || value >= 0L && (mask & value) != 0L) {
                void var1_1;
                throw new IllegalArgumentException("Argument value 0x" + Long.toHexString((long)var1_1) + " exceeds native capacity (" + this.size + " bytes) mask=0x" + Long.toHexString(mask));
            }
        }
    }

    @Override
    public Object toNative() {
        return this.number;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object fromNative(Object nativeValue, FromNativeContext context) {
        void var1_1;
        void var3_3;
        long value = nativeValue == null ? 0L : ((Number)nativeValue).longValue();
        IntegerType number = (IntegerType)Klass.newInstance(this.getClass());
        number.setValue((long)var3_3);
        return var1_1;
    }

    @Override
    public Class<?> nativeType() {
        return this.number.getClass();
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.number.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.number.doubleValue();
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object rhs) {
        void var1_1;
        return rhs instanceof IntegerType && this.number.equals(((IntegerType)var1_1).number);
    }

    public String toString() {
        return this.number.toString();
    }

    public int hashCode() {
        return this.number.hashCode();
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends IntegerType> int compare(T v1, T v2) {
        void var1_1;
        T t;
        if (v1 == v2) {
            return 0;
        }
        if (v1 == null) {
            return 1;
        }
        if (v2 == null) {
            return -1;
        }
        return IntegerType.compare(t.longValue(), var1_1.longValue());
    }

    /*
     * WARNING - void declaration
     */
    public static int compare(IntegerType v1, long v2) {
        void var1_1;
        IntegerType integerType;
        if (v1 == null) {
            return 1;
        }
        return IntegerType.compare(integerType.longValue(), (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static final int compare(long v1, long v2) {
        void var2_1;
        long l;
        if (v1 == v2) {
            return 0;
        }
        if (l < var2_1) {
            return -1;
        }
        return 1;
    }
}

