/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics;

import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@SourceDebugExtension(value={"SMAP\nBezier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Bezier.kt\nandroidx/compose/ui/graphics/BezierKt\n+ 2 MathHelpers.kt\nandroidx/compose/ui/util/MathHelpersKt\n*L\n1#1,1120:1\n230#1:1121\n571#1,7:1122\n571#1,7:1129\n571#1,7:1136\n571#1,7:1143\n571#1,7:1150\n560#1:1157\n560#1:1158\n560#1:1159\n571#1,7:1160\n571#1,7:1167\n571#1,7:1174\n571#1,7:1197\n571#1,7:1204\n571#1,7:1211\n571#1,7:1218\n571#1,7:1225\n571#1,7:1232\n359#1:1239\n359#1:1240\n1094#1:1241\n1094#1:1242\n1108#1:1243\n1108#1:1244\n359#1:1245\n571#1,7:1246\n563#1:1253\n563#1:1256\n97#2,16:1181\n49#2:1254\n60#2:1255\n71#2,16:1257\n*S KotlinDebug\n*F\n+ 1 Bezier.kt\nandroidx/compose/ui/graphics/BezierKt\n*L\n201#1:1121\n201#1:1122,7\n230#1:1129,7\n254#1:1136,7\n257#1:1143,7\n259#1:1150,7\n293#1:1157\n295#1:1158\n297#1:1159\n300#1:1160,7\n305#1:1167,7\n308#1:1174,7\n329#1:1197,7\n332#1:1204,7\n335#1:1211,7\n339#1:1218,7\n342#1:1225,7\n349#1:1232,7\n442#1:1239\n461#1:1240\n484#1:1241\n485#1:1242\n511#1:1243\n512#1:1244\n544#1:1245\n586#1:1246,7\n726#1:1253\n910#1:1256\n325#1:1181,16\n889#1:1254\n892#1:1255\n950#1:1257,16\n*E\n"})
public final class BezierKt {
    public static final long computeCubicVerticalBounds(float p0y, float p1y, float p2y, float p3y, float[] roots, int index) {
        float f;
        int index$iv;
        Intrinsics.checkNotNullParameter((Object)roots, (String)"roots");
        float d0 = 3.0f * (p1y - 0.0f);
        float d1 = 3.0f * (p2y - p1y);
        float d2 = 3.0f * (1.0f - p2y);
        int n = 0;
        float[] fArray = roots;
        float f2 = d2;
        float f3 = d1;
        float f4 = d0;
        double d = f4;
        double d3 = f3;
        double d4 = f2;
        double d5 = d - 2.0 * d3 + d4;
        int n2 = 0;
        if (!(d5 == 0.0)) {
            double d6 = d3;
            double d7 = -Math.sqrt(d6 * d6 - d * d4);
            double d8 = -d + d3;
            n2 = 0 + BezierKt.writeValidRootInUnitRange((float)(-(d7 + d8) / d5), fArray, n);
            if ((n2 += BezierKt.writeValidRootInUnitRange((float)((d7 - d8) / d5), fArray, n + n2)) > 1) {
                f4 = fArray[n];
                f3 = fArray[n + 1];
                if (f4 > f3) {
                    fArray[n] = f3;
                    fArray[n + 1] = f4;
                } else if (f4 == f3) {
                    --n2;
                }
            }
        } else if (!(d3 == d4)) {
            n2 = 0 + BezierKt.writeValidRootInUnitRange((float)((2.0 * d3 - d4) / (2.0 * d3 - 2.0 * d4)), fArray, n);
        }
        int count = n2;
        float dd0 = 2.0f * (d1 - d0);
        float dd1 = 2.0f * (d2 - d1);
        int n3 = index$iv = 0 + count;
        float[] fArray2 = roots;
        f4 = -dd0 / (dd1 - dd0);
        float minY = Math.min(0.0f, 1.0f);
        float maxY = Math.max(0.0f, 1.0f);
        n2 = count += BezierKt.writeValidRootInUnitRange(f4, fArray2, n3);
        for (int i = 0; i < n2; ++i) {
            float t;
            float f5 = t = roots[i];
            float f6 = 1.0f;
            float f7 = p2y;
            float f8 = p1y;
            t = 0.0f;
            float f9 = f6 + 3.0f * (f8 - f7) - t;
            float f10 = 3.0f * (f7 - 2.0f * f8 + t);
            float f11 = 3.0f * (f8 - t);
            float y = ((f9 * f5 + f10) * f5 + f11) * f5 + t;
            minY = Math.min(minY, y);
            maxY = Math.max(maxY, y);
        }
        float f12 = f;
        f4 = minY;
        long l = Float.floatToRawIntBits(f4);
        long l2 = Float.floatToRawIntBits(f12);
        long l3 = l << 32 | l2 & 0xFFFFFFFFL;
        return l3;
    }

    private static final int writeValidRootInUnitRange(float r, float[] roots, int index) {
        float f;
        float v;
        var1_1[var2_2] = v = r < 0.0f ? (r >= -8.34465E-7f ? 0.0f : Float.NaN) : (r > 1.0f ? (r <= 1.0000008f ? 1.0f : Float.NaN) : v);
        if (Float.isNaN(f)) {
            return 0;
        }
        return 1;
    }
}

