/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http;

import java.io.EOFException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Challenge;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Response;
import okhttp3.internal.Util;
import okhttp3.internal.platform.Platform;
import okio.Buffer;
import okio.ByteString;

@JvmName(name="HttpHeaders")
public final class HttpHeaders {
    private static final ByteString QUOTED_STRING_DELIMITERS = ByteString.Companion.encodeUtf8("\"\\");
    private static final ByteString TOKEN_DELIMITERS = ByteString.Companion.encodeUtf8("\t ,=");

    /*
     * WARNING - void declaration
     */
    public static final List<Challenge> parseChallenges(Headers $this$parseChallenges, String headerName) {
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)$this$parseChallenges, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)headerName, (String)"headerName");
        List result = new ArrayList();
        int n = $this$parseChallenges.size();
        block2: for (int h = 0; h < n; ++h) {
            if (!StringsKt.equals((String)headerName, (String)$this$parseChallenges.name(h), (boolean)true)) continue;
            Buffer header = new Buffer().writeUtf8($this$parseChallenges.value(h));
            try {
                List list = result;
                String string = null;
                while (true) {
                    Map map;
                    String string2;
                    block15: {
                        Object object;
                        if (string == null) {
                            HttpHeaders.skipCommasAndWhitespace(header);
                            string = HttpHeaders.readToken(header);
                            if (string == null) continue block2;
                        }
                        string2 = string;
                        boolean bl = HttpHeaders.skipCommasAndWhitespace(header);
                        string = HttpHeaders.readToken(header);
                        if (string == null) {
                            if (!header.exhausted()) continue block2;
                            list.add(new Challenge(string2, MapsKt.emptyMap()));
                            continue block2;
                        }
                        int n2 = Util.skipAll(header, (byte)61);
                        boolean bl2 = HttpHeaders.skipCommasAndWhitespace(header);
                        if (!bl && (bl2 || header.exhausted())) {
                            Map<Object, String> map2 = Collections.singletonMap(null, string + StringsKt.repeat((CharSequence)"=", (int)n2));
                            Intrinsics.checkNotNullExpressionValue(map2, (String)"singletonMap<String, Str\u2026ek + \"=\".repeat(eqCount))");
                            list.add(new Challenge(string2, map2));
                            string = null;
                            continue;
                        }
                        map = new LinkedHashMap();
                        n2 += Util.skipAll(header, (byte)61);
                        do {
                            String string3;
                            block16: {
                                if (string == null) {
                                    string = HttpHeaders.readToken(header);
                                    if (HttpHeaders.skipCommasAndWhitespace(header)) break block15;
                                    n2 = Util.skipAll(header, (byte)61);
                                }
                                if (n2 == 0) break block15;
                                if (n2 > 1 || HttpHeaders.skipCommasAndWhitespace(header)) continue block2;
                                int n3 = 34;
                                object = header;
                                if (!object.exhausted() && object.getByte(0L) == 34) {
                                    object = header;
                                    if (!(object.readByte() == 34)) {
                                        String string4 = "Failed requirement.";
                                        throw new IllegalArgumentException(string4.toString());
                                    }
                                    Buffer buffer = new Buffer();
                                    while (true) {
                                        long l;
                                        if ((l = object.indexOfElement(QUOTED_STRING_DELIMITERS)) == -1L) {
                                            string3 = null;
                                            break block16;
                                        }
                                        if (object.getByte(l) == 34) {
                                            buffer.write(object, l);
                                            object.readByte();
                                            string3 = buffer.readUtf8();
                                            break block16;
                                        }
                                        if (object.size() == l + 1L) {
                                            string3 = null;
                                            break block16;
                                        }
                                        buffer.write(object, l);
                                        object.readByte();
                                        buffer.write(object, 1L);
                                    }
                                }
                                string3 = HttpHeaders.readToken(header);
                            }
                            if (string3 == null) continue block2;
                            object = string3;
                            object = (String)map.put(string, object);
                            string = null;
                        } while (object == null && (HttpHeaders.skipCommasAndWhitespace(header) || header.exhausted()));
                        continue block2;
                    }
                    list.add(new Challenge(string2, map));
                }
            }
            catch (EOFException e) {
                Platform.Companion.get();
                Platform.log("Unable to parse challenge", 5, e);
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean skipCommasAndWhitespace(Buffer $this$skipCommasAndWhitespace) {
        void var1_1;
        boolean commaFound = false;
        while (!$this$skipCommasAndWhitespace.exhausted()) {
            byte by = $this$skipCommasAndWhitespace.getByte(0L);
            if (by == 44) {
                $this$skipCommasAndWhitespace.readByte();
                commaFound = true;
                continue;
            }
            if (!(by == 32 ? true : by == 9)) break;
            $this$skipCommasAndWhitespace.readByte();
        }
        return (boolean)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static final String readToken(Buffer $this$readToken) {
        long tokenSize = $this$readToken.indexOfElement(TOKEN_DELIMITERS);
        if (tokenSize == -1L) {
            tokenSize = $this$readToken.size();
        }
        if (tokenSize != 0L) {
            void var1_1;
            Buffer buffer;
            return buffer.readUtf8((long)var1_1);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static final void receiveHeaders(CookieJar $this$receiveHeaders, HttpUrl url, Headers headers) {
        void var2_2;
        void var1_1;
        CookieJar cookieJar;
        Intrinsics.checkNotNullParameter((Object)$this$receiveHeaders, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        if ($this$receiveHeaders == CookieJar.NO_COOKIES) {
            return;
        }
        List<Cookie> cookies = Cookie.Companion.parseAll(url, headers);
        if (cookies.isEmpty()) {
            return;
        }
        cookieJar.saveFromResponse((HttpUrl)var1_1, (List<Cookie>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean promisesBody(Response $this$promisesBody) {
        Response response;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)$this$promisesBody, (String)"<this>");
        if (Intrinsics.areEqual((Object)$this$promisesBody.request().method(), (Object)"HEAD")) {
            return false;
        }
        int responseCode = $this$promisesBody.code();
        if ((responseCode < 100 || responseCode >= 200) && responseCode != 204 && var1_1 != 304) {
            return true;
        }
        return Util.headersContentLength($this$promisesBody) != -1L || StringsKt.equals((String)"chunked", (String)Response.header$default$b4243d8(response, "Transfer-Encoding", null, 2), (boolean)true);
    }
}

