/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import kotlin.ExceptionsKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Address;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.CertificatePinner;
import okhttp3.Connection;
import okhttp3.Dispatcher;
import okhttp3.EventListener;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.internal.Util;
import okhttp3.internal.cache.CacheInterceptor;
import okhttp3.internal.connection.ConnectInterceptor;
import okhttp3.internal.connection.Exchange;
import okhttp3.internal.connection.ExchangeFinder;
import okhttp3.internal.connection.RealCall;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.connection.RealConnectionPool;
import okhttp3.internal.http.BridgeInterceptor;
import okhttp3.internal.http.CallServerInterceptor;
import okhttp3.internal.http.ExchangeCodec;
import okhttp3.internal.http.RealInterceptorChain;
import okhttp3.internal.http.RetryAndFollowUpInterceptor;
import okhttp3.internal.platform.Platform;
import okio.AsyncTimeout;

@SourceDebugExtension(value={"SMAP\nRealCall.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RealCall.kt\nokhttp3/internal/connection/RealCall\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Util.kt\nokhttp3/internal/Util\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,551:1\n1#2:552\n608#3,4:553\n615#3,4:557\n615#3,4:561\n608#3,4:565\n350#4,7:569\n*S KotlinDebug\n*F\n+ 1 RealCall.kt\nokhttp3/internal/connection/RealCall\n*L\n269#1:553,4\n344#1:557,4\n348#1:561,4\n375#1:565,4\n378#1:569,7\n*E\n"})
public final class RealCall
implements Call {
    private final OkHttpClient client;
    private final Request originalRequest;
    private final boolean forWebSocket;
    private final RealConnectionPool connectionPool;
    private final EventListener eventListener;
    private final timeout.1 timeout;
    private final AtomicBoolean executed;
    private Object callStackTrace;
    private ExchangeFinder exchangeFinder;
    private RealConnection connection;
    private boolean timeoutEarlyExit;
    private Exchange interceptorScopedExchange;
    private boolean requestBodyOpen;
    private boolean responseBodyOpen;
    private boolean expectMoreExchanges;
    private volatile boolean canceled;
    private volatile Exchange exchange;
    private volatile RealConnection connectionToCancel;

    /*
     * WARNING - void declaration
     */
    public RealCall(OkHttpClient client, Request originalRequest, boolean forWebSocket) {
        void var2_2;
        void var3_3;
        AsyncTimeout asyncTimeout;
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)originalRequest, (String)"originalRequest");
        this.client = asyncTimeout;
        this.originalRequest = originalRequest;
        this.forWebSocket = var3_3;
        this.connectionPool = this.client.connectionPool().getDelegate$okhttp();
        this.eventListener = this.client.eventListenerFactory().create(this);
        AsyncTimeout $this$timeout_u24lambda_u240 = asyncTimeout = new AsyncTimeout(this){
            final /* synthetic */ RealCall this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            protected final void timedOut() {
                this.this$0.cancel();
            }
        };
        RealCall realCall = this;
        var2_2.timeout((long)this.client.callTimeoutMillis(), TimeUnit.MILLISECONDS);
        realCall.timeout = asyncTimeout;
        this.executed = new AtomicBoolean();
        this.expectMoreExchanges = true;
    }

    public final OkHttpClient getClient() {
        return this.client;
    }

    public final Request getOriginalRequest() {
        return this.originalRequest;
    }

    public final boolean getForWebSocket() {
        return this.forWebSocket;
    }

    public final EventListener getEventListener$okhttp() {
        return this.eventListener;
    }

    public final RealConnection getConnection() {
        return this.connection;
    }

    public final Exchange getInterceptorScopedExchange$okhttp() {
        return this.interceptorScopedExchange;
    }

    /*
     * WARNING - void declaration
     */
    public final void setConnectionToCancel(RealConnection realConnection) {
        void var1_1;
        this.connectionToCancel = var1_1;
    }

    @Override
    public final void cancel() {
        if (this.canceled) {
            return;
        }
        this.canceled = true;
        Exchange exchange = this.exchange;
        if (exchange != null) {
            exchange.cancel();
        }
        RealConnection realConnection = this.connectionToCancel;
        if (realConnection != null) {
            realConnection.cancel();
        }
        EventListener.canceled(this);
    }

    @Override
    public final boolean isCanceled() {
        return this.canceled;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void enqueue(Callback responseCallback) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)responseCallback, (String)"responseCallback");
        if (!this.executed.compareAndSet(false, true)) {
            responseCallback = "Already Executed";
            throw new IllegalStateException(responseCallback.toString());
        }
        RealCall realCall = this;
        this.callStackTrace = Platform.Companion.get().getStackTraceForCloseable("response.body().close()");
        EventListener cfr_ignored_0 = realCall.eventListener;
        EventListener.callStart(realCall);
        this.client.dispatcher().enqueue$okhttp(new AsyncCall(this, (Callback)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final Response getResponseWithInterceptorChain$okhttp() throws IOException {
        Response response;
        List interceptors = new ArrayList();
        CollectionsKt.addAll((Collection)interceptors, (Iterable)this.client.interceptors());
        ((Collection)interceptors).add(new RetryAndFollowUpInterceptor(this.client));
        ((Collection)interceptors).add(new BridgeInterceptor(this.client.cookieJar()));
        ((Collection)interceptors).add(new CacheInterceptor(this.client.cache()));
        ((Collection)interceptors).add(ConnectInterceptor.INSTANCE);
        if (!this.forWebSocket) {
            CollectionsKt.addAll((Collection)interceptors, (Iterable)this.client.networkInterceptors());
        }
        ((Collection)interceptors).add(new CallServerInterceptor(this.forWebSocket));
        RealInterceptorChain chain = new RealInterceptorChain(this, interceptors, 0, null, this.originalRequest, this.client.connectTimeoutMillis(), this.client.readTimeoutMillis(), this.client.writeTimeoutMillis());
        boolean calledNoMoreExchanges = false;
        try {
            response = chain.proceed(this.originalRequest);
            RealCall realCall = this;
            if (realCall.canceled) {
                Util.closeQuietly(response);
                throw new IOException("Canceled");
            }
            this.noMoreExchanges$okhttp(null);
        }
        catch (IOException e) {
            try {
                void var1_2;
                calledNoMoreExchanges = true;
                IOException iOException = this.noMoreExchanges$okhttp((IOException)var1_2);
                Intrinsics.checkNotNull((Object)iOException, (String)"null cannot be cast to non-null type kotlin.Throwable");
                throw (Throwable)iOException;
            }
            catch (Throwable throwable) {
                void var2_4;
                if (var2_4 == false) {
                    this.noMoreExchanges$okhttp(null);
                }
                throw throwable;
            }
        }
        return response;
    }

    /*
     * WARNING - void declaration
     */
    public final void enterNetworkInterceptorExchange(Request request, boolean newExchangeFinder) {
        void var2_3;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (!(this.interceptorScopedExchange == null)) {
            request = "Check failed.";
            throw new IllegalStateException(request.toString());
        }
        Object object = this;
        synchronized (object) {
            if (!(!this.responseBodyOpen)) {
                request = "cannot make a new request because the previous response is still open: please call response.close()";
                throw new IllegalStateException(request.toString());
            }
            if (!(!this.requestBodyOpen)) {
                request = "Check failed.";
                throw new IllegalStateException(request.toString());
            }
        }
        if (var2_3 != false) {
            RealCall realCall;
            HttpUrl httpUrl = ((Request)((Object)realCall)).url();
            realCall = this;
            object = null;
            HostnameVerifier hostnameVerifier = null;
            CertificatePinner certificatePinner = null;
            if (httpUrl.isHttps()) {
                object = realCall.client.sslSocketFactory();
                hostnameVerifier = realCall.client.hostnameVerifier();
                certificatePinner = realCall.client.certificatePinner();
            }
            RealCall realCall2 = this;
            this.exchangeFinder = new ExchangeFinder(this.connectionPool, new Address(httpUrl.host(), httpUrl.port(), realCall.client.dns(), realCall.client.socketFactory(), (SSLSocketFactory)object, hostnameVerifier, certificatePinner, realCall.client.proxyAuthenticator(), realCall.client.proxy(), realCall.client.protocols(), realCall.client.connectionSpecs(), realCall.client.proxySelector()), realCall2, realCall2.eventListener);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final Exchange initExchange$okhttp(RealInterceptorChain chain) {
        void var1_1;
        Exchange result;
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        RealCall realCall = this;
        synchronized (realCall) {
            if (!this.expectMoreExchanges) {
                chain = "released";
                throw new IllegalStateException(chain.toString());
            }
            if (!(!this.responseBodyOpen)) {
                chain = "Check failed.";
                throw new IllegalStateException(chain.toString());
            }
            if (!(!this.requestBodyOpen)) {
                chain = "Check failed.";
                throw new IllegalStateException(chain.toString());
            }
        }
        ExchangeFinder exchangeFinder = this.exchangeFinder;
        Intrinsics.checkNotNull((Object)exchangeFinder);
        ExchangeFinder exchangeFinder2 = exchangeFinder;
        ExchangeCodec codec = exchangeFinder.find(this.client, (RealInterceptorChain)chain);
        RealCall realCall2 = this;
        this.interceptorScopedExchange = result = new Exchange(realCall2, realCall2.eventListener, (ExchangeFinder)((Object)realCall), codec);
        this.exchange = result;
        realCall = this;
        synchronized (realCall) {
            this.requestBodyOpen = true;
            this.responseBodyOpen = true;
        }
        if (this.canceled) {
            throw new IOException("Canceled");
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void acquireConnectionNoEvents(RealConnection connection) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        RealConnection $this$assertThreadHoldsLock$iv = connection;
        if (Util.assertionsEnabled && !Thread.holdsLock($this$assertThreadHoldsLock$iv)) {
            void var2_2;
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + var2_2));
        }
        if (!(this.connection == null)) {
            connection = "Check failed.";
            throw new IllegalStateException(connection.toString());
        }
        this.connection = connection;
        RealCall realCall = this;
        var1_1.getCalls().add(new CallReference(realCall, realCall.callStackTrace));
    }

    /*
     * WARNING - void declaration
     */
    public final <E extends IOException> E messageDone$okhttp(Exchange exchange, boolean requestDone, boolean responseDone, E e) {
        void var1_2;
        Intrinsics.checkNotNullParameter((Object)exchange, (String)"exchange");
        if (!Intrinsics.areEqual((Object)exchange, (Object)this.exchange)) {
            return e;
        }
        boolean bothStreamsDone = false;
        boolean callDone = false;
        RealCall realCall = this;
        synchronized (realCall) {
            if (requestDone && this.requestBodyOpen || responseDone && this.responseBodyOpen) {
                void var3_5;
                void var2_4;
                if (var2_4 != false) {
                    this.requestBodyOpen = false;
                }
                if (var3_5 != false) {
                    this.responseBodyOpen = false;
                }
                bothStreamsDone = !this.requestBodyOpen && !this.responseBodyOpen;
                callDone = !this.requestBodyOpen && !this.responseBodyOpen && !this.expectMoreExchanges;
            }
        }
        if (var1_2 != false) {
            this.exchange = null;
            RealConnection realConnection = this.connection;
            if (realConnection != null) {
                realConnection.incrementSuccessCount$okhttp();
            }
        }
        if (callDone) {
            return this.callDone(e);
        }
        return e;
    }

    /*
     * WARNING - void declaration
     */
    public final IOException noMoreExchanges$okhttp(IOException e) {
        void var1_1;
        void var2_3;
        boolean callDone = false;
        RealCall realCall = this;
        synchronized (realCall) {
            if (this.expectMoreExchanges) {
                this.expectMoreExchanges = false;
                callDone = !this.requestBodyOpen && !this.responseBodyOpen;
            }
        }
        if (var2_3 != false) {
            return this.callDone(e);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private final <E extends IOException> E callDone(E e) {
        void var3_3;
        void var1_1;
        E result;
        Object object;
        Object object2;
        Object socket;
        RealCall $this$assertThreadDoesntHoldLock$iv = this;
        if (Util.assertionsEnabled && Thread.holdsLock($this$assertThreadDoesntHoldLock$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertThreadDoesntHoldLock$iv));
        }
        RealConnection connection = this.connection;
        if (connection != null) {
            Object object3;
            RealConnection $this$assertThreadDoesntHoldLock$iv2 = connection;
            if (Util.assertionsEnabled && Thread.holdsLock($this$assertThreadDoesntHoldLock$iv2)) {
                throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertThreadDoesntHoldLock$iv2));
            }
            $this$assertThreadDoesntHoldLock$iv2 = connection;
            synchronized ($this$assertThreadDoesntHoldLock$iv2) {
                object3 = this.releaseConnectionNoEvents$okhttp();
            }
            socket = object3;
            if (this.connection == null) {
                Object object4 = socket;
                if (object4 != null) {
                    Util.closeQuietly(object4);
                }
                EventListener.connectionReleased(this, (Connection)object2);
            } else if (!(socket == null)) {
                object3 = "Check failed.";
                throw new IllegalStateException(object3.toString());
            }
        }
        socket = e;
        object2 = this;
        if (((RealCall)object2).timeoutEarlyExit) {
            object = socket;
        } else if (!((RealCall)object2).timeout.exit()) {
            object = socket;
        } else {
            object2 = new InterruptedIOException("timeout");
            if (socket != null) {
                ((Throwable)object2).initCause((Throwable)socket);
            }
            object = result = (IOException)object2;
        }
        if (var1_1 != null) {
            Call call = this;
            E e2 = result;
            Intrinsics.checkNotNull(e2);
            EventListener.callFailed(call, e2);
        } else {
            EventListener.callEnd(this);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public final Socket releaseConnectionNoEvents$okhttp() {
        void var2_2;
        void var3_4;
        int n;
        List<Reference<RealCall>> calls;
        Object connection;
        block6: {
            int index;
            RealConnection realConnection = this.connection;
            Intrinsics.checkNotNull((Object)realConnection);
            connection = realConnection;
            RealConnection $this$assertThreadHoldsLock$iv = realConnection;
            if (Util.assertionsEnabled && !Thread.holdsLock($this$assertThreadHoldsLock$iv)) {
                throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + $this$assertThreadHoldsLock$iv));
            }
            calls = ((RealConnection)connection).getCalls();
            Object $this$indexOfFirst$iv = calls;
            int index$iv = 0;
            $this$indexOfFirst$iv = $this$indexOfFirst$iv.iterator();
            while ($this$indexOfFirst$iv.hasNext()) {
                Object object = $this$indexOfFirst$iv.next();
                if (Intrinsics.areEqual(((Reference)(object = (Reference)object)).get(), (Object)this)) {
                    n = index$iv;
                    break block6;
                }
                ++index$iv;
            }
            n = index = -1;
        }
        if (!(n != -1)) {
            connection = "Check failed.";
            throw new IllegalStateException(connection.toString());
        }
        calls.remove((int)var3_4);
        this.connection = null;
        if (var2_2.isEmpty()) {
            ((RealConnection)connection).setIdleAtNs$okhttp(System.nanoTime());
            if (this.connectionPool.connectionBecameIdle((RealConnection)connection)) {
                void var1_1;
                return var1_1.socket();
            }
        }
        return null;
    }

    public final void timeoutEarlyExit() {
        if (!(!this.timeoutEarlyExit)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        this.timeoutEarlyExit = true;
        this.timeout.exit();
    }

    /*
     * WARNING - void declaration
     */
    public final void exitNetworkInterceptorExchange$okhttp(boolean closeExchange2) {
        void var1_1;
        RealCall realCall = this;
        synchronized (realCall) {
            if (!this.expectMoreExchanges) {
                String closeExchange2 = "released";
                throw new IllegalStateException(closeExchange2.toString());
            }
        }
        if (var1_1 != false) {
            Exchange exchange = this.exchange;
            if (exchange != null) {
                exchange.detachWithViolence();
            }
        }
        this.interceptorScopedExchange = null;
    }

    public final boolean retryAfterFailure() {
        ExchangeFinder exchangeFinder = this.exchangeFinder;
        Intrinsics.checkNotNull((Object)exchangeFinder);
        return exchangeFinder.retryAfterFailure();
    }

    public final String redactedUrl$okhttp() {
        return this.originalRequest.url().redact();
    }

    public static final /* synthetic */ String access$toLoggableString(RealCall $this) {
        RealCall realCall = $this;
        RealCall realCall2 = realCall;
        return (realCall2.canceled ? "canceled " : "") + (realCall.forWebSocket ? "web socket" : "call") + " to " + realCall.redactedUrl$okhttp();
    }

    @SourceDebugExtension(value={"SMAP\nRealCall.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RealCall.kt\nokhttp3/internal/connection/RealCall$AsyncCall\n+ 2 Util.kt\nokhttp3/internal/Util\n*L\n1#1,551:1\n615#2,4:552\n409#2,9:556\n*S KotlinDebug\n*F\n+ 1 RealCall.kt\nokhttp3/internal/connection/RealCall$AsyncCall\n*L\n494#1:552,4\n513#1:556,9\n*E\n"})
    public final class AsyncCall
    implements Runnable {
        private final Callback responseCallback;
        private volatile AtomicInteger callsPerHost;
        final /* synthetic */ RealCall this$0;

        /*
         * WARNING - void declaration
         */
        public AsyncCall(RealCall this$0, Callback responseCallback) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)responseCallback, (String)"responseCallback");
            this.this$0 = var1_1;
            this.responseCallback = var2_2;
            this.callsPerHost = new AtomicInteger(0);
        }

        public final AtomicInteger getCallsPerHost() {
            return this.callsPerHost;
        }

        /*
         * WARNING - void declaration
         */
        public final void reuseCallsPerHostFrom(AsyncCall other) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            this.callsPerHost = var1_1.callsPerHost;
        }

        public final String getHost() {
            return this.this$0.getOriginalRequest().url().host();
        }

        public final RealCall getCall() {
            return this.this$0;
        }

        /*
         * WARNING - void declaration
         */
        public final void executeOn(ExecutorService executorService) {
            Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
            Dispatcher $this$assertThreadDoesntHoldLock$iv = this.this$0.getClient().dispatcher();
            if (Util.assertionsEnabled && Thread.holdsLock($this$assertThreadDoesntHoldLock$iv)) {
                throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertThreadDoesntHoldLock$iv));
            }
            try {
                try {
                    executorService.execute(this);
                    return;
                }
                catch (RejectedExecutionException e) {
                    void var2_4;
                    void var1_2;
                    InterruptedIOException ioException = new InterruptedIOException("executor rejected");
                    ioException.initCause((Throwable)var1_2);
                    this.this$0.noMoreExchanges$okhttp(ioException);
                    this.responseCallback.onFailure(this.this$0, (IOException)var2_4);
                    return;
                }
            }
            finally {
                this.this$0.getClient().dispatcher().finished$okhttp(this);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void run() {
            void name$iv;
            String string = "OkHttp " + this.this$0.redactedUrl$okhttp();
            RealCall realCall = this.this$0;
            Thread currentThread$iv = Thread.currentThread();
            String oldName$iv = currentThread$iv.getName();
            currentThread$iv.setName((String)name$iv);
            try {
                boolean signalledCallback = false;
                realCall.timeout.enter();
                try {
                    Response response = realCall.getResponseWithInterceptorChain$okhttp();
                    signalledCallback = true;
                    this.responseCallback.onResponse(realCall, response);
                }
                catch (IOException e) {
                    if (signalledCallback) {
                        Platform.Companion.get();
                        Platform.log("Callback failure for " + RealCall.access$toLoggableString(realCall), 4, e);
                    } else {
                        this.responseCallback.onFailure(realCall, e);
                    }
                }
                catch (Throwable t) {
                    realCall.cancel();
                    if (!signalledCallback) {
                        void var1_3;
                        IOException canceledException = new IOException("canceled due to " + t);
                        ExceptionsKt.addSuppressed((Throwable)canceledException, (Throwable)t);
                        this.responseCallback.onFailure(realCall, (IOException)var1_3);
                    }
                    throw t;
                }
                finally {
                    realCall.getClient().dispatcher().finished$okhttp(this);
                }
                currentThread$iv.setName(oldName$iv);
                return;
            }
            catch (Throwable throwable) {
                void var3_6;
                var3_6.setName(oldName$iv);
                throw throwable;
            }
        }
    }

    public static final class CallReference
    extends WeakReference<RealCall> {
        private final Object callStackTrace;

        /*
         * WARNING - void declaration
         */
        public CallReference(RealCall referent, Object callStackTrace) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)referent, (String)"referent");
            super(var1_1);
            this.callStackTrace = var2_2;
        }

        public final Object getCallStackTrace() {
            return this.callStackTrace;
        }
    }
}

