/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.concurrent;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import java.util.logging.Level;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.internal.Util;
import okhttp3.internal.concurrent.Task;
import okhttp3.internal.concurrent.TaskLoggerKt;
import okhttp3.internal.concurrent.TaskRunner;

@SourceDebugExtension(value={"SMAP\nTaskQueue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TaskQueue.kt\nokhttp3/internal/concurrent/TaskQueue\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 TaskLogger.kt\nokhttp3/internal/concurrent/TaskLoggerKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Util.kt\nokhttp3/internal/Util\n*L\n1#1,218:1\n1#2:219\n25#3,4:220\n25#3,4:224\n25#3,4:228\n25#3,4:232\n25#3,4:251\n350#4,7:236\n615#5,4:243\n615#5,4:247\n*S KotlinDebug\n*F\n+ 1 TaskQueue.kt\nokhttp3/internal/concurrent/TaskQueue\n*L\n65#1:220,4\n68#1:224,4\n153#1:228,4\n159#1:232,4\n208#1:251,4\n165#1:236,7\n179#1:243,4\n189#1:247,4\n*E\n"})
public final class TaskQueue {
    private final TaskRunner taskRunner;
    private final String name;
    private boolean shutdown;
    private Task activeTask;
    private final List<Task> futureTasks;
    private boolean cancelActiveTask;

    /*
     * WARNING - void declaration
     */
    public TaskQueue(TaskRunner taskRunner, String name) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)taskRunner, (String)"taskRunner");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.taskRunner = var1_1;
        this.name = var2_2;
        this.futureTasks = new ArrayList();
    }

    public final TaskRunner getTaskRunner$okhttp() {
        return this.taskRunner;
    }

    public final String getName$okhttp() {
        return this.name;
    }

    public final boolean getShutdown$okhttp() {
        return this.shutdown;
    }

    public final Task getActiveTask$okhttp() {
        return this.activeTask;
    }

    /*
     * WARNING - void declaration
     */
    public final void setActiveTask$okhttp(Task task) {
        void var1_1;
        this.activeTask = var1_1;
    }

    public final List<Task> getFutureTasks$okhttp() {
        return this.futureTasks;
    }

    public final boolean getCancelActiveTask$okhttp() {
        return this.cancelActiveTask;
    }

    public final void setCancelActiveTask$okhttp(boolean bl) {
        this.cancelActiveTask = false;
    }

    /*
     * WARNING - void declaration
     */
    public final void schedule(Task task, long delayNanos2) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        TaskRunner taskRunner = this.taskRunner;
        synchronized (taskRunner) {
            void var2_3;
            void var1_1;
            if (this.shutdown) {
                if (((Task)task).getCancelable()) {
                    if (TaskRunner.Companion.getLogger().isLoggable(Level.FINE)) {
                        Task task2 = task;
                        task = this;
                        Task delayNanos2 = task2;
                        String string = "schedule canceled (queue is shutdown)";
                        TaskLoggerKt.access$log(delayNanos2, (TaskQueue)task, string);
                    }
                    return;
                }
                if (TaskRunner.Companion.getLogger().isLoggable(Level.FINE)) {
                    Task task3 = task;
                    task = this;
                    Task delayNanos2 = task3;
                    String string = "schedule failed (queue is shutdown)";
                    TaskLoggerKt.access$log(delayNanos2, (TaskQueue)task, string);
                }
                throw new RejectedExecutionException();
            }
            if (this.scheduleAndDecide$okhttp((Task)var1_1, (long)var2_3, false)) {
                this.taskRunner.kickCoordinator$okhttp(this);
            }
            return;
        }
    }

    public static /* synthetic */ void schedule$default$6ac1683b(TaskQueue taskQueue, Task task, long l, int n) {
        taskQueue.schedule(task, 0L);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean scheduleAndDecide$okhttp(Task task, long delayNanos, boolean recurrence222) {
        void var2_3;
        void var1_1;
        int insertAt;
        int n;
        block7: {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            task.initQueue$okhttp(this);
            long now = this.taskRunner.getBackend().nanoTime();
            long executeNanoTime = now + delayNanos;
            int existingIndex2 = this.futureTasks.indexOf(task);
            if (existingIndex2 != -1) {
                if (task.getNextExecuteNanoTime$okhttp() <= executeNanoTime) {
                    if (TaskRunner.Companion.getLogger().isLoggable(Level.FINE)) {
                        TaskQueue taskQueue = this;
                        Task existingIndex2 = task;
                        String recurrence222 = "already scheduled";
                        TaskLoggerKt.access$log(existingIndex2, taskQueue, recurrence222);
                    }
                    return false;
                }
                this.futureTasks.remove(existingIndex2);
            }
            task.setNextExecuteNanoTime$okhttp(executeNanoTime);
            if (TaskRunner.Companion.getLogger().isLoggable(Level.FINE)) {
                boolean recurrence222;
                TaskQueue taskQueue = this;
                Task task2 = task;
                String recurrence222 = recurrence222 ? "run again after " + TaskLoggerKt.formatDuration(executeNanoTime - now) : "scheduled after " + TaskLoggerKt.formatDuration(executeNanoTime - now);
                TaskLoggerKt.access$log(task2, taskQueue, recurrence222);
            }
            List<Task> $this$indexOfFirst$iv = this.futureTasks;
            int index$iv = 0;
            for (Task task3 : $this$indexOfFirst$iv) {
                Task task4;
                task3 = task3;
                if (task4.getNextExecuteNanoTime$okhttp() - now > delayNanos) {
                    n = index$iv;
                    break block7;
                }
                ++index$iv;
            }
            n = insertAt = -1;
        }
        if (n == -1) {
            insertAt = this.futureTasks.size();
        }
        this.futureTasks.add(insertAt, (Task)var1_1);
        return var2_3 == false;
    }

    public final void cancelAll() {
        TaskRunner taskRunner;
        TaskQueue $this$assertThreadDoesntHoldLock$iv = this;
        if (Util.assertionsEnabled && Thread.holdsLock($this$assertThreadDoesntHoldLock$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + taskRunner));
        }
        taskRunner = this.taskRunner;
        synchronized (taskRunner) {
            if (this.cancelAllAndDecide$okhttp()) {
                this.taskRunner.kickCoordinator$okhttp(this);
            }
            return;
        }
    }

    public final void shutdown() {
        TaskRunner taskRunner;
        TaskQueue $this$assertThreadDoesntHoldLock$iv = this;
        if (Util.assertionsEnabled && Thread.holdsLock($this$assertThreadDoesntHoldLock$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + taskRunner));
        }
        taskRunner = this.taskRunner;
        synchronized (taskRunner) {
            this.shutdown = true;
            if (this.cancelAllAndDecide$okhttp()) {
                this.taskRunner.kickCoordinator$okhttp(this);
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean cancelAllAndDecide$okhttp() {
        boolean bl;
        if (this.activeTask != null) {
            Task task = this.activeTask;
            Intrinsics.checkNotNull((Object)task);
            if (task.getCancelable()) {
                this.cancelActiveTask = true;
            }
        }
        boolean tasksCanceled = false;
        for (int i = this.futureTasks.size() - 1; i >= 0; --i) {
            if (!this.futureTasks.get(i).getCancelable()) continue;
            Task task$iv = this.futureTasks.get(i);
            if (TaskRunner.Companion.getLogger().isLoggable(Level.FINE)) {
                void var1_2;
                TaskQueue taskQueue = this;
                String string = "canceled";
                TaskLoggerKt.access$log((Task)var1_2, taskQueue, string);
            }
            bl = true;
            this.futureTasks.remove(i);
        }
        return bl;
    }

    public final String toString() {
        return this.name;
    }
}

