/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.io.Closeable;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.CacheControl;
import okhttp3.Challenge;
import okhttp3.Handshake;
import okhttp3.Headers;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.ResponseBody;
import okhttp3.internal.connection.Exchange;
import okhttp3.internal.http.HttpHeaders;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\f\b\u0007\u0018\u00002\u00020\u0001:\u0001AB}\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\r\u001a\u00020\f\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0000\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0000\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0000\u0012\u0006\u0010\u0014\u001a\u00020\u0013\u0012\u0006\u0010\u0015\u001a\u00020\u0013\u0012\b\u0010\u0017\u001a\u0004\u0018\u00010\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0013\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u000f\u0010\u001f\u001a\u00020\u001eH\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\r\u0010\"\u001a\u00020!\u00a2\u0006\u0004\b\"\u0010#J\u000f\u0010$\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b$\u0010%R\u0019\u0010\u000f\u001a\u0004\u0018\u00010\u000e8\u0007\u00a2\u0006\f\n\u0004\b\u000f\u0010&\u001a\u0004\b\u000f\u0010'R\u0011\u0010)\u001a\u00020(8G\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u00008\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0011\u0010+\u001a\u0004\b\u0011\u0010,R\u001a\u0010\t\u001a\u00020\b8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\t\u0010-\u001a\u0004\b\t\u0010.R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u00168\u0001X\u0081\u0004\u00a2\u0006\f\n\u0004\b\u0017\u0010/\u001a\u0004\b\u0017\u00100R\u001c\u0010\u000b\u001a\u0004\u0018\u00010\n8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u000b\u00101\u001a\u0004\b\u000b\u00102R\u001a\u0010\r\u001a\u00020\f8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\r\u00103\u001a\u0004\b\r\u00104R\u0011\u00106\u001a\u0002058F\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u0018\u00108\u001a\u0004\u0018\u00010(8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b8\u00109R\u0017\u0010\u0007\u001a\u00020\u00068\u0007\u00a2\u0006\f\n\u0004\b\u0007\u0010:\u001a\u0004\b\u0007\u0010%R\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u00008\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0010\u0010+\u001a\u0004\b\u0010\u0010,R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u00008\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0012\u0010+\u001a\u0004\b\u0012\u0010,R\u001a\u0010\u0005\u001a\u00020\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010;\u001a\u0004\b\u0005\u0010<R\u001a\u0010\u0015\u001a\u00020\u00138\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0015\u0010=\u001a\u0004\b\u0015\u0010>R\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010?\u001a\u0004\b\u0003\u0010@R\u001a\u0010\u0014\u001a\u00020\u00138\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0014\u0010=\u001a\u0004\b\u0014\u0010>"}, d2={"Lokhttp3/Response;", "Ljava/io/Closeable;", "Lokhttp3/Request;", "request", "Lokhttp3/Protocol;", "protocol", "", "message", "", "code", "Lokhttp3/Handshake;", "handshake", "Lokhttp3/Headers;", "headers", "Lokhttp3/ResponseBody;", "body", "networkResponse", "cacheResponse", "priorResponse", "", "sentRequestAtMillis", "receivedResponseAtMillis", "Lokhttp3/internal/connection/Exchange;", "exchange", "<init>", "(Lokhttp3/Request;Lokhttp3/Protocol;Ljava/lang/String;ILokhttp3/Handshake;Lokhttp3/Headers;Lokhttp3/ResponseBody;Lokhttp3/Response;Lokhttp3/Response;Lokhttp3/Response;JJLokhttp3/internal/connection/Exchange;)V", "", "Lokhttp3/Challenge;", "challenges", "()Ljava/util/List;", "", "close", "()V", "Lokhttp3/Response$Builder;", "newBuilder", "()Lokhttp3/Response$Builder;", "toString", "()Ljava/lang/String;", "Lokhttp3/ResponseBody;", "()Lokhttp3/ResponseBody;", "Lokhttp3/CacheControl;", "cacheControl", "()Lokhttp3/CacheControl;", "Lokhttp3/Response;", "()Lokhttp3/Response;", "I", "()I", "Lokhttp3/internal/connection/Exchange;", "()Lokhttp3/internal/connection/Exchange;", "Lokhttp3/Handshake;", "()Lokhttp3/Handshake;", "Lokhttp3/Headers;", "()Lokhttp3/Headers;", "", "isSuccessful", "()Z", "lazyCacheControl", "Lokhttp3/CacheControl;", "Ljava/lang/String;", "Lokhttp3/Protocol;", "()Lokhttp3/Protocol;", "J", "()J", "Lokhttp3/Request;", "()Lokhttp3/Request;", "Builder"})
@SourceDebugExtension(value={"SMAP\nResponse.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Response.kt\nokhttp3/Response\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,455:1\n1#2:456\n*E\n"})
public final class Response
implements Closeable {
    private final Request request;
    private final Protocol protocol;
    private final String message;
    private final int code;
    private final Handshake handshake;
    private final Headers headers;
    private final ResponseBody body;
    private final Response networkResponse;
    private final Response cacheResponse;
    private final Response priorResponse;
    private final long sentRequestAtMillis;
    private final long receivedResponseAtMillis;
    private final Exchange exchange;
    private CacheControl lazyCacheControl;

    /*
     * WARNING - void declaration
     */
    public Response(Request request, Protocol protocol, String message, int code, Handshake handshake2, Headers headers, ResponseBody body, Response networkResponse, Response cacheResponse, Response priorResponse, long sentRequestAtMillis, long receivedResponseAtMillis, Exchange exchange) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)((Object)protocol), (String)"protocol");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        this.request = var1_1;
        this.protocol = var2_2;
        this.message = var3_3;
        this.code = code;
        this.handshake = handshake2;
        this.headers = headers;
        this.body = body;
        this.networkResponse = networkResponse;
        this.cacheResponse = cacheResponse;
        this.priorResponse = priorResponse;
        this.sentRequestAtMillis = sentRequestAtMillis;
        this.receivedResponseAtMillis = receivedResponseAtMillis;
        this.exchange = exchange;
    }

    @JvmName(name="request")
    public final Request request() {
        return this.request;
    }

    @JvmName(name="protocol")
    public final Protocol protocol() {
        return this.protocol;
    }

    @JvmName(name="message")
    public final String message() {
        return this.message;
    }

    @JvmName(name="code")
    public final int code() {
        return this.code;
    }

    @JvmName(name="handshake")
    public final Handshake handshake() {
        return this.handshake;
    }

    @JvmName(name="headers")
    public final Headers headers() {
        return this.headers;
    }

    @JvmName(name="body")
    public final ResponseBody body() {
        return this.body;
    }

    @JvmName(name="networkResponse")
    public final Response networkResponse() {
        return this.networkResponse;
    }

    @JvmName(name="cacheResponse")
    public final Response cacheResponse() {
        return this.cacheResponse;
    }

    @JvmName(name="priorResponse")
    public final Response priorResponse() {
        return this.priorResponse;
    }

    @JvmName(name="sentRequestAtMillis")
    public final long sentRequestAtMillis() {
        return this.sentRequestAtMillis;
    }

    @JvmName(name="receivedResponseAtMillis")
    public final long receivedResponseAtMillis() {
        return this.receivedResponseAtMillis;
    }

    @JvmName(name="exchange")
    public final Exchange exchange() {
        return this.exchange;
    }

    public final boolean isSuccessful() {
        int n = this.code;
        if (200 <= n) {
            return n < 300;
        }
        return false;
    }

    public static /* synthetic */ String header$default$b4243d8(Response response, String string, String string2, int n) {
        string2 = null;
        Intrinsics.checkNotNullParameter((Object)string, (String)"name");
        String string3 = response.headers.get(string);
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    public final Builder newBuilder() {
        return new Builder(this);
    }

    public final List<Challenge> challenges() {
        String string;
        switch (this.code) {
            case 401: {
                string = "WWW-Authenticate";
                break;
            }
            case 407: {
                string = "Proxy-Authenticate";
                break;
            }
            default: {
                return CollectionsKt.emptyList();
            }
        }
        return HttpHeaders.parseChallenges(this.headers, string);
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="cacheControl")
    public final CacheControl cacheControl() {
        void var1_1;
        CacheControl result = this.lazyCacheControl;
        if (result == null) {
            this.lazyCacheControl = result = CacheControl.Companion.parse(this.headers);
        }
        return var1_1;
    }

    @Override
    public final void close() {
        ResponseBody responseBody = this.body;
        if (responseBody == null) {
            String string = "response is not eligible for a body and must not be closed";
            throw new IllegalStateException(string.toString());
        }
        responseBody.close();
    }

    public final String toString() {
        return "Response{protocol=" + (Object)((Object)this.protocol) + ", code=" + this.code + ", message=" + this.message + ", url=" + this.request.url() + '}';
    }

    @SourceDebugExtension(value={"SMAP\nResponse.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Response.kt\nokhttp3/Response$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,455:1\n1#2:456\n*E\n"})
    public static final class Builder {
        private Request request;
        private Protocol protocol;
        private int code;
        private String message;
        private Handshake handshake;
        private Headers.Builder headers;
        private ResponseBody body;
        private Response networkResponse;
        private Response cacheResponse;
        private Response priorResponse;
        private long sentRequestAtMillis;
        private long receivedResponseAtMillis;
        private Exchange exchange;

        public final int getCode$okhttp() {
            return this.code;
        }

        public Builder() {
            this.code = -1;
            this.headers = new Headers.Builder();
        }

        /*
         * WARNING - void declaration
         */
        public Builder(Response response) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            this.code = -1;
            this.request = response.request();
            this.protocol = response.protocol();
            this.code = response.code();
            this.message = response.message();
            this.handshake = response.handshake();
            this.headers = response.headers().newBuilder();
            this.body = response.body();
            this.networkResponse = response.networkResponse();
            this.cacheResponse = response.cacheResponse();
            this.priorResponse = response.priorResponse();
            this.sentRequestAtMillis = response.sentRequestAtMillis();
            this.receivedResponseAtMillis = response.receivedResponseAtMillis();
            this.exchange = var1_1.exchange();
        }

        /*
         * WARNING - void declaration
         */
        public final Builder request(Request request) {
            void var1_1;
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Builder builder2 = builder = this;
            builder.request = var1_1;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder protocol(Protocol protocol) {
            void var1_1;
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)((Object)protocol), (String)"protocol");
            Builder builder2 = builder = this;
            builder.protocol = var1_1;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder code(int code) {
            void var1_1;
            Builder builder;
            Builder builder2 = builder = this;
            builder.code = var1_1;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder message(String message) {
            void var1_1;
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Builder builder2 = builder = this;
            builder.message = var1_1;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder handshake(Handshake handshake2) {
            void var1_1;
            Builder builder;
            Builder builder2 = builder = this;
            builder.handshake = var1_1;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder header(String name, String value) {
            void var2_2;
            void var1_1;
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder builder2 = builder = this;
            builder.headers.set((String)var1_1, (String)var2_2);
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder addHeader(String name, String value) {
            void var2_2;
            void var1_1;
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder builder2 = builder = this;
            builder.headers.add((String)var1_1, (String)var2_2);
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder headers(Headers headers) {
            void var1_1;
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
            Builder builder2 = builder = this;
            builder.headers = var1_1.newBuilder();
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder body(ResponseBody body) {
            void var1_1;
            Builder builder;
            Builder builder2 = builder = this;
            builder.body = var1_1;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder networkResponse(Response networkResponse) {
            void var1_1;
            Builder builder;
            Builder $this$networkResponse_u24lambda_u2410 = builder = this;
            Builder.checkSupportResponse("networkResponse", networkResponse);
            var3_3.networkResponse = var1_1;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder cacheResponse(Response cacheResponse) {
            void var1_1;
            Builder builder;
            Builder $this$cacheResponse_u24lambda_u2411 = builder = this;
            Builder.checkSupportResponse("cacheResponse", cacheResponse);
            var3_3.cacheResponse = var1_1;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        private static void checkSupportResponse(String name, Response response) {
            Response response2 = response;
            if (response2 != null) {
                void var1_1;
                response = response2;
                Response $this$checkSupportResponse_u24lambda_u2416 = response2;
                if (!(response2.body() == null)) {
                    name = name + ".body != null";
                    throw new IllegalArgumentException(name.toString());
                }
                if (!($this$checkSupportResponse_u24lambda_u2416.networkResponse() == null)) {
                    name = name + ".networkResponse != null";
                    throw new IllegalArgumentException(name.toString());
                }
                if (!($this$checkSupportResponse_u24lambda_u2416.cacheResponse() == null)) {
                    name = name + ".cacheResponse != null";
                    throw new IllegalArgumentException(name.toString());
                }
                if (!(var1_1.priorResponse() == null)) {
                    String string;
                    string = string + ".priorResponse != null";
                    throw new IllegalArgumentException(string.toString());
                }
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        public final Builder priorResponse(Response priorResponse) {
            void var1_1;
            Response response;
            Builder builder;
            Builder $this$priorResponse_u24lambda_u2417 = builder = this;
            Response response2 = response = priorResponse;
            if (response2 != null) {
                response = response2;
                response = response2;
                if (!(response2.body() == null)) {
                    priorResponse = "priorResponse.body != null";
                    throw new IllegalArgumentException(priorResponse.toString());
                }
            }
            var3_3.priorResponse = var1_1;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder sentRequestAtMillis(long sentRequestAtMillis) {
            void var1_1;
            Builder builder;
            Builder builder2 = builder = this;
            builder.sentRequestAtMillis = var1_1;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder receivedResponseAtMillis(long receivedResponseAtMillis) {
            void var1_1;
            Builder builder;
            Builder builder2 = builder = this;
            builder.receivedResponseAtMillis = var1_1;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final void initExchange$okhttp(Exchange deferredTrailers) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)deferredTrailers, (String)"deferredTrailers");
            this.exchange = var1_1;
        }

        public final Response build() {
            if (!(this.code >= 0)) {
                String string = "code < 0: " + this.code;
                throw new IllegalStateException(string.toString());
            }
            Request request = this.request;
            if (request == null) {
                String string = "request == null";
                throw new IllegalStateException(string.toString());
            }
            Protocol protocol = this.protocol;
            if (protocol == null) {
                String string = "protocol == null";
                throw new IllegalStateException(string.toString());
            }
            String string = this.message;
            if (string == null) {
                String string2 = "message == null";
                string2 = "message == null";
                throw new IllegalStateException(string2.toString());
            }
            Exchange exchange = this.exchange;
            long l = this.receivedResponseAtMillis;
            long l2 = this.sentRequestAtMillis;
            Response response = this.priorResponse;
            Response response2 = this.cacheResponse;
            Response response3 = this.networkResponse;
            ResponseBody responseBody = this.body;
            Headers headers = this.headers.build();
            Handshake handshake2 = this.handshake;
            int n = this.code;
            String string3 = string;
            Protocol protocol2 = protocol;
            Request request2 = request;
            return new Response(request2, protocol2, string3, n, handshake2, headers, responseBody, response3, response2, response, l2, l, exchange);
        }
    }
}

