/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.io.Serializable;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLPeerUnverifiedException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.internal.tls.CertificateChainCleaner;
import okio.ByteString;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\f\b\u0007\u0018\u0000 &2\u00020\u0001:\u0003'&(B#\b\u0000\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ+\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\t2\u0012\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000bH\u0000\u00a2\u0006\u0004\b\u0010\u0010\u0011J#\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\t2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\f\u00a2\u0006\u0004\b\u0012\u0010\u0015J\u001a\u0010\u0018\u001a\u00020\u00172\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u0096\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001b\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\f2\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u000f\u0010\u001d\u001a\u00020\u001cH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0017\u0010!\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0005H\u0000\u00a2\u0006\u0004\b\u001f\u0010 R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u00058\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0006\u0010\"\u001a\u0004\b#\u0010$R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\u0006\n\u0004\b\u0004\u0010%"}, d2={"Lokhttp3/CertificatePinner;", "", "", "Lokhttp3/CertificatePinner$Pin;", "pins", "Lokhttp3/internal/tls/CertificateChainCleaner;", "certificateChainCleaner", "<init>", "(Ljava/util/Set;Lokhttp3/internal/tls/CertificateChainCleaner;)V", "", "hostname", "Lkotlin/Function0;", "", "Ljava/security/cert/X509Certificate;", "cleanedPeerCertificatesFn", "", "check$okhttp", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "check", "Ljava/security/cert/Certificate;", "peerCertificates", "(Ljava/lang/String;Ljava/util/List;)V", "other", "", "equals", "(Ljava/lang/Object;)Z", "findMatchingPins", "(Ljava/lang/String;)Ljava/util/List;", "", "hashCode", "()I", "withCertificateChainCleaner$okhttp", "(Lokhttp3/internal/tls/CertificateChainCleaner;)Lokhttp3/CertificatePinner;", "withCertificateChainCleaner", "Lokhttp3/internal/tls/CertificateChainCleaner;", "getCertificateChainCleaner$okhttp", "()Lokhttp3/internal/tls/CertificateChainCleaner;", "Ljava/util/Set;", "Companion", "Builder", "Pin"})
@SourceDebugExtension(value={"SMAP\nCertificatePinner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CertificatePinner.kt\nokhttp3/CertificatePinner\n+ 2 Util.kt\nokhttp3/internal/Util\n*L\n1#1,370:1\n625#2,8:371\n*S KotlinDebug\n*F\n+ 1 CertificatePinner.kt\nokhttp3/CertificatePinner\n*L\n216#1:371,8\n*E\n"})
public final class CertificatePinner {
    public static final Companion Companion = new Companion(null);
    public final Set<Pin> pins;
    private final CertificateChainCleaner certificateChainCleaner;
    @JvmField
    public static final CertificatePinner DEFAULT = new Builder().build();

    /*
     * WARNING - void declaration
     */
    private CertificatePinner(Set<Pin> pins, CertificateChainCleaner certificateChainCleaner) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(pins, (String)"pins");
        this.pins = var1_1;
        this.certificateChainCleaner = var2_2;
    }

    public /* synthetic */ CertificatePinner(Set set, CertificateChainCleaner certificateChainCleaner, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            certificateChainCleaner = null;
        }
        this(set, certificateChainCleaner);
    }

    public final CertificateChainCleaner getCertificateChainCleaner$okhttp() {
        return this.certificateChainCleaner;
    }

    /*
     * WARNING - void declaration
     */
    public final void check(String hostname, List<? extends Certificate> peerCertificates2) throws SSLPeerUnverifiedException {
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
        Intrinsics.checkNotNullParameter(peerCertificates2, (String)"peerCertificates");
        this.check$okhttp(hostname, (Function0<? extends List<? extends X509Certificate>>)((Function0)new Function0<List<? extends X509Certificate>>(this, (List<? extends Certificate>)var2_2, (String)var1_1){
            final /* synthetic */ CertificatePinner this$0;
            final /* synthetic */ List<Certificate> $peerCertificates;
            final /* synthetic */ String $hostname;
            {
                void var3_3;
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                this.$peerCertificates = var2_2;
                this.$hostname = var3_3;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final List<X509Certificate> invoke() {
                void var1_1;
                Object object = this.this$0.getCertificateChainCleaner$okhttp();
                if (object == null || (object = ((CertificateChainCleaner)object).clean(this.$peerCertificates, this.$hostname)) == null) {
                    object = this.$peerCertificates;
                }
                Iterable $this$map$iv = (Iterable)object;
                Object object2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                object2 = object2.iterator();
                while (object2.hasNext()) {
                    void var3_3;
                    void it;
                    Object item$iv$iv = object2.next();
                    item$iv$iv = (Certificate)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type java.security.cert.X509Certificate");
                    collection.add((X509Certificate)var3_3);
                }
                return (List)var1_1;
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    public final void check$okhttp(String hostname, Function0<? extends List<? extends X509Certificate>> cleanedPeerCertificatesFn) {
        void var3_3;
        void var1_1;
        Iterator<Pin> iterator;
        Serializable serializable;
        Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
        Intrinsics.checkNotNullParameter(cleanedPeerCertificatesFn, (String)"cleanedPeerCertificatesFn");
        List<Pin> pins = this.findMatchingPins(hostname);
        if (pins.isEmpty()) {
            return;
        }
        Object peerCertificates2 = (List)cleanedPeerCertificatesFn.invoke();
        Iterator iterator2 = peerCertificates2.iterator();
        while (iterator2.hasNext()) {
            serializable = (X509Certificate)iterator2.next();
            Object var6_6 = null;
            serializable = null;
            iterator = pins.iterator();
            if (!iterator.hasNext()) continue;
            Object object = peerCertificates2 = iterator.next();
            throw null;
        }
        serializable = new StringBuilder();
        StringBuilder $this$check_u24lambda_u240 = serializable;
        ((StringBuilder)serializable).append("Certificate pinning failure!");
        $this$check_u24lambda_u240.append("\n  Peer certificate chain:");
        iterator = peerCertificates2.iterator();
        while (iterator.hasNext()) {
            X509Certificate element = (X509Certificate)((Object)iterator.next());
            $this$check_u24lambda_u240.append("\n    ");
            $this$check_u24lambda_u240.append(Companion.pin(element));
            $this$check_u24lambda_u240.append(": ");
            $this$check_u24lambda_u240.append(element.getSubjectDN().getName());
        }
        $this$check_u24lambda_u240.append("\n  Pinned certificates for ");
        $this$check_u24lambda_u240.append((String)var1_1);
        $this$check_u24lambda_u240.append(":");
        for (Pin pin : var3_3) {
            void var2_2;
            $this$check_u24lambda_u240.append("\n    ");
            $this$check_u24lambda_u240.append(var2_2);
        }
        String string = ((StringBuilder)serializable).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        String message = string;
        throw new SSLPeerUnverifiedException(message);
    }

    /*
     * WARNING - void declaration
     */
    private List<Pin> findMatchingPins(String hostname) {
        void var3_3;
        Object object;
        Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
        Iterable $this$filterList$iv = this.pins;
        List result$iv = CollectionsKt.emptyList();
        object = object.iterator();
        if (object.hasNext()) {
            void var1_1;
            object = object.next();
            Object object2 = object = (Pin)object;
            void v1 = var1_1;
            throw null;
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public final CertificatePinner withCertificateChainCleaner$okhttp(CertificateChainCleaner certificateChainCleaner) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)certificateChainCleaner, (String)"certificateChainCleaner");
        if (Intrinsics.areEqual((Object)this.certificateChainCleaner, (Object)certificateChainCleaner)) {
            return this;
        }
        return new CertificatePinner(this.pins, (CertificateChainCleaner)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        void var1_1;
        return other instanceof CertificatePinner && Intrinsics.areEqual(((CertificatePinner)other).pins, this.pins) && Intrinsics.areEqual((Object)((CertificatePinner)var1_1).certificateChainCleaner, (Object)this.certificateChainCleaner);
    }

    public final int hashCode() {
        int n;
        int result = 1517 + ((Object)this.pins).hashCode();
        CertificateChainCleaner certificateChainCleaner = this.certificateChainCleaner;
        n = 41 * n + (certificateChainCleaner != null ? certificateChainCleaner.hashCode() : 0);
        return n;
    }

    public static final class Builder {
        private final List<Pin> pins = new ArrayList();

        public final CertificatePinner build() {
            return new CertificatePinner(CollectionsKt.toSet((Iterable)this.pins), null, 2, null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0013\u0010\u000b\u001a\u00020\n*\u00020\tH\u0007\u00a2\u0006\u0004\b\u000b\u0010\fR\u0014\u0010\u000e\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000f"}, d2={"Lokhttp3/CertificatePinner$Companion;", "", "<init>", "()V", "Ljava/security/cert/Certificate;", "certificate", "", "pin", "(Ljava/security/cert/Certificate;)Ljava/lang/String;", "Ljava/security/cert/X509Certificate;", "Lokio/ByteString;", "sha256Hash", "(Ljava/security/cert/X509Certificate;)Lokio/ByteString;", "Lokhttp3/CertificatePinner;", "DEFAULT", "Lokhttp3/CertificatePinner;"})
    @SourceDebugExtension(value={"SMAP\nCertificatePinner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CertificatePinner.kt\nokhttp3/CertificatePinner$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,370:1\n1#2:371\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public static ByteString sha256Hash(X509Certificate $this$sha256Hash) {
            X509Certificate x509Certificate;
            Intrinsics.checkNotNullParameter((Object)$this$sha256Hash, (String)"<this>");
            byte[] byArray = x509Certificate.getPublicKey().getEncoded();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"publicKey.encoded");
            return ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])byArray, (int)0, (int)0, (int)3, null).sha256();
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final String pin(Certificate certificate) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
            if (!(certificate instanceof X509Certificate)) {
                certificate = "Certificate pinning requires X509 certificates";
                throw new IllegalArgumentException(certificate.toString());
            }
            return "sha256/" + okhttp3.CertificatePinner$Companion.sha256Hash((X509Certificate)var1_1).base64();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    public static final class Pin {
        public final String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            Pin pin = this;
            throw null;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean equals(Object other) {
            void var1_1;
            if (this == other) {
                return true;
            }
            if (!(var1_1 instanceof Pin)) {
                return false;
            }
            Pin pin = this;
            throw null;
        }

        public final int hashCode() {
            Pin pin = this;
            throw null;
        }
    }
}

