/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import okhttp3.CipherSuite;
import okhttp3.Handshake;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.TlsVersion;
import okhttp3.internal.Util;
import okhttp3.internal.cache.CacheRequest;
import okhttp3.internal.cache.CacheStrategy;
import okhttp3.internal.cache.DiskLruCache;
import okhttp3.internal.http.HttpMethod;
import okhttp3.internal.http.StatusLine;
import okhttp3.internal.platform.Platform;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import okio.ForwardingSink;
import okio.ForwardingSource;
import okio.Okio;
import okio.Sink;
import okio.Source;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0010\u0018\u0000 52\u00020\u00012\u00020\u0002:\u00046578J\u001d\u0010\u0007\u001a\u00020\u00062\f\u0010\u0005\u001a\b\u0018\u00010\u0003R\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u000b\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u000b\u0010\nJ\u0019\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\r\u001a\u00020\fH\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0019\u0010\u0016\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0012\u001a\u00020\u000eH\u0000\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0019\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\fH\u0000\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u001b\u001a\u00020\u0006H\u0000\u00a2\u0006\u0004\b\u001a\u0010\nJ\u0017\u0010 \u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001cH\u0000\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u001f\u0010%\u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u000eH\u0000\u00a2\u0006\u0004\b#\u0010$R\u0014\u0010&\u001a\u00020\u00048\u0000X\u0080\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010'R\u0016\u0010)\u001a\u00020(8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b)\u0010*R\u0016\u0010+\u001a\u00020(8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b+\u0010*R\u0016\u0010,\u001a\u00020(8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b,\u0010*R\"\u0010-\u001a\u00020(8\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b-\u0010*\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\"\u00102\u001a\u00020(8\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b2\u0010*\u001a\u0004\b3\u0010/\"\u0004\b4\u00101"}, d2={"Lokhttp3/Cache;", "Ljava/io/Closeable;", "Ljava/io/Flushable;", "Lokhttp3/internal/cache/DiskLruCache$Editor;", "Lokhttp3/internal/cache/DiskLruCache;", "editor", "", "abortQuietly", "(Lokhttp3/internal/cache/DiskLruCache$Editor;)V", "close", "()V", "flush", "Lokhttp3/Request;", "request", "Lokhttp3/Response;", "get$okhttp", "(Lokhttp3/Request;)Lokhttp3/Response;", "get", "response", "Lokhttp3/internal/cache/CacheRequest;", "put$okhttp", "(Lokhttp3/Response;)Lokhttp3/internal/cache/CacheRequest;", "put", "remove$okhttp", "(Lokhttp3/Request;)V", "remove", "trackConditionalCacheHit$okhttp", "trackConditionalCacheHit", "Lokhttp3/internal/cache/CacheStrategy;", "cacheStrategy", "trackResponse$okhttp", "(Lokhttp3/internal/cache/CacheStrategy;)V", "trackResponse", "cached", "network", "update$okhttp", "(Lokhttp3/Response;Lokhttp3/Response;)V", "update", "cache", "Lokhttp3/internal/cache/DiskLruCache;", "", "hitCount", "I", "networkCount", "requestCount", "writeAbortCount", "getWriteAbortCount$okhttp", "()I", "setWriteAbortCount$okhttp", "(I)V", "writeSuccessCount", "getWriteSuccessCount$okhttp", "setWriteSuccessCount$okhttp", "Companion", "CacheResponseBody", "Entry", "RealCacheRequest"})
public final class Cache
implements Closeable,
Flushable {
    public static final Companion Companion = new Companion(null);
    public final DiskLruCache cache;
    private int writeSuccessCount;
    private int writeAbortCount;
    private int networkCount;
    private int hitCount;
    private int requestCount;

    public final int getWriteSuccessCount$okhttp() {
        return this.writeSuccessCount;
    }

    /*
     * WARNING - void declaration
     */
    public final void setWriteSuccessCount$okhttp(int n) {
        void var1_1;
        this.writeSuccessCount = var1_1;
    }

    public final int getWriteAbortCount$okhttp() {
        return this.writeAbortCount;
    }

    /*
     * WARNING - void declaration
     */
    public final void setWriteAbortCount$okhttp(int n) {
        void var1_1;
        this.writeAbortCount = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final Response get$okhttp(Request request) {
        void var1_1;
        void var2_2;
        Entry entry;
        DiskLruCache.Snapshot snapshot;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String key = okhttp3.Cache$Companion.key(request.url());
        try {
            DiskLruCache.Snapshot snapshot2 = this.cache.get(key);
            if (snapshot2 == null) {
                return null;
            }
            snapshot = snapshot2;
        }
        catch (IOException iOException) {
            return null;
        }
        DiskLruCache.Snapshot snapshot3 = snapshot;
        try {
            entry = new Entry(snapshot3.getSource(0));
        }
        catch (IOException iOException) {
            Util.closeQuietly(snapshot3);
            return null;
        }
        Entry entry2 = entry;
        Response response = entry2.response((DiskLruCache.Snapshot)var2_2);
        if (!((Entry)((Object)snapshot)).matches((Request)var1_1, response)) {
            ResponseBody responseBody = response.body();
            if (responseBody != null) {
                Util.closeQuietly(responseBody);
            }
            return null;
        }
        return response;
    }

    /*
     * WARNING - void declaration
     */
    public final CacheRequest put$okhttp(Response response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        String requestMethod = response.request().method();
        if (HttpMethod.invalidatesCache(response.request().method())) {
            try {
                this.remove$okhttp(response.request());
            }
            catch (IOException iOException) {}
            return null;
        }
        if (!Intrinsics.areEqual((Object)requestMethod, (Object)"GET")) {
            return null;
        }
        if (Companion.hasVaryAll(response)) {
            return null;
        }
        Entry entry = new Entry(response);
        DiskLruCache.Editor editor = null;
        try {
            void var2_2;
            void var1_1;
            DiskLruCache.Editor editor2 = DiskLruCache.edit$default$4dbb4a5f(this.cache, okhttp3.Cache$Companion.key(var1_1.request().url()), 0L, 2);
            if (editor2 == null) {
                return null;
            }
            editor = editor2;
            var2_2.writeTo(editor);
            return new RealCacheRequest(this, editor);
        }
        catch (IOException iOException) {
            void var3_3;
            Cache.abortQuietly((DiskLruCache.Editor)var3_3);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void remove$okhttp(Request request) throws IOException {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.cache.remove(okhttp3.Cache$Companion.key(var1_1.url()));
    }

    /*
     * WARNING - void declaration
     */
    public final void update$okhttp(Response cached, Response network) {
        Intrinsics.checkNotNullParameter((Object)cached, (String)"cached");
        Intrinsics.checkNotNullParameter((Object)network, (String)"network");
        Entry entry = new Entry(network);
        ResponseBody responseBody = cached.body();
        Intrinsics.checkNotNull((Object)responseBody, (String)"null cannot be cast to non-null type okhttp3.Cache.CacheResponseBody");
        DiskLruCache.Snapshot snapshot = ((CacheResponseBody)responseBody).getSnapshot();
        DiskLruCache.Editor editor = null;
        try {
            void var2_2;
            void var1_1;
            DiskLruCache.Editor editor2 = var1_1.edit();
            if (editor2 == null) {
                return;
            }
            editor = editor2;
            var2_2.writeTo(editor);
            editor.commit();
            return;
        }
        catch (IOException iOException) {
            void var3_3;
            Cache.abortQuietly((DiskLruCache.Editor)var3_3);
            return;
        }
    }

    private static void abortQuietly(DiskLruCache.Editor editor) {
        try {
            DiskLruCache.Editor editor2 = editor;
            if (editor2 != null) {
                editor2.abort();
                return;
            }
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    @Override
    public final void flush() throws IOException {
        this.cache.flush();
    }

    @Override
    public final void close() throws IOException {
        this.cache.close();
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void trackResponse$okhttp(CacheStrategy cacheStrategy) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)cacheStrategy, (String)"cacheStrategy");
        int n = this.requestCount;
        this.requestCount = n + 1;
        if (cacheStrategy.getNetworkRequest() != null) {
            n = this.networkCount;
            this.networkCount = n + 1;
            return;
        }
        if (var1_1.getCacheResponse() != null) {
            n = this.hitCount;
            this.hitCount = n + 1;
        }
    }

    public final synchronized void trackConditionalCacheHit$okhttp() {
        int n = this.hitCount;
        this.hitCount = n + 1;
    }

    private static final class CacheResponseBody
    extends ResponseBody {
        private final DiskLruCache.Snapshot snapshot;
        private final String contentType;
        private final String contentLength;
        private final BufferedSource bodySource;

        /*
         * WARNING - void declaration
         */
        public CacheResponseBody(DiskLruCache.Snapshot snapshot, String contentType, String contentLength) {
            void var1_1;
            void var3_3;
            void var2_2;
            Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
            this.snapshot = snapshot;
            this.contentType = var2_2;
            this.contentLength = var3_3;
            Source source = this.snapshot.getSource(1);
            this.bodySource = Okio.buffer((Source)((Source)new ForwardingSource((Source)var1_1, this){
                final /* synthetic */ CacheResponseBody this$0;
                {
                    void var1_1;
                    void var2_2;
                    this.this$0 = var2_2;
                    super((Source)var1_1);
                }

                public final void close() throws IOException {
                    this.this$0.getSnapshot().close();
                    super.close();
                }
            }));
        }

        public final DiskLruCache.Snapshot getSnapshot() {
            return this.snapshot;
        }

        @Override
        public final MediaType contentType() {
            String string = this.contentType;
            if (string != null) {
                return MediaType.Companion.parse(string);
            }
            return null;
        }

        @Override
        public final long contentLength() {
            String string = this.contentLength;
            if (string != null) {
                return Util.toLongOrDefault(string, -1L);
            }
            return -1L;
        }

        @Override
        public final BufferedSource source() {
            return this.bodySource;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0004\b\u0087\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0000\u00a2\u0006\u0004\b\f\u0010\rJ%\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0011\u0010\u0018\u001a\u00020\u0015*\u00020\u000f\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0019\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u001a*\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0011\u0010\u001d\u001a\u00020\u0011*\u00020\u000f\u00a2\u0006\u0004\b\u001d\u0010\u001e"}, d2={"Lokhttp3/Cache$Companion;", "", "<init>", "()V", "Lokhttp3/HttpUrl;", "url", "", "key", "(Lokhttp3/HttpUrl;)Ljava/lang/String;", "Lokio/BufferedSource;", "source", "", "readInt$okhttp", "(Lokio/BufferedSource;)I", "readInt", "Lokhttp3/Response;", "cachedResponse", "Lokhttp3/Headers;", "cachedRequest", "Lokhttp3/Request;", "newRequest", "", "varyMatches", "(Lokhttp3/Response;Lokhttp3/Headers;Lokhttp3/Request;)Z", "hasVaryAll", "(Lokhttp3/Response;)Z", "", "varyFields", "(Lokhttp3/Headers;)Ljava/util/Set;", "varyHeaders", "(Lokhttp3/Response;)Lokhttp3/Headers;"})
    @SourceDebugExtension(value={"SMAP\nCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Cache.kt\nokhttp3/Cache$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,788:1\n2624#2,3:789\n*S KotlinDebug\n*F\n+ 1 Cache.kt\nokhttp3/Cache$Companion\n*L\n729#1:789,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public static String key(HttpUrl url) {
            HttpUrl httpUrl;
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            return ByteString.Companion.encodeUtf8(httpUrl.toString()).md5().hex();
        }

        /*
         * WARNING - void declaration
         */
        public static int readInt$okhttp(BufferedSource source) throws IOException {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            try {
                long result = source.readDecimalLong();
                Object line = source.readUtf8LineStrict();
                if (result < 0L || result > Integer.MAX_VALUE || ((CharSequence)line).length() > 0) {
                    Object object;
                    throw new IOException("expected an int but was \"" + result + (String)object + '\"');
                }
                return (int)result;
            }
            catch (NumberFormatException e) {
                void var1_2;
                throw new IOException(var1_2.getMessage());
            }
        }

        public final boolean varyMatches(Response cachedResponse, Headers cachedRequest, Request newRequest) {
            Intrinsics.checkNotNullParameter((Object)cachedResponse, (String)"cachedResponse");
            Intrinsics.checkNotNullParameter((Object)cachedRequest, (String)"cachedRequest");
            Intrinsics.checkNotNullParameter((Object)newRequest, (String)"newRequest");
            Iterable $this$none$iv = okhttp3.Cache$Companion.varyFields(cachedResponse.headers());
            if (!($this$none$iv instanceof Collection) || !((Collection)$this$none$iv).isEmpty()) {
                Iterator iterator;
                iterator = iterator.iterator();
                while (iterator.hasNext()) {
                    Object t = iterator.next();
                    String it = (String)t;
                    if (!(!Intrinsics.areEqual(cachedRequest.values(it), newRequest.headers(it)))) continue;
                    return false;
                }
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean hasVaryAll(Response $this$hasVaryAll) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)$this$hasVaryAll, (String)"<this>");
            return okhttp3.Cache$Companion.varyFields(var1_1.headers()).contains("*");
        }

        /*
         * WARNING - void declaration
         */
        private static Set<String> varyFields(Headers $this$varyFields) {
            void var1_1;
            Set result = null;
            int n = $this$varyFields.size();
            for (int i = 0; i < n; ++i) {
                if (!StringsKt.equals((String)"Vary", (String)$this$varyFields.name(i), (boolean)true)) continue;
                String value = $this$varyFields.value(i);
                if (result == null) {
                    result = new TreeSet(StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
                }
                char[] cArray = new char[1];
                char[] cArray2 = cArray;
                cArray[0] = 44;
                for (String varyField : StringsKt.split$default((CharSequence)value, (char[])cArray2, (boolean)false, (int)0, (int)6, null)) {
                    result.add(((Object)StringsKt.trim((CharSequence)varyField)).toString());
                }
            }
            Set set = var1_1;
            if (set == null) {
                set = SetsKt.emptySet();
            }
            return set;
        }

        /*
         * WARNING - void declaration
         */
        public final Headers varyHeaders(Response $this$varyHeaders) {
            void var2_2;
            Object object;
            Intrinsics.checkNotNullParameter((Object)$this$varyHeaders, (String)"<this>");
            Response response = $this$varyHeaders.networkResponse();
            Intrinsics.checkNotNull((Object)response);
            Headers requestHeaders = response.request().headers();
            Headers responseHeaders = $this$varyHeaders.headers();
            Headers.Builder builder = object;
            object = this;
            object = okhttp3.Cache$Companion.varyFields((Headers)((Object)builder));
            if (object.isEmpty()) {
                return Util.EMPTY_HEADERS;
            }
            builder = new Headers.Builder();
            int n = var2_2.size();
            for (int i = 0; i < n; ++i) {
                String string = var2_2.name(i);
                if (!object.contains(string)) continue;
                builder.add(string, var2_2.value(i));
            }
            return builder.build();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u0000 <2\u00020\u0001:\u0001<B\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0004\u0010\bJ\u001d\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\f\u0010\rJ\u001d\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0019\u0010\u0007\u001a\u00020\u00062\n\u0010\u0016\u001a\u00060\u0014R\u00020\u0015\u00a2\u0006\u0004\b\u0007\u0010\u0017J%\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0019\u0010 \u001a\u00020\u001b2\n\u0010\u001f\u001a\u00060\u001eR\u00020\u0015\u00a2\u0006\u0004\b \u0010!R\u0014\u0010#\u001a\u00020\"8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010$R\u0016\u0010&\u001a\u0004\u0018\u00010%8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010'R\u0014\u0010(\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0014\u0010+\u001a\u00020*8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b+\u0010,R\u0014\u0010.\u001a\u00020-8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b.\u0010/R\u0014\u00101\u001a\u0002008\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b1\u00102R\u0014\u00103\u001a\u00020*8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b3\u0010,R\u0014\u00105\u001a\u0002048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b5\u00106R\u0014\u00107\u001a\u0002008\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b7\u00102R\u0014\u00109\u001a\u0002088\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b9\u0010:R\u0014\u0010;\u001a\u0002048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b;\u00106"}, d2={"Lokhttp3/Cache$Entry;", "", "Lokio/Source;", "rawSource", "<init>", "(Lokio/Source;)V", "Lokhttp3/Response;", "response", "(Lokhttp3/Response;)V", "Lokhttp3/Request;", "request", "", "matches", "(Lokhttp3/Request;Lokhttp3/Response;)Z", "Lokio/BufferedSource;", "source", "", "Ljava/security/cert/Certificate;", "readCertificateList", "(Lokio/BufferedSource;)Ljava/util/List;", "Lokhttp3/internal/cache/DiskLruCache$Snapshot;", "Lokhttp3/internal/cache/DiskLruCache;", "snapshot", "(Lokhttp3/internal/cache/DiskLruCache$Snapshot;)Lokhttp3/Response;", "Lokio/BufferedSink;", "sink", "certificates", "", "writeCertList", "(Lokio/BufferedSink;Ljava/util/List;)V", "Lokhttp3/internal/cache/DiskLruCache$Editor;", "editor", "writeTo", "(Lokhttp3/internal/cache/DiskLruCache$Editor;)V", "", "code", "I", "Lokhttp3/Handshake;", "handshake", "Lokhttp3/Handshake;", "isHttps", "()Z", "", "message", "Ljava/lang/String;", "Lokhttp3/Protocol;", "protocol", "Lokhttp3/Protocol;", "", "receivedResponseMillis", "J", "requestMethod", "Lokhttp3/Headers;", "responseHeaders", "Lokhttp3/Headers;", "sentRequestMillis", "Lokhttp3/HttpUrl;", "url", "Lokhttp3/HttpUrl;", "varyHeaders", "Companion"})
    private static final class Entry {
        public static final Companion Companion = new Companion(null);
        private final HttpUrl url;
        private final Headers varyHeaders;
        private final String requestMethod;
        private final Protocol protocol;
        private final int code;
        private final String message;
        private final Headers responseHeaders;
        private final Handshake handshake;
        private final long sentRequestMillis;
        private final long receivedResponseMillis;
        private static final String SENT_MILLIS;
        private static final String RECEIVED_MILLIS;

        private final boolean isHttps() {
            return Intrinsics.areEqual((Object)this.url.scheme(), (Object)"https");
        }

        /*
         * WARNING - void declaration
         */
        public Entry(Source rawSource) throws IOException {
            Closeable closeable;
            block9: {
                Throwable throwable;
                Intrinsics.checkNotNullParameter((Object)rawSource, (String)"rawSource");
                closeable = (Closeable)rawSource;
                Throwable throwable2 = null;
                try {
                    Source cfr_ignored_0 = (Source)closeable;
                    BufferedSource source = Okio.buffer((Source)rawSource);
                    Object urlLine = source.readUtf8LineStrict();
                    HttpUrl httpUrl = HttpUrl.Companion.parse((String)urlLine);
                    if (httpUrl == null) {
                        void it;
                        urlLine = new IOException("Cache corruption for " + (String)urlLine);
                        IOException iOException = urlLine;
                        Platform.Companion.get();
                        Platform.log("cache corruption", 5, (Throwable)it);
                        throw (Throwable)urlLine;
                    }
                    this.url = httpUrl;
                    this.requestMethod = source.readUtf8LineStrict();
                    Headers.Builder varyHeadersBuilder = new Headers.Builder();
                    int varyRequestHeaderLineCount = okhttp3.Cache$Companion.readInt$okhttp(source);
                    for (int i = 0; i < varyRequestHeaderLineCount; ++i) {
                        varyHeadersBuilder.addLenient$okhttp(source.readUtf8LineStrict());
                    }
                    this.varyHeaders = varyHeadersBuilder.build();
                    StatusLine statusLine = StatusLine.Companion.parse(source.readUtf8LineStrict());
                    this.protocol = statusLine.protocol;
                    this.code = statusLine.code;
                    this.message = statusLine.message;
                    Headers.Builder responseHeadersBuilder = new Headers.Builder();
                    int responseHeaderLineCount = okhttp3.Cache$Companion.readInt$okhttp(source);
                    for (int i = 0; i < responseHeaderLineCount; ++i) {
                        responseHeadersBuilder.addLenient$okhttp(source.readUtf8LineStrict());
                    }
                    String sendRequestMillisString = responseHeadersBuilder.get(SENT_MILLIS);
                    String receivedResponseMillisString = responseHeadersBuilder.get(RECEIVED_MILLIS);
                    responseHeadersBuilder.removeAll(SENT_MILLIS);
                    responseHeadersBuilder.removeAll(RECEIVED_MILLIS);
                    String string = sendRequestMillisString;
                    this.sentRequestMillis = string != null ? Long.parseLong(string) : 0L;
                    String string2 = receivedResponseMillisString;
                    this.receivedResponseMillis = string2 != null ? Long.parseLong(string2) : 0L;
                    this.responseHeaders = responseHeadersBuilder.build();
                    if (this.isHttps()) {
                        String blank = source.readUtf8LineStrict();
                        if (((CharSequence)blank).length() > 0) {
                            throw new IOException("expected \"\" but was \"" + blank + '\"');
                        }
                        String cipherSuiteString = source.readUtf8LineStrict();
                        CipherSuite cipherSuite = CipherSuite.Companion.forJavaName(cipherSuiteString);
                        List<Certificate> peerCertificates2 = Entry.readCertificateList(source);
                        List<Certificate> localCertificates = Entry.readCertificateList(source);
                        TlsVersion tlsVersion = !source.exhausted() ? TlsVersion.Companion.forJavaName(source.readUtf8LineStrict()) : TlsVersion.SSL_3_0;
                        this.handshake = Handshake.Companion.get((TlsVersion)((Object)throwable), cipherSuite, peerCertificates2, localCertificates);
                        break block9;
                    }
                    this.handshake = null;
                }
                catch (Throwable throwable3) {
                    try {
                        throwable = throwable3;
                        throwable2 = throwable3;
                        throw throwable;
                    }
                    catch (Throwable throwable4) {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
                        throw throwable4;
                    }
                }
            }
            CloseableKt.closeFinally((Closeable)closeable, null);
            return;
        }

        /*
         * WARNING - void declaration
         */
        public Entry(Response response) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            this.url = response.request().url();
            this.varyHeaders = Companion.varyHeaders(response);
            this.requestMethod = response.request().method();
            this.protocol = response.protocol();
            this.code = response.code();
            this.message = response.message();
            this.responseHeaders = response.headers();
            this.handshake = response.handshake();
            this.sentRequestMillis = response.sentRequestAtMillis();
            this.receivedResponseMillis = var1_1.receivedResponseAtMillis();
        }

        /*
         * WARNING - void declaration
         */
        public final void writeTo(DiskLruCache.Editor editor) throws IOException {
            Closeable closeable;
            block6: {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                closeable = (Closeable)Okio.buffer((Sink)((DiskLruCache.Editor)((Object)closeable)).newSink(0));
                Throwable throwable = null;
                try {
                    void var3_3;
                    int i;
                    BufferedSink sink = (BufferedSink)closeable;
                    sink.writeUtf8(this.url.toString()).writeByte(10);
                    sink.writeUtf8(this.requestMethod).writeByte(10);
                    sink.writeDecimalLong((long)this.varyHeaders.size()).writeByte(10);
                    int n = this.varyHeaders.size();
                    for (i = 0; i < n; ++i) {
                        sink.writeUtf8(this.varyHeaders.name(i)).writeUtf8(": ").writeUtf8(this.varyHeaders.value(i)).writeByte(10);
                    }
                    sink.writeUtf8(new StatusLine(this.protocol, this.code, this.message).toString()).writeByte(10);
                    sink.writeDecimalLong((long)(this.responseHeaders.size() + 2)).writeByte(10);
                    n = this.responseHeaders.size();
                    for (i = 0; i < n; ++i) {
                        sink.writeUtf8(this.responseHeaders.name(i)).writeUtf8(": ").writeUtf8(this.responseHeaders.value(i)).writeByte(10);
                    }
                    sink.writeUtf8(SENT_MILLIS).writeUtf8(": ").writeDecimalLong(this.sentRequestMillis).writeByte(10);
                    sink.writeUtf8(RECEIVED_MILLIS).writeUtf8(": ").writeDecimalLong(this.receivedResponseMillis).writeByte(10);
                    if (!this.isHttps()) break block6;
                    sink.writeByte(10);
                    Handshake handshake2 = this.handshake;
                    Intrinsics.checkNotNull((Object)handshake2);
                    sink.writeUtf8(handshake2.cipherSuite().javaName()).writeByte(10);
                    Entry.writeCertList(sink, this.handshake.peerCertificates());
                    Entry.writeCertList(sink, this.handshake.localCertificates());
                    var3_3.writeUtf8(this.handshake.tlsVersion().javaName()).writeByte(10);
                }
                catch (Throwable throwable2) {
                    try {
                        Throwable throwable3 = throwable2;
                        throwable = throwable2;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        throw throwable4;
                    }
                }
            }
            CloseableKt.closeFinally((Closeable)closeable, null);
            return;
        }

        /*
         * WARNING - void declaration
         */
        private static List<Certificate> readCertificateList(BufferedSource source) throws IOException {
            int length = okhttp3.Cache$Companion.readInt$okhttp(source);
            if (length == -1) {
                return CollectionsKt.emptyList();
            }
            try {
                void var3_4;
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                ArrayList<Certificate> result = new ArrayList<Certificate>(length);
                for (int i = 0; i < length; ++i) {
                    ByteString certificateBytes;
                    String line = source.readUtf8LineStrict();
                    Buffer bytes = new Buffer();
                    if (ByteString.Companion.decodeBase64(line) == null) {
                        throw new IOException("Corrupt certificate in cache entry");
                    }
                    bytes.write(certificateBytes);
                    result.add(certificateFactory.generateCertificate(bytes.inputStream()));
                }
                return (List)var3_4;
            }
            catch (CertificateException e) {
                void var2_3;
                throw new IOException(var2_3.getMessage());
            }
        }

        /*
         * WARNING - void declaration
         */
        private static void writeCertList(BufferedSink sink, List<? extends Certificate> certificates) throws IOException {
            try {
                sink.writeDecimalLong((long)certificates.size()).writeByte(10);
                certificates = certificates.iterator();
                while (certificates.hasNext()) {
                    Certificate certificate = (Certificate)certificates.next();
                    byte[] bytes = certificate.getEncoded();
                    Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"bytes");
                    String line = ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])bytes, (int)0, (int)0, (int)3, null).base64();
                    sink.writeUtf8((String)((Object)certificate)).writeByte(10);
                }
            }
            catch (CertificateEncodingException e) {
                void var1_2;
                throw new IOException(var1_2.getMessage());
            }
        }

        /*
         * WARNING - void declaration
         */
        public final boolean matches(Request request, Response response) {
            void var1_1;
            void var2_2;
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            return Intrinsics.areEqual((Object)this.url, (Object)request.url()) && Intrinsics.areEqual((Object)this.requestMethod, (Object)request.method()) && Companion.varyMatches((Response)var2_2, this.varyHeaders, (Request)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public final Response response(DiskLruCache.Snapshot snapshot) {
            void var3_3;
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
            String contentType = this.responseHeaders.get("Content-Type");
            String contentLength = this.responseHeaders.get("Content-Length");
            Request cacheRequest = new Request.Builder().url(this.url).method(this.requestMethod, null).headers(this.varyHeaders).build();
            return new Response.Builder().request(cacheRequest).protocol(this.protocol).code(this.code).message(this.message).headers(this.responseHeaders).body(new CacheResponseBody((DiskLruCache.Snapshot)var1_1, (String)var2_2, (String)var3_3)).handshake(this.handshake).sentRequestAtMillis(this.sentRequestMillis).receivedResponseAtMillis(this.receivedResponseMillis).build();
        }

        static {
            StringBuilder stringBuilder = new StringBuilder();
            Platform.Companion.get();
            SENT_MILLIS = stringBuilder.append(Platform.getPrefix()).append("-Sent-Millis").toString();
            StringBuilder stringBuilder2 = new StringBuilder();
            Platform.Companion.get();
            RECEIVED_MILLIS = stringBuilder2.append(Platform.getPrefix()).append("-Received-Millis").toString();
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006"}, d2={"Lokhttp3/Cache$Entry$Companion;", "", "<init>", "()V", "", "RECEIVED_MILLIS", "Ljava/lang/String;", "SENT_MILLIS"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    private final class RealCacheRequest
    implements CacheRequest {
        private final DiskLruCache.Editor editor;
        private final Sink cacheOut;
        private final Sink body;
        private boolean done;
        final /* synthetic */ Cache this$0;

        /*
         * WARNING - void declaration
         */
        public RealCacheRequest(Cache this$0, DiskLruCache.Editor editor) {
            void var2_2;
            Sink sink;
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            this.this$0 = sink;
            this.editor = var2_2;
            sink = this.cacheOut = this.editor.newSink(1);
            this.body = (Sink)new ForwardingSink(this.this$0, this, sink){
                final /* synthetic */ Cache this$0;
                final /* synthetic */ RealCacheRequest this$1;
                {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.this$0 = var1_1;
                    this.this$1 = var2_2;
                    super((Sink)var3_3);
                }

                public final void close() throws IOException {
                    Cache cache = this.this$0;
                    RealCacheRequest realCacheRequest = this.this$1;
                    Cache cache2 = this.this$0;
                    synchronized (cache) {
                        if (realCacheRequest.getDone()) {
                            return;
                        }
                        realCacheRequest.setDone(true);
                        int n = cache2.getWriteSuccessCount$okhttp();
                        cache2.setWriteSuccessCount$okhttp(n + 1);
                    }
                    super.close();
                    this.this$1.editor.commit();
                }
            };
        }

        public final boolean getDone() {
            return this.done;
        }

        public final void setDone(boolean bl) {
            this.done = true;
        }

        @Override
        public final void abort() {
            Cache cache = this.this$0;
            Cache cache2 = this.this$0;
            synchronized (cache) {
                if (this.done) {
                    return;
                }
                this.done = true;
                int n = cache2.getWriteAbortCount$okhttp();
                cache2.setWriteAbortCount$okhttp(n + 1);
            }
            Util.closeQuietly((Closeable)this.cacheOut);
            try {
                this.editor.abort();
                return;
            }
            catch (IOException iOException) {
                return;
            }
        }

        @Override
        public final Sink body() {
            return this.body;
        }
    }
}

