/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.jini;

import com.sshtools.jini.INI;
import com.sshtools.jini.INIReader;
import com.sshtools.jini.Interpolation;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public interface Data {
    public Map<String, String[]> values();

    public Map<String, INI.Section[]> sections();

    /*
     * WARNING - void declaration
     */
    default public INI.Section section(String ... path) {
        void var1_1;
        return this.sectionOr(path).orElseThrow(() -> Data.lambda$section$0((String[])var1_1));
    }

    /*
     * WARNING - void declaration
     */
    default public Optional<INI.Section> sectionOr(String ... path) {
        void var1_1;
        Optional<INI.Section[]> all = this.allSectionsOr(path);
        if (all.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(((INI.Section[])var1_1.get())[0]);
    }

    public Optional<INI.Section[]> allSectionsOr(String ... var1);

    /*
     * WARNING - void declaration
     */
    default public Optional<String> getOr(String key) {
        void var1_1;
        Optional<String[]> all = this.getAllOr(key);
        if (all.isEmpty()) {
            return Optional.empty();
        }
        String[] a = all.get();
        if (a.length == 0) {
            return Optional.empty();
        }
        return Optional.of(var1_1[0]);
    }

    public Optional<String[]> getAllOr(String var1);

    private static /* synthetic */ IllegalArgumentException lambda$section$0(String[] path) {
        String[] stringArray;
        return new IllegalArgumentException(MessageFormat.format("No section with path {0}", String.join((CharSequence)".", stringArray)));
    }

    public static abstract class AbstractData
    implements Data {
        final Map<String, INI.Section[]> sections;
        final Map<String, String[]> values;
        final boolean preserveOrder;
        final boolean caseSensitiveKeys;
        final boolean caseSensitiveSections;
        final boolean emptyValues;
        final List<Object> valueUpdate = new CopyOnWriteArrayList<Object>();
        final List<Object> sectionUpdate = new CopyOnWriteArrayList<Object>();
        final Optional<Interpolation.Interpolator> interpolator;
        final Optional<String> variablePattern;
        final INI.MissingVariableMode missingVariableMode;

        /*
         * WARNING - void declaration
         */
        AbstractData(boolean emptyValues, boolean preserveOrder, boolean caseSensitiveKeys, boolean caseSensitiveSections, Map<String, String[]> values, Map<String, INI.Section[]> sections, Optional<Interpolation.Interpolator> interpolator, Optional<String> variablePattern, INI.MissingVariableMode missingVariableMode) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.interpolator = interpolator;
            this.emptyValues = var1_1;
            this.sections = sections;
            this.values = values;
            this.preserveOrder = var2_2;
            this.caseSensitiveKeys = var3_3;
            this.caseSensitiveSections = caseSensitiveSections;
            this.variablePattern = variablePattern;
            this.missingVariableMode = missingVariableMode;
        }

        /*
         * WARNING - void declaration
         */
        AbstractData(boolean emptyValues, boolean preserveOrder, boolean caseSensitiveKeys, boolean caseSensitiveSections, Optional<Interpolation.Interpolator> interpolator, Optional<String> variablePattern, INI.MissingVariableMode missingVariableMode) {
            this((boolean)var1_1, preserveOrder, caseSensitiveKeys, caseSensitiveSections, INIReader.createPropertyMap(preserveOrder, (boolean)var3_3), INIReader.createSectionMap((boolean)var2_2, caseSensitiveSections), interpolator, variablePattern, missingVariableMode);
            void var2_2;
            void var3_3;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Map<String, String[]> values() {
            if (this.interpolator.isPresent()) {
                void var1_1;
                HashMap<String, String[]> m = new HashMap<String, String[]>();
                AbstractData abstractData = this;
                for (Map.Entry entry : abstractData.values.entrySet()) {
                    m.put((String)entry.getKey(), this.interpolate((String[])entry.getValue()));
                }
                return Collections.unmodifiableMap(var1_1);
            }
            AbstractData abstractData = this;
            return abstractData.values;
        }

        @Override
        public Map<String, INI.Section[]> sections() {
            return this.sections;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Optional<INI.Section[]> allSectionsOr(String ... path) {
            INI.Section[] sectionArray;
            void var1_1;
            if (path.length == 0) {
                return Optional.of(this.sections().values().stream().flatMap(sections -> Arrays.asList(sections).stream()).collect(Collectors.toList()).toArray(new INI.Section[0]));
            }
            Data current = this;
            Object sections2 = null;
            for (void key : var1_1) {
                sectionArray = current.sections().get(sectionArray);
                if (sectionArray == null) {
                    return Optional.empty();
                }
                current = sectionArray[0];
            }
            return Optional.ofNullable(sectionArray);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Optional<String[]> getAllOr(String key) {
            void var1_1;
            if (this.interpolator.isPresent()) {
                return Optional.ofNullable(this.values.get(key)).map(this::interpolate);
            }
            return Optional.ofNullable(this.values.get(var1_1));
        }

        /*
         * WARNING - void declaration
         */
        private String[] interpolate(String[] vals) {
            void var1_1;
            for (int i = 0; i < vals.length; ++i) {
                AbstractData abstractData = this;
                Interpolation.Interpolator interpolator = Interpolation.compound(this.interpolator.get(), (data, var) -> {
                    void var2_2;
                    switch (this.missingVariableMode) {
                        case BLANK: {
                            return "";
                        }
                        case SKIP: {
                            return null;
                        }
                    }
                    throw new IllegalArgumentException(MessageFormat.format("Unknown string variable ''{0}'''", var2_2));
                });
                String string = vals[i];
                Object object = abstractData.variablePattern.orElse("\\$\\{(.*?)\\}");
                AbstractData abstractData2 = abstractData;
                object = Pattern.compile((String)object);
                abstractData2 = abstractData;
                object = ((Pattern)object).matcher(string);
                StringBuilder stringBuilder = new StringBuilder();
                int n = 0;
                while (((Matcher)object).find()) {
                    String string2 = ((Matcher)object).group(1);
                    if ((string2 = (String)interpolator.apply(abstractData2, string2)) == null) {
                        stringBuilder.append(string.substring(n, ((Matcher)object).end()));
                    } else {
                        stringBuilder.append(string.substring(n, ((Matcher)object).start()));
                        stringBuilder.append(string2);
                    }
                    n = ((Matcher)object).end();
                }
                stringBuilder.append(string.substring(n, string.length()));
                vals[i] = string = stringBuilder.toString();
            }
            return var1_1;
        }
    }
}

