/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.snapshots;

import androidx.compose.runtime.ActualJvm_jvmKt;
import androidx.compose.runtime.WeakReference;
import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\f\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0001\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u00012\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00028\u00002\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ'\u0010\u000f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0013\u001a\u00020\u0006H\u0000\u00a2\u0006\u0004\b\u0011\u0010\u0012J'\u0010\u0017\u001a\u00020\u00162\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00060\u0014H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0017\u0010\u0018R\"\u0010\u001a\u001a\u00020\u00198\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\"\u0010 \u001a\u00020\t8\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b \u0010!\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R0\u0010(\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010'0&8\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b(\u0010)\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-\u0082\u0002\u0007\n\u0005\b\u009920\u0001"}, d2={"Landroidx/compose/runtime/snapshots/SnapshotWeakSet;", "", "T", "<init>", "()V", "value", "", "add", "(Ljava/lang/Object;)Z", "", "hash", "find", "(Ljava/lang/Object;I)I", "midIndex", "valueHash", "findExactIndex", "(ILjava/lang/Object;I)I", "isValid$runtime", "()Z", "isValid", "Lkotlin/Function1;", "block", "", "removeIf", "(Lkotlin/jvm/functions/Function1;)V", "", "hashes", "[I", "getHashes$runtime", "()[I", "setHashes$runtime", "([I)V", "size", "I", "getSize$runtime", "()I", "setSize$runtime", "(I)V", "", "Landroidx/compose/runtime/WeakReference;", "values", "[Landroidx/compose/runtime/WeakReference;", "getValues$runtime", "()[Landroidx/compose/runtime/WeakReference;", "setValues$runtime", "([Landroidx/compose/runtime/WeakReference;)V"})
@StabilityInferred(parameters=0)
public final class SnapshotWeakSet<T> {
    private int size;
    private int[] hashes = new int[16];
    private WeakReference<T>[] values = new WeakReference[16];
    public static final int $stable = 8;

    public final int getSize$runtime() {
        return this.size;
    }

    /*
     * WARNING - void declaration
     */
    public final void setSize$runtime(int n) {
        void var1_1;
        this.size = var1_1;
    }

    public final int[] getHashes$runtime() {
        return this.hashes;
    }

    /*
     * WARNING - void declaration
     */
    public final void setHashes$runtime(int[] nArray) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
        this.hashes = var1_1;
    }

    public final WeakReference<T>[] getValues$runtime() {
        return this.values;
    }

    /*
     * WARNING - void declaration
     */
    public final void setValues$runtime(WeakReference<T>[] weakReferenceArray) {
        void var1_1;
        Intrinsics.checkNotNullParameter(weakReferenceArray, (String)"<set-?>");
        this.values = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean add(T value) {
        void var1_1;
        int index;
        Intrinsics.checkNotNullParameter(value, (String)"value");
        int size = this.size;
        int hash = ActualJvm_jvmKt.identityHashCode(value);
        if (size > 0) {
            index = this.find(value, hash);
            if (index >= 0) {
                return false;
            }
        } else {
            index = -1;
        }
        int insertIndex = -(index + 1);
        int capacity = this.values.length;
        if (size == capacity) {
            int newCapacity = capacity * 2;
            Object[] newValues = new WeakReference[newCapacity];
            int[] newHashes = new int[newCapacity];
            ArraysKt.copyInto((Object[])this.values, (Object[])newValues, (int)(insertIndex + 1), (int)insertIndex, (int)size);
            ArraysKt.copyInto$default((Object[])this.values, (Object[])newValues, (int)0, (int)0, (int)insertIndex, (int)6, null);
            ArraysKt.copyInto((int[])this.hashes, (int[])newHashes, (int)(insertIndex + 1), (int)insertIndex, (int)size);
            ArraysKt.copyInto$default((int[])this.hashes, (int[])newHashes, (int)0, (int)0, (int)insertIndex, (int)6, null);
            this.values = newValues;
            this.hashes = newHashes;
        } else {
            void var3_2;
            ArraysKt.copyInto((Object[])this.values, (Object[])this.values, (int)(insertIndex + 1), (int)insertIndex, (int)size);
            ArraysKt.copyInto((int[])this.hashes, (int[])this.hashes, (int)(insertIndex + 1), (int)insertIndex, (int)var3_2);
        }
        this.values[insertIndex] = new WeakReference<void>(var1_1);
        this.hashes[var2_4] = hash;
        int n = this.size;
        this.size = n + 1;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final void removeIf(Function1<? super T, Boolean> block) {
        void var2_2;
        int i;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        int size = this.getSize$runtime();
        int currentUsed = 0;
        for (i = 0; i < size; ++i) {
            WeakReference<T> entry = this.getValues$runtime()[i];
            Object value = entry != null ? entry.get() : null;
            if (value == null || ((Boolean)block.invoke(value)).booleanValue()) continue;
            if (currentUsed != i) {
                this.getValues$runtime()[currentUsed] = entry;
                this.getHashes$runtime()[currentUsed] = this.getHashes$runtime()[i];
            }
            ++currentUsed;
        }
        for (i = currentUsed; i < size; ++i) {
            this.getValues$runtime()[i] = null;
            this.getHashes$runtime()[i] = 0;
        }
        if (currentUsed != var2_2) {
            void var3_3;
            this.setSize$runtime((int)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final int find(T value, int hash) {
        void var3_3;
        int low = 0;
        int high = this.size - 1;
        while (low <= high) {
            void var2_2;
            void var1_1;
            void var3_4;
            Object midVal;
            int mid = low + high >>> 1;
            int midHash = this.hashes[mid];
            if (midHash < hash) {
                low = mid + 1;
                continue;
            }
            if (midHash > hash) {
                high = mid - 1;
                continue;
            }
            WeakReference<T> weakReference = this.values[mid];
            Object object = midVal = weakReference != null ? weakReference.get() : null;
            if (value == var3_4) {
                return mid;
            }
            return this.findExactIndex(mid, var1_1, (int)var2_2);
        }
        return (int)(-(var3_3 + true));
    }

    private final int findExactIndex(int midIndex, T value, int valueHash) {
        int i;
        for (i = midIndex - 1; i >= 0 && this.hashes[i] == valueHash; --i) {
            WeakReference<T> weakReference = this.values[i];
            Object object = weakReference != null ? weakReference.get() : null;
            if (object != value) continue;
            return i;
        }
        int n = this.size;
        for (i = var1_1 + true; i < n; ++i) {
            if (this.hashes[i] != valueHash) {
                return -(i + 1);
            }
            WeakReference<T> weakReference = this.values[i];
            Object object = weakReference != null ? weakReference.get() : null;
            if (object != value) continue;
            return i;
        }
        return -(this.size + 1);
    }

    public final boolean isValid$runtime() {
        int i;
        int size = this.size;
        WeakReference<T>[] values = this.values;
        int[] hashes = this.hashes;
        int capacity = values.length;
        if (size > capacity) {
            return false;
        }
        int previous = Integer.MIN_VALUE;
        for (i = 0; i < size; ++i) {
            int hash = hashes[i];
            if (hash < previous) {
                return false;
            }
            if (values[i] == null) {
                return false;
            }
            Object value = previous.get();
            if (value != null && hash != ActualJvm_jvmKt.identityHashCode(value)) {
                return false;
            }
            int n = hash;
        }
        for (i = var1_1; i < capacity; ++i) {
            if (hashes[i] != 0) {
                return false;
            }
            if (values[i] == null) continue;
            return false;
        }
        return true;
    }
}

