/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.reflect;

import androidx.compose.runtime.Composer;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.runtime.reflect.ComposableInfo;
import androidx.compose.runtime.reflect.ComposableMethodKt;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0019\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\f\u001a\u00020\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u0096\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J<\u0010\u0016\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0012\u001a\u00020\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u00012\u0016\u0010\u0015\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0014\"\u0004\u0018\u00010\u0001H\u0086\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0018R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0019R\u0011\u0010\u001b\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0010R\u001b\u0010\u001f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c0\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0017\u0010#\u001a\b\u0012\u0004\u0012\u00020 0\u00148F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\""}, d2={"Landroidx/compose/runtime/reflect/ComposableMethod;", "", "Ljava/lang/reflect/Method;", "method", "Landroidx/compose/runtime/reflect/ComposableInfo;", "composableInfo", "<init>", "(Ljava/lang/reflect/Method;Landroidx/compose/runtime/reflect/ComposableInfo;)V", "asMethod", "()Ljava/lang/reflect/Method;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "Landroidx/compose/runtime/Composer;", "composer", "instance", "", "args", "invoke", "(Landroidx/compose/runtime/Composer;Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;", "Landroidx/compose/runtime/reflect/ComposableInfo;", "Ljava/lang/reflect/Method;", "getParameterCount", "parameterCount", "Ljava/lang/Class;", "getParameterTypes", "()[Ljava/lang/Class;", "parameterTypes", "Ljava/lang/reflect/Parameter;", "getParameters", "()[Ljava/lang/reflect/Parameter;", "parameters"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nComposableMethod.jvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposableMethod.jvm.kt\nandroidx/compose/runtime/reflect/ComposableMethod\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,222:1\n1549#2:223\n1620#2,3:224\n1804#2,4:227\n*S KotlinDebug\n*F\n+ 1 ComposableMethod.jvm.kt\nandroidx/compose/runtime/reflect/ComposableMethod\n*L\n145#1:223\n145#1:224,3\n146#1:227,4\n*E\n"})
public final class ComposableMethod {
    private final Method method;
    private final ComposableInfo composableInfo;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public ComposableMethod(Method method, ComposableInfo composableInfo) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)composableInfo, (String)"composableInfo");
        this.method = var1_1;
        this.composableInfo = var2_2;
    }

    public final Method asMethod() {
        return this.method;
    }

    public final int getParameterCount() {
        return this.composableInfo.getRealParamsCount();
    }

    public final Parameter[] getParameters() {
        Parameter[] parameterArray = this.method.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)parameterArray, (String)"getParameters(...)");
        Object[] objectArray = parameterArray;
        int n = this.composableInfo.getRealParamsCount();
        return (Parameter[])ArraysKt.copyOfRange((Object[])objectArray, (int)0, (int)n);
    }

    public final Class<?>[] getParameterTypes() {
        Class<?>[] classArray = this.method.getParameterTypes();
        Intrinsics.checkNotNullExpressionValue(classArray, (String)"getParameterTypes(...)");
        Object[] objectArray = classArray;
        int n = this.composableInfo.getRealParamsCount();
        return (Class[])ArraysKt.copyOfRange((Object[])objectArray, (int)0, (int)n);
    }

    /*
     * WARNING - void declaration
     */
    public final Object invoke(Composer composer, Object instance, Object ... args) {
        void var2_2;
        Object[] objectArray;
        int n;
        Intrinsics.checkNotNullParameter((Object)composer, (String)"composer");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        ComposableInfo composableInfo = this.composableInfo;
        int realParamsCount = composableInfo.component2();
        int changedParams = composableInfo.component3();
        int defaultParams = composableInfo.component4();
        int totalParams = this.method.getParameterTypes().length;
        int changedStartIndex = realParamsCount + 1;
        int defaultStartIndex = changedStartIndex + changedParams;
        Integer[] integerArray = new Integer[defaultParams];
        for (int i = 0; i < defaultParams; ++i) {
            int n2;
            void $this$foldIndexed$iv;
            Collection<Integer> $this$mapTo$iv$iv;
            void $this$map$iv;
            int n3;
            int n4 = n3 = i;
            int start22 = n4 * 31;
            int end22 = Math.min(start22 + 31, realParamsCount);
            Iterable iterable = (Iterable)RangesKt.until((int)start22, (int)end22);
            n = n4;
            objectArray = integerArray;
            void start22 = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            Object end22 = $this$mapTo$iv$iv.iterator();
            while (end22.hasNext()) {
                int item$iv$iv = ((IntIterator)end22).nextInt();
                $this$mapTo$iv$iv = destination$iv$iv;
                $this$mapTo$iv$iv.add(item$iv$iv >= args.length || args[item$iv$iv] == null ? 1 : 0);
            }
            $this$mapTo$iv$iv = (List)destination$iv$iv;
            end22 = $this$mapTo$iv$iv;
            destination$iv$iv = (Iterable)end22;
            int index$iv = 0;
            boolean accumulator$iv = false;
            for (Object element$iv2 : $this$foldIndexed$iv) {
                void default_;
                void mask;
                int n5;
                if ((n5 = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                int element$iv2 = ((Number)element$iv2).intValue();
                int i2 = n5;
                n2 = mask | default_ << i2;
            }
            void var12_21 = n2;
            n3 = var12_21;
            objectArray[n] = n3;
        }
        Integer[] defaultsMasks = integerArray;
        Object[] objectArray2 = new Object[totalParams];
        for (int i = 0; i < totalParams; ++i) {
            Object object;
            int n6;
            int n7 = i;
            Object[] objectArray3 = objectArray2;
            int n8 = n7;
            boolean bl = n6 >= 0 ? n6 < realParamsCount : false;
            if (bl) {
                Object[] objectArray4 = args;
                if (n7 >= 0 && n7 <= ArraysKt.getLastIndex((Object[])objectArray4)) {
                    object = objectArray4[n7];
                } else {
                    n = n8;
                    objectArray = objectArray3;
                    Class<?> clazz = this.method.getParameterTypes()[n7];
                    Intrinsics.checkNotNullExpressionValue(clazz, (String)"get(...)");
                    Object object2 = ComposableMethodKt.access$getDefaultValue(clazz);
                    objectArray3 = objectArray;
                    n8 = n;
                    object = object2;
                }
            } else if (n6 == realParamsCount) {
                object = composer;
            } else if (n6 == changedStartIndex) {
                object = 0;
            } else {
                boolean bl2 = changedStartIndex + 1 <= n6 ? n6 < defaultStartIndex : false;
                if (bl2) {
                    object = 0;
                } else {
                    boolean bl3 = defaultStartIndex <= n6 ? n6 < totalParams : false;
                    if (bl3) {
                        object = defaultsMasks[n7 - defaultStartIndex];
                    } else {
                        throw new IllegalStateException("Unexpected index".toString());
                    }
                }
            }
            objectArray3[n8] = object;
        }
        Object[] arguments = objectArray2;
        return this.method.invoke((Object)var2_2, Arrays.copyOf(arguments, arguments.length));
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        if (other instanceof ComposableMethod) {
            void var1_1;
            return Intrinsics.areEqual((Object)this.method, (Object)((ComposableMethod)var1_1).method);
        }
        return false;
    }

    public final int hashCode() {
        return this.method.hashCode();
    }
}

