/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.newsclub.net.unix.AFAddressFamily;
import org.newsclub.net.unix.AFSocketAddress;
import org.newsclub.net.unix.AFSocketAddressConfig;
import org.newsclub.net.unix.AFTIPCSocketAddress$$Lambda$1;
import org.newsclub.net.unix.AFTIPCSocketAddress$1$$Lambda$1;
import org.newsclub.net.unix.AFTIPCSocketAddress$1$$Lambda$2;
import org.newsclub.net.unix.AFTIPCSocketAddress$AddressType$$Lambda$1;
import org.newsclub.net.unix.AFTIPCSocketAddress$AddressType$$Lambda$2;
import org.newsclub.net.unix.AFTIPCSocketAddress$AddressType$$Lambda$3;
import org.newsclub.net.unix.AFTIPCSocketAddress$AddressType$$Lambda$4;
import org.newsclub.net.unix.AFTIPCSocketAddress$AddressType$$Lambda$5;
import org.newsclub.net.unix.AFTIPCSocketAddress$Scope$$Lambda$1;
import org.newsclub.net.unix.NamedInteger;
import org.newsclub.net.unix.pool.ObjectPool;

public final class AFTIPCSocketAddress
extends AFSocketAddress {
    private static final Pattern PAT_TIPC_URI_HOST_AND_PORT = Pattern.compile("^((?:(?:(?<scope>cluster|node|default|[0-9a-fx]+)\\-)?(?<type>service|service-range|socket)\\.)|(?<scope2>cluster|node|default|[0-9a-fx]+)\\-(?<type2>[0-9a-fx]+)\\.)?(?<a>[0-9a-fx]+)\\.(?<b>[0-9a-fx]+)(?:\\.(?<c>[0-9a-fx]+))?(?:\\:(?<javaPort>[0-9]+))?$");
    private static AFAddressFamily<AFTIPCSocketAddress> afTipc;

    /*
     * WARNING - void declaration
     */
    private AFTIPCSocketAddress(int port, byte[] socketAddress, ObjectPool.Lease<ByteBuffer> nativeAddress) throws SocketException {
        super((int)var1_1, (byte[])var2_2, (ObjectPool.Lease<ByteBuffer>)var3_3, AFTIPCSocketAddress.addressFamily());
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String toString() {
        void var2_4;
        void var1_1;
        void var3_5;
        int port = this.getPort();
        byte[] bytes = this.getBytes();
        if (bytes.length != 20) {
            return this.getClass().getName() + "[" + (port == 0 ? "" : "port=" + port) + ";UNKNOWN]";
        }
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        int typeId = bb.getInt();
        int scopeId = bb.getInt();
        int a = bb.getInt();
        int b = bb.getInt();
        int c = bb.getInt();
        Scope scope = Scope.ofValue((byte)scopeId);
        AddressType addressType = AddressType.ofValue((int)var3_5);
        String typeString = AddressType.access$000(addressType, scope, a, b, c);
        return this.getClass().getName() + "[" + (port == 0 ? "" : "port=" + (int)var1_1 + ";") + (String)var2_4 + "]";
    }

    @Override
    public final boolean hasFilename() {
        return false;
    }

    @Override
    public final File getFile() throws FileNotFoundException {
        throw new FileNotFoundException("no file");
    }

    private static synchronized AFAddressFamily<AFTIPCSocketAddress> addressFamily() {
        if (afTipc == null) {
            afTipc = AFAddressFamily.registerAddressFamily("tipc", AFTIPCSocketAddress.class, new AFSocketAddressConfig<AFTIPCSocketAddress>(){
                private final AFSocketAddress.AFSocketAddressConstructor<AFTIPCSocketAddress> addrConstr = AFSocketAddress.isUseDeserializationForInit() ? AFTIPCSocketAddress$1$$Lambda$1.lambdaFactory$$62da34d0() : AFTIPCSocketAddress$1$$Lambda$2.lambdaFactory$$62da34d0();

                @Override
                protected final AFSocketAddress.AFSocketAddressConstructor<AFTIPCSocketAddress> addressConstructor() {
                    return this.addrConstr;
                }

                @Override
                protected final String selectorProviderClassname() {
                    return "org.newsclub.net.unix.tipc.AFTIPCSelectorProvider";
                }

                @Override
                protected final Set<String> uriSchemes() {
                    return new HashSet<String>(Arrays.asList("tipc", "http+tipc", "https+tipc"));
                }

                /*
                 * WARNING - void declaration
                 */
                static /* synthetic */ AFTIPCSocketAddress lambda$$1(int x$0, byte[] x$1, ObjectPool.Lease x$2) throws SocketException {
                    void var2_2;
                    void var1_1;
                    int n;
                    return new AFTIPCSocketAddress(n, (byte[])var1_1, (ObjectPool.Lease)var2_2, 0);
                }

                /*
                 * WARNING - void declaration
                 */
                static /* synthetic */ AFTIPCSocketAddress lambda$$0(int x$0, byte[] x$1, ObjectPool.Lease x$2) throws SocketException {
                    void var2_2;
                    void var1_1;
                    return AFTIPCSocketAddress.access$200(x$0, (byte[])var1_1, (ObjectPool.Lease)var2_2);
                }
            });
            try {
                Class.forName("org.newsclub.net.unix.tipc.AFTIPCSelectorProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return afTipc;
    }

    /*
     * WARNING - void declaration
     */
    /* synthetic */ AFTIPCSocketAddress(int x0, byte[] x1, ObjectPool.Lease x2, byte by) throws SocketException {
        this((int)var1_1, (byte[])var2_2, (ObjectPool.Lease<ByteBuffer>)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ AFTIPCSocketAddress access$200(int x0, byte[] x1, ObjectPool.Lease x2) throws SocketException {
        void var2_2;
        void var1_1;
        int n = x0;
        return AFTIPCSocketAddress.newDeserializedAFSocketAddress(n, (byte[])var1_1, (ObjectPool.Lease<ByteBuffer>)var2_2, AFTIPCSocketAddress.addressFamily(), AFTIPCSocketAddress$$Lambda$1.lambdaFactory$$62da34d0());
    }

    static /* synthetic */ AFTIPCSocketAddress access$lambda$0(int n, byte[] byArray, ObjectPool.Lease lease) {
        return new AFTIPCSocketAddress(n, byArray, lease);
    }

    @NonNullByDefault
    public static final class Scope
    extends NamedInteger {
        public static final Scope SCOPE_CLUSTER;
        public static final Scope SCOPE_NODE;
        public static final Scope SCOPE_NOT_SPECIFIED;
        private static final @NonNull Scope[] VALUES;

        /*
         * WARNING - void declaration
         */
        private Scope(int id) {
            super((int)var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private Scope(String name, int id) {
            super((String)var1_1, (int)var2_2);
            void var2_2;
            void var1_1;
        }

        public static Scope ofValue(int v) {
            int n;
            return (Scope)Scope.ofValue((NamedInteger[])VALUES, (NamedInteger.UndefinedValueConstructor)AFTIPCSocketAddress$Scope$$Lambda$1.lambdaFactory$$6ff0865c(), (int)n);
        }

        static {
            SCOPE_NOT_SPECIFIED = new Scope("SCOPE_NOT_SPECIFIED", 0);
            SCOPE_CLUSTER = new Scope("SCOPE_CLUSTER", 2);
            SCOPE_NODE = new Scope("SCOPE_NODE", 3);
            VALUES = (Scope[])Scope.init((NamedInteger[])new Scope[]{SCOPE_NOT_SPECIFIED, SCOPE_CLUSTER, SCOPE_NODE});
        }

        static /* synthetic */ Scope access$lambda$0(int n) {
            return new Scope(n);
        }
    }

    @NonNullByDefault
    public static final class AddressType
    extends NamedInteger {
        public static final AddressType SERVICE_RANGE = new AddressType("SERVICE_RANGE", 1, AFTIPCSocketAddress$AddressType$$Lambda$3.lambdaFactory$$4e38064f());
        public static final AddressType SERVICE_ADDR;
        public static final AddressType SOCKET_ADDR;
        private static final @NonNull AddressType[] VALUES;
        private final DebugStringProvider ds;

        /*
         * WARNING - void declaration
         */
        private AddressType(int id) {
            super((int)var1_1);
            void var1_1;
            this.ds = AFTIPCSocketAddress$AddressType$$Lambda$1.lambdaFactory$$4e38064f();
        }

        /*
         * WARNING - void declaration
         */
        private AddressType(String name, int id, DebugStringProvider ds) {
            super((String)var1_1, (int)var2_2);
            void var3_3;
            void var2_2;
            void var1_1;
            this.ds = var3_3;
        }

        static AddressType ofValue(int v) {
            int n;
            return (AddressType)AddressType.ofValue((NamedInteger[])VALUES, (NamedInteger.UndefinedValueConstructor)AFTIPCSocketAddress$AddressType$$Lambda$2.lambdaFactory$$6ff0865c(), (int)n);
        }

        private static String formatTIPCInt(int i) {
            int n;
            return String.format(Locale.ENGLISH, "0x%08x", (long)n & 0xFFFFFFFFL);
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ String lambda$new$5c9c2537$1(int a, int b, int c) {
            void var2_2;
            void var1_1;
            int n;
            return ":" + AFSocketAddress.toUnsignedString(n) + ":" + AFSocketAddress.toUnsignedString((int)var1_1) + ":" + AFSocketAddress.toUnsignedString((int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ String lambda$static$faadebcb$3(int a, int b, int c) {
            void var2_2;
            void var1_1;
            int n;
            return AddressType.formatTIPCInt(n) + "@" + AddressType.formatTIPCInt((int)var1_1) + (c == 0 ? "" : ":" + AddressType.formatTIPCInt((int)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ String lambda$static$faadebcb$2(int a, int b, int c) {
            void var2_2;
            void var1_1;
            int n;
            return AddressType.formatTIPCInt(n) + "@" + AddressType.formatTIPCInt((int)var1_1) + (c == 0 ? "" : ":" + AddressType.formatTIPCInt((int)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ String lambda$static$faadebcb$1(int a, int b, int c) {
            void var2_2;
            void var1_1;
            int n;
            return AddressType.formatTIPCInt(n) + "@" + AddressType.formatTIPCInt((int)var1_1) + "-" + AddressType.formatTIPCInt((int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ String access$000(AddressType x0, Scope x1, int x2, int x3, int x4) {
            void var3_3;
            void var2_2;
            void var1_1;
            int n = x4;
            AddressType addressType = x0;
            if (addressType == SOCKET_ADDR && var1_1.equals(Scope.SCOPE_NOT_SPECIFIED)) {
                return addressType.name() + "(" + addressType.value() + ");" + addressType.ds.toDebugString((int)var2_2, (int)var3_3, n);
            }
            return addressType.name() + "(" + addressType.value() + ");" + var1_1 + ":" + addressType.ds.toDebugString((int)var2_2, (int)var3_3, n);
        }

        static {
            VALUES = (AddressType[])AddressType.init((NamedInteger[])new AddressType[]{SERVICE_RANGE, SERVICE_ADDR = new AddressType("SERVICE_ADDR", 2, AFTIPCSocketAddress$AddressType$$Lambda$4.lambdaFactory$$4e38064f()), SOCKET_ADDR = new AddressType("SOCKET_ADDR", 3, AFTIPCSocketAddress$AddressType$$Lambda$5.lambdaFactory$$4e38064f())});
        }

        static /* synthetic */ AddressType access$lambda$0(int n) {
            return new AddressType(n);
        }

        @FunctionalInterface
        static interface DebugStringProvider
        extends Serializable {
            public String toDebugString(int var1, int var2, int var3);
        }
    }
}

