/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import java.io.Closeable;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Pipe;
import java.nio.channels.spi.SelectorProvider;
import org.newsclub.net.unix.AFCore;
import org.newsclub.net.unix.AFPipe$$Lambda$1;
import org.newsclub.net.unix.AFSelectorProvider;
import org.newsclub.net.unix.AFSupplier;
import org.newsclub.net.unix.FileDescriptorAccess;
import org.newsclub.net.unix.NativeUnixSocket;

public final class AFPipe
extends Pipe
implements Closeable {
    static final AFSupplier<Integer> DUMMY_TIMEOUT = AFPipe$$Lambda$1.lambdaFactory$$17065dc5();
    private final AFCore sourceCore;
    private final AFCore sinkCore;
    private final SourceChannel sourceChannel;
    private final SinkChannel sinkChannel;
    private final int options;

    /*
     * WARNING - void declaration
     */
    AFPipe(AFSelectorProvider<?> provider, boolean selectable) throws IOException {
        void var1_1;
        void var2_2;
        NativeUnixSocket.ensureSupported();
        this.sourceCore = new AFCore(this, null);
        this.sinkCore = new AFCore(this, null);
        boolean isSocket = NativeUnixSocket.initPipe(this.sourceCore.fd, this.sinkCore.fd, selectable);
        this.options = var2_2 != false ? 0 : 8;
        this.sourceChannel = new SourceChannel(this, provider);
        this.sinkChannel = new SinkChannel(this, (AFSelectorProvider)var1_1);
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public final SinkChannel sink() {
        return this.sinkChannel;
    }

    final FileDescriptor sourceFD() {
        return this.sourceCore.fd;
    }

    final FileDescriptor sinkFD() {
        return this.sinkCore.fd;
    }

    @Override
    public final void close() throws IOException {
        AFPipe aFPipe;
        try {
            aFPipe = this;
            aFPipe.sourceChannel.close();
            aFPipe = this;
        }
        catch (Throwable throwable) {
            AFPipe aFPipe2 = this;
            aFPipe2.sinkChannel.close();
            throw throwable;
        }
        aFPipe.sinkChannel.close();
    }

    final int getOptions() {
        return this.options;
    }

    static /* synthetic */ Integer lambda$static$0() {
        return 0;
    }

    public final class SourceChannel
    extends Pipe.SourceChannel
    implements FileDescriptorAccess {
        final /* synthetic */ AFPipe this$0;

        /*
         * WARNING - void declaration
         */
        SourceChannel(AFPipe this$0, AFSelectorProvider provider) {
            void var2_2;
            void var1_1;
            this.this$0 = var1_1;
            super((SelectorProvider)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
            void var2_2;
            void var1_1;
            if (length == 0) {
                return 0L;
            }
            return this.read((ByteBuffer)var1_1[var2_2]);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final long read(ByteBuffer[] dsts) throws IOException {
            void var1_1;
            return this.read(dsts, 0, ((void)var1_1).length);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int read(ByteBuffer dst) throws IOException {
            void var1_1;
            return this.this$0.sourceCore.read((ByteBuffer)var1_1, DUMMY_TIMEOUT, null, this.this$0.options);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void implConfigureBlocking(boolean block) throws IOException {
            void var1_1;
            this.this$0.sourceCore.implConfigureBlocking((boolean)var1_1);
        }

        @Override
        protected final void implCloseSelectableChannel() throws IOException {
            this.this$0.sourceCore.close();
        }
    }

    public final class SinkChannel
    extends Pipe.SinkChannel
    implements FileDescriptorAccess {
        final /* synthetic */ AFPipe this$0;

        /*
         * WARNING - void declaration
         */
        SinkChannel(AFPipe this$0, AFSelectorProvider provider) {
            void var2_2;
            void var1_1;
            this.this$0 = var1_1;
            super((SelectorProvider)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
            void var2_2;
            void var1_1;
            if (length == 0) {
                return 0L;
            }
            return this.write((ByteBuffer)var1_1[var2_2]);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final long write(ByteBuffer[] srcs) throws IOException {
            void var1_1;
            return this.write(srcs, 0, ((void)var1_1).length);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int write(ByteBuffer src) throws IOException {
            void var1_1;
            return this.this$0.sinkCore.write((ByteBuffer)var1_1, DUMMY_TIMEOUT, null, this.this$0.options);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void implConfigureBlocking(boolean block) throws IOException {
            void var1_1;
            this.this$0.sinkCore.implConfigureBlocking((boolean)var1_1);
        }

        @Override
        protected final void implCloseSelectableChannel() throws IOException {
            this.this$0.sinkCore.close();
        }
    }
}

