/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import java.io.UnsupportedEncodingException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Objects;
import org.newsclub.net.unix.AFAddressFamily;

class AFInetAddress {
    private static final byte[] LOCAL_AF = new byte[]{127, 0, 0, -81};

    AFInetAddress() {
    }

    /*
     * WARNING - void declaration
     */
    static final String createUnresolvedHostname(byte[] socketAddress, AFAddressFamily<?> af) {
        void var2_2;
        void var1_1;
        StringBuilder sb = new StringBuilder(1 + socketAddress.length + 12 + 8);
        sb.append('[');
        try {
            sb.append(URLEncoder.encode(new String(socketAddress, StandardCharsets.ISO_8859_1), StandardCharsets.ISO_8859_1.toString()));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
        sb.append('.');
        sb.append(af.getJuxString());
        sb.append(".junixsocket");
        String str = sb.toString();
        if (str.length() < 64 || str.getBytes(StandardCharsets.UTF_8).length <= 255) {
            return str;
        }
        sb.setLength(0);
        sb.append('[');
        sb.append("%%");
        int n = socketAddress.length;
        for (int i = 0; i < n; ++i) {
            sb.append(String.format(Locale.ENGLISH, "%02x", socketAddress[i]));
        }
        sb.append('.');
        sb.append(var1_1.getJuxString());
        sb.append(".junixsocket");
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    static final InetAddress wrapAddress(byte[] socketAddress, AFAddressFamily<?> af) {
        byte[] byArray;
        Objects.requireNonNull(af);
        if (socketAddress == null || socketAddress.length == 0) {
            return null;
        }
        String string = AFInetAddress.createUnresolvedHostname(socketAddress, byArray);
        Object hostname = string;
        byArray = string.getBytes(StandardCharsets.UTF_8);
        if (byArray.length > 255) {
            throw new IllegalStateException("junixsocket address is too long to wrap as InetAddress");
        }
        try {
            return InetAddress.getByAddress((String)hostname, LOCAL_AF);
        }
        catch (UnknownHostException e) {
            void var0_1;
            throw new IllegalStateException((Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    static final byte[] unwrapAddress(InetAddress addr, AFAddressFamily<?> af) throws SocketException {
        Objects.requireNonNull(addr);
        if (!AFInetAddress.isSupportedAddress(addr, af)) {
            throw new SocketException("Unsupported address");
        }
        String hostname = addr.getHostName();
        try {
            void var1_2;
            return AFInetAddress.unwrapAddress(hostname, var1_2);
        }
        catch (IllegalArgumentException e) {
            void var0_1;
            throw (SocketException)new SocketException("Unsupported address").initCause((Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static byte[] unwrapAddress(String hostname, AFAddressFamily<?> af) throws SocketException {
        String i2;
        Objects.requireNonNull(hostname);
        if (!hostname.endsWith(".junixsocket")) {
            throw new SocketException("Unsupported address");
        }
        int end = hostname.length() - 12;
        int domDot = -1;
        for (int i2 = end - 1; i2 >= 0; --i2) {
            char c = hostname.charAt(i2);
            if (c != '.') continue;
            domDot = i2;
            break;
        }
        if (AFAddressFamily.getAddressFamily(i2 = hostname.substring(domDot + 1, end)) != af) {
            throw new SocketException("Incompatible address");
        }
        String encodedHostname = hostname.substring(1, domDot);
        if (encodedHostname.startsWith("%%")) {
            int len = encodedHostname.length();
            if ((len & 1) == 1) {
                throw new IllegalStateException("Length of hex-encoded wrapping must be even");
            }
            byte[] unwrapped = new byte[(len - 2) / 2];
            int i3 = 2;
            int n = encodedHostname.length();
            int o = 0;
            while (i3 < n) {
                int n2 = i3;
                int v = Integer.parseInt(encodedHostname.substring(n2, n2 + 2), 16);
                unwrapped[o] = (byte)(v & 0xFF);
                i3 += 2;
                ++o;
            }
            return unwrapped;
        }
        try {
            String string;
            return URLDecoder.decode(string, StandardCharsets.ISO_8859_1.toString()).getBytes(StandardCharsets.ISO_8859_1);
        }
        catch (UnsupportedEncodingException e) {
            void var1_4;
            throw new IllegalStateException((Throwable)var1_4);
        }
    }

    /*
     * WARNING - void declaration
     */
    static boolean isSupportedAddress(InetAddress addr, AFAddressFamily<?> af) {
        if (addr instanceof Inet4Address && addr.isLoopbackAddress()) {
            void var1_1;
            String string;
            string = ((InetAddress)((Object)string)).getHostName();
            return string.endsWith(var1_1.getJuxInetAddressSuffix());
        }
        return false;
    }
}

