/*
 * Decompiled with CFR 0.152.
 */
package org.publicvalue.multiplatform.oidc.types;

import io.ktor.util.Base64Kt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.publicvalue.multiplatform.oidc.OpenIdConnectException;
import org.publicvalue.multiplatform.oidc.types.IdToken;
import org.publicvalue.multiplatform.oidc.types.JwtClaims;
import org.publicvalue.multiplatform.oidc.types.JwtHeader;
import org.publicvalue.multiplatform.oidc.types.JwtKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\f\b\u0086\b\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB!\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001a\u0010\u000e\u001a\u00020\r2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0011\u001a\u00020\u0010H\u00d6\u0001\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u0006H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0015\u001a\u0004\b\u0016\u0010\u000bR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019R\u0019\u0010\u0007\u001a\u0004\u0018\u00010\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u001a\u001a\u0004\b\u001b\u0010\u0014"}, d2={"Lorg/publicvalue/multiplatform/oidc/types/Jwt;", "", "Lorg/publicvalue/multiplatform/oidc/types/JwtHeader;", "header", "Lorg/publicvalue/multiplatform/oidc/types/IdToken;", "payload", "", "signature", "<init>", "(Lorg/publicvalue/multiplatform/oidc/types/JwtHeader;Lorg/publicvalue/multiplatform/oidc/types/IdToken;Ljava/lang/String;)V", "component1", "()Lorg/publicvalue/multiplatform/oidc/types/JwtHeader;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "()Ljava/lang/String;", "Lorg/publicvalue/multiplatform/oidc/types/JwtHeader;", "getHeader", "Lorg/publicvalue/multiplatform/oidc/types/IdToken;", "getPayload", "()Lorg/publicvalue/multiplatform/oidc/types/IdToken;", "Ljava/lang/String;", "getSignature", "Companion"})
public final class Jwt {
    public static final Companion Companion = new Companion(null);
    private final JwtHeader header;
    private final IdToken payload;
    private final String signature;

    /*
     * WARNING - void declaration
     */
    public Jwt(JwtHeader header, IdToken payload, String signature) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        this.header = var1_1;
        this.payload = var2_2;
        this.signature = var3_3;
    }

    public final JwtHeader getHeader() {
        return this.header;
    }

    public final IdToken getPayload() {
        return this.payload;
    }

    public final String getSignature() {
        return this.signature;
    }

    public final JwtHeader component1() {
        return this.header;
    }

    public final String toString() {
        return "Jwt(header=" + this.header + ", payload=" + this.payload + ", signature=" + this.signature + ")";
    }

    public final int hashCode() {
        int n = this.header.hashCode();
        n = n * 31 + this.payload.hashCode();
        n = n * 31 + (this.signature == null ? 0 : this.signature.hashCode());
        return n;
    }

    public final boolean equals(Object other) {
        Jwt jwt;
        if (this == other) {
            return true;
        }
        if (!(other instanceof Jwt)) {
            return false;
        }
        jwt = jwt;
        if (!Intrinsics.areEqual((Object)this.header, (Object)jwt.header)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.payload, (Object)jwt.payload)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.signature, (Object)jwt.signature);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\b"}, d2={"Lorg/publicvalue/multiplatform/oidc/types/Jwt$Companion;", "", "<init>", "()V", "", "string", "Lorg/publicvalue/multiplatform/oidc/types/Jwt;", "parse", "(Ljava/lang/String;)Lorg/publicvalue/multiplatform/oidc/types/Jwt;"})
    @SourceDebugExtension(value={"SMAP\nJwt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Jwt.kt\norg/publicvalue/multiplatform/oidc/types/Jwt$Companion\n+ 2 RunCatchingWrapException.kt\norg/publicvalue/multiplatform/oidc/RunCatchingWrapExceptionKt\n*L\n1#1,161:1\n4#2,6:162\n*S KotlinDebug\n*F\n+ 1 Jwt.kt\norg/publicvalue/multiplatform/oidc/types/Jwt$Companion\n*L\n53#1:162,6\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        public static Jwt parse(String string) throws OpenIdConnectException {
            List list;
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            char[] cArray = new char[1];
            char[] cArray2 = cArray;
            cArray[0] = 46;
            List parts = StringsKt.split$default((CharSequence)string, (char[])cArray2, (boolean)false, (int)0, (int)6, null);
            if (parts.size() > 3) {
                throw new OpenIdConnectException.UnsupportedFormat("Expected at most 3 JWT token parts");
            }
            if (parts.size() < 2) {
                throw new OpenIdConnectException.UnsupportedFormat("Expected at least 2 JWT token parts");
            }
            String headerB64 = (String)parts.get(0);
            String payloadB64 = (String)parts.get(1);
            List signatureB64 = (String)CollectionsKt.getOrNull((List)parts, (int)2);
            try {
                void var2_3;
                signatureB64 = new Jwt(JwtHeader.Companion.parse(Base64Kt.decodeBase64String((String)cArray2)), JwtKt.access$toOpenIdConnectToken-TbvNI7g(JwtClaims.Companion.parse-mdhgNVA(Base64Kt.decodeBase64String((String)var2_3))), (String)((Object)signatureB64));
            }
            catch (OpenIdConnectException openIdConnectException) {
                signatureB64 = openIdConnectException;
                throw openIdConnectException;
            }
            catch (Throwable e$iv) {
                void var0_1;
                String string2 = e$iv.getMessage();
                if (string2 == null) {
                    string2 = "Unknown error";
                }
                throw new OpenIdConnectException.TechnicalFailure(string2, (Throwable)var0_1);
            }
            return list;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

