/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime.internal.format;

import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.internal.format.Accessor;
import kotlinx.datetime.internal.format.FieldFormatDirective;
import kotlinx.datetime.internal.format.UnsignedFieldSpec;
import kotlinx.datetime.internal.format.formatter.FormatterStructure;
import kotlinx.datetime.internal.format.formatter.SpacePaddedFormatter;
import kotlinx.datetime.internal.format.formatter.UnsignedIntFormatterStructure;
import kotlinx.datetime.internal.format.parser.ParserOperationKt;
import kotlinx.datetime.internal.format.parser.ParserStructure;

public abstract class UnsignedIntFieldFormatDirective<Target>
implements FieldFormatDirective<Target> {
    private final UnsignedFieldSpec<Target> field;
    private final int minDigits;
    private final Integer spacePadding;
    private final int maxDigits;

    /*
     * WARNING - void declaration
     */
    public UnsignedIntFieldFormatDirective(UnsignedFieldSpec<? super Target> field, int minDigits, Integer spacePadding) {
        void var3_3;
        void var2_2;
        String string;
        Intrinsics.checkNotNullParameter(field, (String)"field");
        this.field = string;
        this.minDigits = var2_2;
        this.spacePadding = var3_3;
        this.maxDigits = this.field.getMaxDigits();
        if (!(this.minDigits >= 0)) {
            string = "The minimum number of digits (" + this.minDigits + ") is negative";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(this.maxDigits >= this.minDigits)) {
            string = "The maximum number of digits (" + this.maxDigits + ") is less than the minimum number of digits (" + this.minDigits + ')';
            throw new IllegalArgumentException(string.toString());
        }
        if (this.spacePadding != null && !(this.spacePadding > this.minDigits)) {
            string = "The space padding (" + this.spacePadding + ") should be more than the minimum number of digits (" + this.minDigits + ')';
            throw new IllegalArgumentException(string.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final FormatterStructure<Target> formatter() {
        void var1_1;
        UnsignedIntFormatterStructure formatter2 = new UnsignedIntFormatterStructure((Function1)new Function1<Target, Integer>(this.field.getAccessor()){
            {
                void var1_1;
            }

            public final Integer invoke(Target p0) {
                return (Integer)((Accessor)this.receiver).getterNotNull(p0);
            }
        }, this.minDigits);
        if (this.spacePadding != null) {
            return new SpacePaddedFormatter(formatter2, this.spacePadding);
        }
        return (FormatterStructure)var1_1;
    }

    @Override
    public final ParserStructure<Target> parser() {
        return ParserOperationKt.spaceAndZeroPaddedUnsignedInt$default$304b0f3c(this.minDigits, this.maxDigits, this.spacePadding, this.field.getAccessor(), this.field.getName(), false, 32);
    }
}

