/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime;

import java.time.DateTimeException;
import java.time.format.DateTimeParseException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.datetime.DateTimeFormatException;
import kotlinx.datetime.LocalTime;
import kotlinx.datetime.format.DateTimeFormat;
import kotlinx.datetime.format.DateTimeFormatBuilder;
import kotlinx.datetime.format.LocalTimeFormat;
import kotlinx.datetime.serializers.LocalTimeIso8601Serializer;
import kotlinx.serialization.Serializable;

@Serializable(with=LocalTimeIso8601Serializer.class)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0007\u0018\u0000 $2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0002$%B-\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0000\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\u0018\u0010\r\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0000H\u0096\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001a\u0010\u0011\u001a\u00020\u00102\b\u0010\f\u001a\u0004\u0018\u00010\u000fH\u0096\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0013\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\r\u0010\u0015\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0014J\r\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\r\u0010\u0019\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0019\u0010\u0014J\u000f\u0010\u001b\u001a\u00020\u001aH\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0003\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0014R\u0011\u0010\u0005\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0014R\u001a\u0010\n\u001a\u00020\t8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\n\u0010!\u001a\u0004\b\"\u0010#"}, d2={"Lkotlinx/datetime/LocalTime;", "", "", "hour", "minute", "second", "nanosecond", "<init>", "(IIII)V", "Ljava/time/LocalTime;", "value", "(Ljava/time/LocalTime;)V", "other", "compareTo", "(Lkotlinx/datetime/LocalTime;)I", "", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "toMillisecondOfDay", "", "toNanosecondOfDay", "()J", "toSecondOfDay", "", "toString", "()Ljava/lang/String;", "getHour", "getMinute", "getNanosecond", "getSecond", "Ljava/time/LocalTime;", "getValue$kotlinx_datetime", "()Ljava/time/LocalTime;", "Companion", "Formats"})
public final class LocalTime
implements Comparable<LocalTime> {
    public static final Companion Companion = new Companion(null);
    private final java.time.LocalTime value;
    private static final LocalTime MIN;
    private static final LocalTime MAX;

    /*
     * WARNING - void declaration
     */
    public LocalTime(java.time.LocalTime value) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.value = var1_1;
    }

    public final java.time.LocalTime getValue$kotlinx_datetime() {
        return this.value;
    }

    /*
     * WARNING - void declaration
     */
    public LocalTime(int hour22, int minute2, int second2, int nanosecond) {
        void var1_2;
        LocalTime localTime;
        LocalTime localTime2 = this;
        try {
            void var3_5;
            void var2_4;
            localTime = localTime2;
            java.time.LocalTime hour22 = java.time.LocalTime.of(hour22, (int)var2_4, (int)var3_5, nanosecond);
        }
        catch (DateTimeException e) {
            void var1_3;
            throw new IllegalArgumentException((Throwable)var1_3);
        }
        Intrinsics.checkNotNull((Object)var1_2);
        localTime((java.time.LocalTime)var1_2);
    }

    public /* synthetic */ LocalTime(int n, int n2, int n3, int n4, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n5 & 4) != 0) {
            n3 = 0;
        }
        if ((n5 & 8) != 0) {
            n4 = 0;
        }
        this(n, n2, n3, n4);
    }

    public final int getHour() {
        return this.value.getHour();
    }

    public final int getMinute() {
        return this.value.getMinute();
    }

    public final int getSecond() {
        return this.value.getSecond();
    }

    public final int getNanosecond() {
        return this.value.getNano();
    }

    public final int toSecondOfDay() {
        return this.value.toSecondOfDay();
    }

    public final int toMillisecondOfDay() {
        return (int)(this.value.toNanoOfDay() / 1000000L);
    }

    public final long toNanosecondOfDay() {
        return this.value.toNanoOfDay();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        void var1_1;
        return this == other || other instanceof LocalTime && Intrinsics.areEqual((Object)this.value, (Object)((LocalTime)var1_1).value);
    }

    public final int hashCode() {
        return this.value.hashCode();
    }

    public final String toString() {
        String string = this.value.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int compareTo(LocalTime other) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.value.compareTo(var1_1.value);
    }

    static {
        java.time.LocalTime localTime = java.time.LocalTime.MIN;
        Intrinsics.checkNotNullExpressionValue((Object)localTime, (String)"MIN");
        MIN = new LocalTime(localTime);
        java.time.LocalTime localTime2 = java.time.LocalTime.MAX;
        Intrinsics.checkNotNullExpressionValue((Object)localTime2, (String)"MAX");
        MAX = new LocalTime(localTime2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\u0017\u0010\u000b\u001a\u0013\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\u0002\b\u000fJ\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0012J\u001e\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001a2\u000e\b\u0002\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\nJ\u0010\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001dH\u0007J\u000f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00040\u001fH\u00c6\u0001R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006 "}, d2={"Lkotlinx/datetime/LocalTime$Companion;", "", "()V", "MAX", "Lkotlinx/datetime/LocalTime;", "getMAX$kotlinx_datetime", "()Lkotlinx/datetime/LocalTime;", "MIN", "getMIN$kotlinx_datetime", "Format", "Lkotlinx/datetime/format/DateTimeFormat;", "builder", "Lkotlin/Function1;", "Lkotlinx/datetime/format/DateTimeFormatBuilder$WithTime;", "", "Lkotlin/ExtensionFunctionType;", "fromMillisecondOfDay", "millisecondOfDay", "", "fromNanosecondOfDay", "nanosecondOfDay", "", "fromSecondOfDay", "secondOfDay", "parse", "input", "", "format", "isoString", "", "serializer", "Lkotlinx/serialization/KSerializer;", "kotlinx-datetime"})
    @SourceDebugExtension(value={"SMAP\nLocalTime.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalTime.kt\nkotlinx/datetime/LocalTime$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,93:1\n1#2:94\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private static LocalTime parse(CharSequence input, DateTimeFormat<LocalTime> format) {
            void var1_2;
            Object object;
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Intrinsics.checkNotNullParameter(format, (String)"format");
            if (format == Formats.INSTANCE.getISO()) {
                try {
                    Object p0 = java.time.LocalTime.parse(input);
                    p0 = new LocalTime((java.time.LocalTime)p0);
                }
                catch (DateTimeParseException e) {
                    void var0_1;
                    throw new DateTimeFormatException((Throwable)var0_1);
                }
                return object;
            }
            return (LocalTime)var1_2.parse((CharSequence)object);
        }

        public static /* synthetic */ LocalTime parse$default$3c3a6611(Companion companion, CharSequence charSequence, DateTimeFormat dateTimeFormat, int n) {
            dateTimeFormat = Formats.INSTANCE.getISO();
            return kotlinx.datetime.LocalTime$Companion.parse(charSequence, dateTimeFormat);
        }

        public final LocalTime getMIN$kotlinx_datetime() {
            return MIN;
        }

        public final LocalTime getMAX$kotlinx_datetime() {
            return MAX;
        }

        public static DateTimeFormat<LocalTime> Format(Function1<? super DateTimeFormatBuilder.WithTime, Unit> builder) {
            Function1<? super DateTimeFormatBuilder.WithTime, Unit> function1;
            Intrinsics.checkNotNullParameter(builder, (String)"builder");
            return LocalTimeFormat.Companion.build(function1);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

