/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath.model;

import com.github.ajalt.colormath.Color;
import com.github.ajalt.colormath.ColorComponentInfo;
import com.github.ajalt.colormath.WhitePoint;
import com.github.ajalt.colormath.internal.ColorSpaceUtilsKt;
import com.github.ajalt.colormath.internal.MatrixKt;
import com.github.ajalt.colormath.model.RGB;
import com.github.ajalt.colormath.model.RGBColorSpace;
import com.github.ajalt.colormath.model.RGBColorSpacesKt;
import com.github.ajalt.colormath.model.xyY;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0014\n\u0002\b\u0006\b\u0083\b\u0018\u00002\u00020\u0001BV\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\b\u0012\u001d\u0010\u0010\u001a\u0019\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\u0002\b\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0013\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J0\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0096\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001a\u0010\u001c\u001a\u00020\u001b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0019H\u0096\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u000f\u0010\u001f\u001a\u00020\u001eH\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u0010\u0010!\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b!\u0010\u0014R\u001a\u0010\u0003\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\"\u001a\u0004\b#\u0010\u0014R\u001a\u0010\u0005\u001a\u00020\u00048\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010$\u001a\u0004\b%\u0010&R\u001a\u0010\u0007\u001a\u00020\u00068\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010'\u001a\u0004\b(\u0010)R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010*R\u0014\u0010\n\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010*R\u0014\u0010\u000b\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010*R+\u0010\u0010\u001a\u0019\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\u0002\b\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010+R \u0010.\u001a\b\u0012\u0004\u0012\u00020-0,8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b.\u0010/\u001a\u0004\b0\u00101R\u001a\u00103\u001a\u0002028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b3\u00104\u001a\u0004\b5\u00106R\u001a\u00107\u001a\u0002028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b7\u00104\u001a\u0004\b8\u00106"}, d2={"Lcom/github/ajalt/colormath/model/RGBColorSpaceImpl;", "Lcom/github/ajalt/colormath/model/RGBColorSpace;", "", "name", "Lcom/github/ajalt/colormath/WhitePoint;", "whitePoint", "Lcom/github/ajalt/colormath/model/RGBColorSpace$TransferFunctions;", "transferFunctions", "Lcom/github/ajalt/colormath/model/xyY;", "r", "g", "b", "Lkotlin/Function2;", "Lcom/github/ajalt/colormath/Color;", "Lcom/github/ajalt/colormath/model/RGB;", "Lkotlin/ExtensionFunctionType;", "convertImpl", "<init>", "(Ljava/lang/String;Lcom/github/ajalt/colormath/WhitePoint;Lcom/github/ajalt/colormath/model/RGBColorSpace$TransferFunctions;Lcom/github/ajalt/colormath/model/xyY;Lcom/github/ajalt/colormath/model/xyY;Lcom/github/ajalt/colormath/model/xyY;Lkotlin/jvm/functions/Function2;)V", "toString", "()Ljava/lang/String;", "", "alpha", "invoke", "(FFFF)Lcom/github/ajalt/colormath/model/RGB;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "component1", "Ljava/lang/String;", "getName", "Lcom/github/ajalt/colormath/WhitePoint;", "getWhitePoint", "()Lcom/github/ajalt/colormath/WhitePoint;", "Lcom/github/ajalt/colormath/model/RGBColorSpace$TransferFunctions;", "getTransferFunctions", "()Lcom/github/ajalt/colormath/model/RGBColorSpace$TransferFunctions;", "Lcom/github/ajalt/colormath/model/xyY;", "Lkotlin/jvm/functions/Function2;", "", "Lcom/github/ajalt/colormath/ColorComponentInfo;", "components", "Ljava/util/List;", "getComponents", "()Ljava/util/List;", "", "matrixToXyz", "[F", "getMatrixToXyz", "()[F", "matrixFromXyz", "getMatrixFromXyz"})
@SourceDebugExtension(value={"SMAP\nRGBColorSpaces.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RGBColorSpaces.kt\ncom/github/ajalt/colormath/model/RGBColorSpaceImpl\n+ 2 ColorSpaceUtils.kt\ncom/github/ajalt/colormath/internal/ColorSpaceUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,420:1\n26#2:421\n15#2,13:422\n1#3:435\n*S KotlinDebug\n*F\n+ 1 RGBColorSpaces.kt\ncom/github/ajalt/colormath/model/RGBColorSpaceImpl\n*L\n255#1:421\n255#1:422,13\n255#1:435\n*E\n"})
final class RGBColorSpaceImpl
implements RGBColorSpace {
    private final String name;
    private final WhitePoint whitePoint;
    private final RGBColorSpace.TransferFunctions transferFunctions;
    private final xyY r;
    private final xyY g;
    private final xyY b;
    private final Function2<RGBColorSpaceImpl, Color, RGB> convertImpl;
    private final List<ColorComponentInfo> components;
    private final float[] matrixToXyz;
    private final float[] matrixFromXyz;

    /*
     * WARNING - void declaration
     */
    public RGBColorSpaceImpl(String name, WhitePoint whitePoint, RGBColorSpace.TransferFunctions transferFunctions, xyY r, xyY g, xyY b, Function2<? super RGBColorSpaceImpl, ? super Color, RGB> convertImpl) {
        void var3_5;
        void var2_4;
        float[] fArray;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)whitePoint, (String)"whitePoint");
        Intrinsics.checkNotNullParameter((Object)transferFunctions, (String)"transferFunctions");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter(convertImpl, (String)"convertImpl");
        this.name = fArray;
        this.whitePoint = var2_4;
        this.transferFunctions = var3_5;
        this.r = r;
        this.g = g;
        this.b = b;
        this.convertImpl = convertImpl;
        this.components = ColorSpaceUtilsKt.zeroOneComponentInfo("RGB");
        this.matrixToXyz = RGBColorSpacesKt.access$rgbToXyzMatrix(this.getWhitePoint(), this.r, this.g, this.b);
        fArray = this.getMatrixToXyz();
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"rowMajor");
        boolean bl = true;
        bl = false;
        float[] fArray2 = fArray;
        this.matrixFromXyz = MatrixKt.inverse-M2Qqt3Q(fArray, false);
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final WhitePoint getWhitePoint() {
        return this.whitePoint;
    }

    @Override
    public final RGBColorSpace.TransferFunctions getTransferFunctions() {
        return this.transferFunctions;
    }

    public final List<ColorComponentInfo> getComponents() {
        return this.components;
    }

    @Override
    public final float[] getMatrixToXyz() {
        return this.matrixToXyz;
    }

    @Override
    public final float[] getMatrixFromXyz() {
        return this.matrixFromXyz;
    }

    public final String toString() {
        return this.getName();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final RGB invoke(float r, float g, float b, float alpha) {
        void var3_3;
        void var2_2;
        void var1_1;
        return new RGB((float)var1_1, (float)var2_2, (float)var3_3, alpha, this);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RGBColorSpace)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getName(), (Object)((RGBColorSpace)other).getName())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getWhitePoint(), (Object)((RGBColorSpace)other).getWhitePoint())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getTransferFunctions(), (Object)((RGBColorSpace)other).getTransferFunctions())) {
            return false;
        }
        if (other instanceof RGBColorSpaceImpl) {
            if (!Intrinsics.areEqual((Object)this.r, (Object)((RGBColorSpaceImpl)other).r)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.g, (Object)((RGBColorSpaceImpl)other).g)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.b, (Object)((RGBColorSpaceImpl)other).b)) {
                return false;
            }
        } else {
            void var1_1;
            if (!Arrays.equals(this.getMatrixToXyz(), ((RGBColorSpace)other).getMatrixToXyz())) {
                return false;
            }
            if (!Arrays.equals(this.getMatrixFromXyz(), ((RGBColorSpace)var1_1).getMatrixFromXyz())) {
                return false;
            }
        }
        return true;
    }

    public final int hashCode() {
        int n;
        int result = this.getName().hashCode();
        result = 31 * result + this.getWhitePoint().hashCode();
        result = 31 * result + this.getTransferFunctions().hashCode();
        result = 31 * result + this.r.hashCode();
        result = 31 * result + this.g.hashCode();
        n = 31 * n + this.b.hashCode();
        return n;
    }

    public final String component1() {
        return this.name;
    }
}

