/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.helpers.ThrowableToStringArray;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.status.StatusUtil;
import ch.qos.logback.core.util.CachingDateFormatter;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;

public class StatusPrinter2 {
    private PrintStream ps = System.out;
    static CachingDateFormatter cachingDateFormat = new CachingDateFormatter("HH:mm:ss,SSS");

    /*
     * WARNING - void declaration
     */
    public void setPrintStream(PrintStream printStream) {
        void var1_1;
        this.ps = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void printInCaseOfErrorsOrWarnings(Context context) {
        void var1_1;
        this.printInCaseOfErrorsOrWarnings((Context)var1_1, 0L);
    }

    /*
     * WARNING - void declaration
     */
    public void printInCaseOfErrorsOrWarnings(Context context, long threshold) {
        StatusUtil statusUtil;
        if (context == null) {
            throw new IllegalArgumentException("Context argument cannot be null");
        }
        StatusManager sm = context.getStatusManager();
        if (sm == null) {
            this.ps.println("WARN: Context named \"" + context.getName() + "\" has no status manager");
            return;
        }
        if ((statusUtil = new StatusUtil((Context)((Object)statusUtil))).getHighestLevel(threshold) > 0) {
            void var2_2;
            this.print(sm, (long)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void printIfErrorsOccured(Context context) {
        StatusUtil statusUtil;
        if (context == null) {
            throw new IllegalArgumentException("Context argument cannot be null");
        }
        StatusManager sm = context.getStatusManager();
        if (sm == null) {
            this.ps.println("WARN: Context named \"" + context.getName() + "\" has no status manager");
            return;
        }
        if ((statusUtil = new StatusUtil((Context)((Object)statusUtil))).getHighestLevel(0L) == 2) {
            void var2_2;
            this.print((StatusManager)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void print(Context context) {
        void var1_1;
        this.print((Context)var1_1, 0L);
    }

    /*
     * WARNING - void declaration
     */
    public void print(Context context, long threshold) {
        void var2_2;
        if (context == null) {
            throw new IllegalArgumentException("Context argument cannot be null");
        }
        StatusManager sm = context.getStatusManager();
        if (sm == null) {
            void var1_1;
            this.ps.println("WARN: Context named \"" + var1_1.getName() + "\" has no status manager");
            return;
        }
        this.print(sm, (long)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void print(StatusManager sm) {
        void var1_1;
        this.print((StatusManager)var1_1, 0L);
    }

    /*
     * WARNING - void declaration
     */
    public void print(StatusManager sm, long threshold) {
        void var1_1;
        void var2_2;
        StringBuilder sb = new StringBuilder();
        List<Status> filteredList = StatusUtil.filterStatusListByTimeThreshold(sm.getCopyOfStatusList(), (long)var2_2);
        this.buildStrFromStatusList(sb, (List<Status>)var1_1);
        this.ps.println(sb.toString());
    }

    /*
     * WARNING - void declaration
     */
    public void print(List<Status> statusList) {
        void var2_2;
        void var1_1;
        StringBuilder sb = new StringBuilder();
        this.buildStrFromStatusList(sb, (List<Status>)var1_1);
        this.ps.println(var2_2.toString());
    }

    /*
     * WARNING - void declaration
     */
    private void buildStrFromStatusList(StringBuilder sb, List<Status> statusList) {
        Iterator iterator;
        if (statusList == null) {
            return;
        }
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_3;
            Status s = (Status)iterator.next();
            this.buildStr(sb, "", (Status)var3_3);
        }
    }

    private void appendThrowable(StringBuilder sb, Throwable t) {
        String[] stringArray = ThrowableToStringArray.convert(t);
        String[] stringArray2 = stringArray;
        stringArray2 = stringArray;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String s = stringArray2[i];
            if (!s.startsWith("Caused by: ")) {
                if (Character.isDigit(s.charAt(0))) {
                    sb.append("\t... ");
                } else {
                    sb.append("\tat ");
                }
            }
            sb.append(s).append(CoreConstants.LINE_SEPARATOR);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void buildStr(StringBuilder sb, String indentation, Status s) {
        String prefix = s.hasChildren() ? indentation + "+ " : indentation + "|-";
        if (cachingDateFormat != null) {
            String dateStr = cachingDateFormat.format(s.getTimestamp());
            sb.append(dateStr).append(" ");
        }
        sb.append(prefix).append(s).append(CoreConstants.LINE_SEPARATOR);
        if (s.getThrowable() != null) {
            this.appendThrowable(sb, s.getThrowable());
        }
        if (s.hasChildren()) {
            Iterator<Status> ite = s.iterator();
            while (ite.hasNext()) {
                void var3_3;
                Status child = ite.next();
                this.buildStr(sb, indentation + "  ", (Status)var3_3);
            }
        }
    }
}

