/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.util.OptionHelper;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

public class Loader {
    static final String TSTR = "Caught Exception while in Loader.getResource. This may be innocuous.";
    private static boolean ignoreTCL = false;
    public static final String IGNORE_TCL_PROPERTY_NAME = "logback.ignoreTCL";
    private static boolean HAS_GET_CLASS_LOADER_PERMISSION = false;

    public static ClassLoader systemClassloaderIfNull(ClassLoader cl) {
        ClassLoader classLoader;
        if (cl == null) {
            return ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }

    /*
     * WARNING - void declaration
     */
    public static Set<URL> getResources(String resource, ClassLoader classLoader) throws IOException {
        void var2_2;
        HashSet<void> urlSet = new HashSet<void>();
        Enumeration<URL> urlEnum = classLoader.getResources(resource);
        while (urlEnum.hasMoreElements()) {
            void var1_1;
            URL url = (URL)urlEnum.nextElement();
            urlSet.add(var1_1);
        }
        return var2_2;
    }

    public static URL getResource(String resource, ClassLoader classLoader) {
        try {
            String string;
            return classLoader.getResource(string);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static URL getResourceBySelfClassLoader(String resource) {
        return Loader.getResource(resource, Loader.getClassLoaderOfClass(Loader.class));
    }

    public static ClassLoader getTCL() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static Class<?> loadClass(String clazz, Context context) throws ClassNotFoundException {
        String string;
        ClassLoader classLoader = Loader.getClassLoaderOfObject(context);
        return classLoader.loadClass(string);
    }

    public static ClassLoader getClassLoaderOfObject(Object o) {
        Object object;
        if (o == null) {
            throw new NullPointerException("Argument cannot be null");
        }
        return Loader.getClassLoaderOfClass(object.getClass());
    }

    public static ClassLoader getClassLoaderAsPrivileged(Class<?> clazz) {
        Class<?> clazz2;
        if (!HAS_GET_CLASS_LOADER_PERMISSION) {
            return null;
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return clazz2.getClassLoader();
            }
        });
    }

    public static ClassLoader getClassLoaderOfClass(Class<?> clazz) {
        ClassLoader classLoader = clazz.getClassLoader();
        return Loader.systemClassloaderIfNull(classLoader);
    }

    public static Class<?> loadClass(String clazz) throws ClassNotFoundException {
        if (ignoreTCL) {
            return Class.forName(clazz);
        }
        try {
            return Loader.getTCL().loadClass(clazz);
        }
        catch (Throwable throwable) {
            String string;
            return Class.forName(string);
        }
    }

    /*
     * WARNING - void declaration
     */
    static {
        String ignoreTCLProp = OptionHelper.getSystemProperty(IGNORE_TCL_PROPERTY_NAME, null);
        if (ignoreTCLProp != null) {
            void var0;
            ignoreTCL = OptionHelper.toBoolean((String)var0, true);
        }
        HAS_GET_CLASS_LOADER_PERMISSION = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                try {
                    AccessController.checkPermission(new RuntimePermission("getClassLoader"));
                    return Boolean.TRUE;
                }
                catch (SecurityException securityException) {
                    return Boolean.FALSE;
                }
            }
        });
    }
}

