/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ExecutorServiceUtil {
    private static final ThreadFactory THREAD_FACTORY_FOR_SCHEDULED_EXECUTION_SERVICE = new ThreadFactory(){
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final ThreadFactory defaultFactory = this.makeThreadFactory();

        private ThreadFactory makeThreadFactory() {
            return Executors.defaultThreadFactory();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Thread newThread(Runnable r) {
            void var1_1;
            Thread thread = this.defaultFactory.newThread(r);
            if (!thread.isDaemon()) {
                thread.setDaemon(true);
            }
            thread.setName("logback-" + this.threadNumber.getAndIncrement());
            return var1_1;
        }
    };

    public static ScheduledExecutorService newScheduledExecutorService() {
        return new ScheduledThreadPoolExecutor(4, THREAD_FACTORY_FOR_SCHEDULED_EXECUTION_SERVICE);
    }

    public static ExecutorService newExecutorService() {
        return ExecutorServiceUtil.newThreadPoolExecutor();
    }

    public static ThreadPoolExecutor newThreadPoolExecutor() {
        return new ThreadPoolExecutor(0, 32, 0L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), THREAD_FACTORY_FOR_SCHEDULED_EXECUTION_SERVICE);
    }

    public static void shutdown(ExecutorService executorService) {
        if (executorService != null) {
            ExecutorService executorService2;
            executorService2.shutdownNow();
        }
    }

    public static ExecutorService newAlternateThreadPoolExecutor() {
        return ExecutorServiceUtil.newThreadPoolExecutor();
    }
}

