/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

public class COWArrayList<E>
implements List<E> {
    AtomicBoolean fresh = new AtomicBoolean(false);
    CopyOnWriteArrayList<E> underlyingList = new CopyOnWriteArrayList();
    E[] ourCopy;
    final E[] modelArray;

    /*
     * WARNING - void declaration
     */
    public COWArrayList(E[] modelArray) {
        void var1_1;
        this.modelArray = var1_1;
    }

    @Override
    public int size() {
        return this.underlyingList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.underlyingList.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean contains(Object o) {
        void var1_1;
        return this.underlyingList.contains(var1_1);
    }

    @Override
    public Iterator<E> iterator() {
        return this.underlyingList.iterator();
    }

    private void refreshCopyIfNecessary() {
        if (!this.isFresh()) {
            this.refreshCopy();
        }
    }

    private boolean isFresh() {
        return this.fresh.get();
    }

    private void refreshCopy() {
        this.ourCopy = this.underlyingList.toArray(this.modelArray);
        this.fresh.set(true);
    }

    @Override
    public Object[] toArray() {
        this.refreshCopyIfNecessary();
        return this.ourCopy;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        this.refreshCopyIfNecessary();
        return this.ourCopy;
    }

    public E[] asTypedArray() {
        this.refreshCopyIfNecessary();
        return this.ourCopy;
    }

    private void markAsStale() {
        this.fresh.set(false);
    }

    /*
     * WARNING - void declaration
     */
    public void addIfAbsent(E e) {
        void var1_1;
        this.underlyingList.addIfAbsent(var1_1);
        this.markAsStale();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean add(E e) {
        void var1_2;
        boolean result = this.underlyingList.add(e);
        this.markAsStale();
        return (boolean)var1_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean remove(Object o) {
        void var1_2;
        boolean result = this.underlyingList.remove(o);
        this.markAsStale();
        return (boolean)var1_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsAll(Collection<?> c) {
        void var1_1;
        return this.underlyingList.containsAll((Collection<?>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean addAll(Collection<? extends E> c) {
        void var1_1;
        this.markAsStale();
        boolean bl = this.underlyingList.addAll((Collection<E>)var1_1);
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean addAll(int index, Collection<? extends E> col) {
        void var2_2;
        boolean bl;
        this.markAsStale();
        bl = this.underlyingList.addAll(bl ? 1 : 0, (Collection<E>)var2_2);
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean removeAll(Collection<?> col) {
        void var1_1;
        this.markAsStale();
        boolean bl = this.underlyingList.removeAll((Collection<?>)var1_1);
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean retainAll(Collection<?> col) {
        void var1_1;
        this.markAsStale();
        boolean bl = this.underlyingList.retainAll((Collection<?>)var1_1);
        return bl;
    }

    @Override
    public void clear() {
        this.markAsStale();
        this.underlyingList.clear();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public E get(int index) {
        void var1_1;
        this.refreshCopyIfNecessary();
        return this.ourCopy[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public E set(int index, E element) {
        void var2_3;
        void var1_1;
        this.markAsStale();
        void var1_2 = this.underlyingList.set((int)var1_1, var2_3);
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void add(int index, E element) {
        void var2_2;
        void var1_1;
        this.markAsStale();
        this.underlyingList.add((int)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public E remove(int index) {
        void var1_1;
        this.markAsStale();
        E e = this.underlyingList.remove((int)var1_1);
        return e;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int indexOf(Object o) {
        void var1_1;
        return this.underlyingList.indexOf(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int lastIndexOf(Object o) {
        void var1_1;
        return this.underlyingList.lastIndexOf(var1_1);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.underlyingList.listIterator();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ListIterator<E> listIterator(int index) {
        void var1_1;
        return this.underlyingList.listIterator((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        void var2_2;
        void var1_1;
        return this.underlyingList.subList((int)var1_1, (int)var2_2);
    }
}

