/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.subst;

import ch.qos.logback.core.spi.PropertyContainer;
import ch.qos.logback.core.spi.ScanException;
import ch.qos.logback.core.subst.Node;
import ch.qos.logback.core.subst.Parser;
import ch.qos.logback.core.subst.Token;
import ch.qos.logback.core.subst.Tokenizer;
import ch.qos.logback.core.util.OptionHelper;
import java.util.List;
import java.util.Stack;

public class NodeToStringTransformer {
    public static final String CIRCULAR_VARIABLE_REFERENCE_DETECTED = "Circular variable reference detected while parsing input [";
    final Node node;
    final PropertyContainer propertyContainer0;
    final PropertyContainer propertyContainer1;

    /*
     * WARNING - void declaration
     */
    public NodeToStringTransformer(Node node, PropertyContainer propertyContainer0, PropertyContainer propertyContainer1) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.node = var1_1;
        this.propertyContainer0 = var2_2;
        this.propertyContainer1 = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public NodeToStringTransformer(Node node, PropertyContainer propertyContainer0) {
        this((Node)var1_1, (PropertyContainer)var2_2, null);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static String substituteVariable(String input, PropertyContainer pc0, PropertyContainer pc1) throws ScanException {
        void var2_2;
        void var1_1;
        Node node;
        Node node2 = NodeToStringTransformer.tokenizeAndParseString(input);
        node = new NodeToStringTransformer(node, (PropertyContainer)var1_1, (PropertyContainer)var2_2);
        return ((NodeToStringTransformer)((Object)node)).transform();
    }

    private static Node tokenizeAndParseString(String value) throws ScanException {
        List<Token> list;
        value = new Tokenizer((String)value);
        List<Token> tokens = ((Tokenizer)value).tokenize();
        list = new Parser(list);
        return ((Parser)((Object)list)).parse();
    }

    /*
     * WARNING - void declaration
     */
    public String transform() throws ScanException {
        void var1_1;
        StringBuilder stringBuilder = new StringBuilder();
        NodeToStringTransformer nodeToStringTransformer = this;
        nodeToStringTransformer.compileNode(nodeToStringTransformer.node, stringBuilder, new Stack<Node>());
        return var1_1.toString();
    }

    private void compileNode(Node inputNode, StringBuilder stringBuilder, Stack<Node> cycleCheckStack) throws ScanException {
        Node n = inputNode;
        while (n != null) {
            switch (n.type) {
                case LITERAL: {
                    this.handleLiteral(n, stringBuilder);
                    break;
                }
                case VARIABLE: {
                    this.handleVariable(n, stringBuilder, cycleCheckStack);
                }
            }
            n = n.next;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void handleVariable(Node n, StringBuilder stringBuilder, Stack<Node> cycleCheckStack) throws ScanException {
        void var1_1;
        void var2_2;
        void var3_3;
        Node innerNode;
        if (this.haveVisitedNodeAlready(n, cycleCheckStack)) {
            cycleCheckStack.push(n);
            String error = this.constructRecursionErrorMessage(cycleCheckStack);
            throw new IllegalArgumentException(error);
        }
        cycleCheckStack.push(n);
        StringBuilder keyBuffer = new StringBuilder();
        Node payload = (Node)n.payload;
        this.compileNode(payload, keyBuffer, cycleCheckStack);
        String key = keyBuffer.toString();
        String value = this.lookupKey(key);
        if (value != null) {
            innerNode = NodeToStringTransformer.tokenizeAndParseString(value);
            this.compileNode(innerNode, stringBuilder, cycleCheckStack);
            cycleCheckStack.pop();
            return;
        }
        if (innerNode.defaultPart == null) {
            stringBuilder.append(key + "_IS_UNDEFINED");
            cycleCheckStack.pop();
            return;
        }
        Node defaultPart = (Node)innerNode.defaultPart;
        StringBuilder defaultPartBuffer = new StringBuilder();
        this.compileNode(defaultPart, defaultPartBuffer, cycleCheckStack);
        var3_3.pop();
        String defaultVal = defaultPartBuffer.toString();
        var2_2.append((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private String lookupKey(String key) {
        void var1_1;
        String value = this.propertyContainer0.getProperty(key);
        if (value != null) {
            return value;
        }
        if (this.propertyContainer1 != null && (value = this.propertyContainer1.getProperty(key)) != null) {
            return value;
        }
        value = OptionHelper.getSystemProperty(key, null);
        if (value != null) {
            return value;
        }
        value = OptionHelper.getEnv((String)var1_1);
        if (value != null) {
            void var2_2;
            return var2_2;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void handleLiteral(Node n, StringBuilder stringBuilder) {
        void var1_1;
        stringBuilder.append((String)var1_1.payload);
    }

    /*
     * WARNING - void declaration
     */
    private String variableNodeValue(Node variableNode) {
        Node payload = (Node)variableNode.payload;
        if (payload == null) {
            return "";
        }
        if (payload.type == Node.Type.LITERAL) {
            return (String)payload.payload;
        }
        if (payload.type == Node.Type.VARIABLE) {
            void var1_1;
            return " ? " + this.variableNodeValue((Node)var1_1);
        }
        throw new IllegalStateException("unreachable code");
    }

    /*
     * WARNING - void declaration
     */
    private String constructRecursionErrorMessage(Stack<Node> recursionNodes) {
        void var2_2;
        StringBuilder errorBuilder = new StringBuilder(CIRCULAR_VARIABLE_REFERENCE_DETECTED);
        for (Node stackNode : recursionNodes) {
            errorBuilder.append("${").append(this.variableNodeValue(stackNode)).append("}");
            if (recursionNodes.lastElement() == stackNode) continue;
            errorBuilder.append(" --> ");
        }
        errorBuilder.append("]");
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    private boolean haveVisitedNodeAlready(Node node, Stack<Node> cycleDetectionStack) {
        for (Node cycleNode : cycleDetectionStack) {
            void var3_3;
            if (!this.equalNodes(node, (Node)var3_3)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean equalNodes(Node node1, Node node2) {
        void var2_2;
        void var1_1;
        if (node1.type != null && !node1.type.equals((Object)node2.type)) {
            return false;
        }
        if (node1.payload != null && !node1.payload.equals(node2.payload)) {
            return false;
        }
        return node1.defaultPart == null || var1_1.defaultPart.equals(var2_2.defaultPart);
    }
}

