/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.sift;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.model.AppenderModel;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.SiftModel;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelHandlerException;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.sift.AppenderFactoryUsingSiftModel;
import ch.qos.logback.core.sift.SiftingAppenderBase;
import java.util.stream.Stream;

public class SiftModelHandler
extends ModelHandlerBase {
    static final String ONE_AND_ONLY_ONE_URL = "http://logback.qos.ch/codes.html#1andOnly1";

    /*
     * WARNING - void declaration
     */
    public SiftModelHandler(Context context) {
        super((Context)var1_1);
        void var1_1;
    }

    public static SiftModelHandler makeInstance(Context context, ModelInterpretationContext ic) {
        Context context2;
        return new SiftModelHandler(context2);
    }

    protected Class<SiftModel> getSupportedModelClass() {
        return SiftModel.class;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void handle(ModelInterpretationContext mic, Model model) throws ModelHandlerException {
        void var3_7;
        SiftModel siftModel = (SiftModel)model;
        siftModel.markAsSkipped();
        long appenderModelCount = this.computeAppenderModelCount(siftModel);
        if (appenderModelCount == 0L) {
            String errMsg = "No nested appenders found within the <sift> element in SiftingAppender.";
            this.addError(errMsg);
            return;
        }
        if (appenderModelCount > 1L) {
            String errMsg = "Only and only one appender can be nested the <sift> element in SiftingAppender. See also http://logback.qos.ch/codes.html#1andOnly1";
            this.addError(errMsg);
            return;
        }
        Object o = mic.peekObject();
        if (o instanceof SiftingAppenderBase) {
            void var1_1;
            void var2_2;
            SiftingAppenderBase sa = (SiftingAppenderBase)o;
            String key = sa.getDiscriminatorKey();
            AppenderFactoryUsingSiftModel afusm = new AppenderFactoryUsingSiftModel(mic, (Model)var2_2, key);
            var3_7.setAppenderFactory(var1_1);
            return;
        }
        this.addError("Unexpected object " + String.valueOf(var3_7));
    }

    private long computeAppenderModelCount(SiftModel siftModel) {
        Stream stream = siftModel.getSubModels().stream();
        long l = stream.filter(m -> m instanceof AppenderModel).count();
        return l;
    }
}

