/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.pattern.ConverterUtil;
import ch.qos.logback.core.pattern.LiteralConverter;
import ch.qos.logback.core.pattern.parser.Node;
import ch.qos.logback.core.pattern.parser.Parser;
import ch.qos.logback.core.pattern.util.AlmostAsIsEscapeUtil;
import ch.qos.logback.core.rolling.helper.DateTokenConverter;
import ch.qos.logback.core.rolling.helper.FileFilterUtil;
import ch.qos.logback.core.rolling.helper.IntegerTokenConverter;
import ch.qos.logback.core.rolling.helper.MonoTypedConverter;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.ScanException;
import java.time.Instant;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class FileNamePattern
extends ContextAwareBase {
    static final Map<String, String> CONVERTER_MAP = new HashMap<String, String>();
    String pattern;
    Converter<Object> headTokenConverter;

    /*
     * WARNING - void declaration
     */
    public FileNamePattern(String patternArg, Context contextArg) {
        void var2_2;
        void var1_1;
        this.setPattern(FileFilterUtil.slashify((String)var1_1));
        this.setContext((Context)var2_2);
        this.parse();
        ConverterUtil.startConverters(this.headTokenConverter);
    }

    /*
     * WARNING - void declaration
     */
    void parse() {
        try {
            void var2_3;
            FileNamePattern fileNamePattern = this;
            String patternForParsing = fileNamePattern.escapeRightParantesis(fileNamePattern.pattern);
            Parser p = new Parser(patternForParsing, new AlmostAsIsEscapeUtil());
            p.setContext(this.context);
            Node t = p.parse();
            this.headTokenConverter = p.compile((Node)var2_3, CONVERTER_MAP);
            return;
        }
        catch (ScanException sce) {
            void var1_2;
            FileNamePattern fileNamePattern = this;
            fileNamePattern.addError("Failed to parse pattern \"" + fileNamePattern.pattern + "\".", (Throwable)var1_2);
            return;
        }
    }

    String escapeRightParantesis(String in) {
        return this.pattern.replace(")", "\\)");
    }

    public String toString() {
        return this.pattern;
    }

    public int hashCode() {
        int n = 31 + (this.pattern == null ? 0 : this.pattern.hashCode());
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object obj) {
        void var1_1;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileNamePattern other = (FileNamePattern)obj;
        return !(this.pattern == null ? other.pattern != null : !this.pattern.equals(var1_1.pattern));
    }

    /*
     * WARNING - void declaration
     */
    public DateTokenConverter<Object> getPrimaryDateTokenConverter() {
        for (Converter<Object> p = this.headTokenConverter; p != null; p = p.getNext()) {
            void var2_2;
            DateTokenConverter dtc;
            if (!(p instanceof DateTokenConverter) || !(dtc = (DateTokenConverter)p).isPrimary()) continue;
            return var2_2;
        }
        return null;
    }

    public IntegerTokenConverter getIntegerTokenConverter() {
        for (Converter<Object> p = this.headTokenConverter; p != null; p = p.getNext()) {
            if (!(p instanceof IntegerTokenConverter)) continue;
            return (IntegerTokenConverter)p;
        }
        return null;
    }

    public boolean hasIntegerTokenCOnverter() {
        IntegerTokenConverter integerTokenConverter = this.getIntegerTokenConverter();
        return integerTokenConverter != null;
    }

    /*
     * WARNING - void declaration
     */
    public String convertMultipleArguments(Object ... objectList) {
        void var2_2;
        StringBuilder buf = new StringBuilder();
        for (Converter<Object> c = this.headTokenConverter; c != null; c = c.getNext()) {
            if (c instanceof MonoTypedConverter) {
                MonoTypedConverter monoTyped = (MonoTypedConverter)((Object)c);
                Object[] objectArray = objectList;
                int n = objectList.length;
                for (int i = 0; i < n; ++i) {
                    Object o = objectArray[i];
                    if (!monoTyped.isApplicable(o)) continue;
                    buf.append(c.convert(o));
                }
                continue;
            }
            buf.append(c.convert(objectList));
        }
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    public String convert(Object o) {
        void var2_2;
        StringBuilder buf = new StringBuilder();
        for (Converter<Object> p = this.headTokenConverter; p != null; p = p.getNext()) {
            buf.append(p.convert(o));
        }
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    public String convertInt(int i) {
        void var1_1;
        return this.convert((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setPattern(String pattern) {
        if (pattern != null) {
            void var1_1;
            this.pattern = var1_1.trim();
        }
    }

    public String getPattern() {
        return this.pattern;
    }

    /*
     * WARNING - void declaration
     */
    public String toRegexForFixedDate(Date date) {
        void var2_2;
        StringBuilder buf = new StringBuilder();
        for (Converter<Object> p = this.headTokenConverter; p != null; p = p.getNext()) {
            if (p instanceof LiteralConverter) {
                buf.append(p.convert(null));
                continue;
            }
            if (p instanceof IntegerTokenConverter) {
                buf.append("(\\d+)");
                continue;
            }
            if (!(p instanceof DateTokenConverter)) continue;
            buf.append(p.convert(date));
        }
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    public String toRegexForFixedDate(Instant instant) {
        void var2_2;
        StringBuilder buf = new StringBuilder();
        for (Converter<Object> p = this.headTokenConverter; p != null; p = p.getNext()) {
            if (p instanceof LiteralConverter) {
                buf.append(p.convert(null));
                continue;
            }
            if (p instanceof IntegerTokenConverter) {
                buf.append("(\\d+)");
                continue;
            }
            if (!(p instanceof DateTokenConverter)) continue;
            buf.append(p.convert(instant));
        }
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    public String toRegex() {
        void var1_1;
        StringBuilder buf = new StringBuilder();
        for (Converter<Object> p = this.headTokenConverter; p != null; p = p.getNext()) {
            void var3_3;
            if (p instanceof LiteralConverter) {
                buf.append(p.convert(null));
                continue;
            }
            if (p instanceof IntegerTokenConverter) {
                buf.append("\\d+");
                continue;
            }
            if (!(p instanceof DateTokenConverter)) continue;
            DateTokenConverter dtc = (DateTokenConverter)p;
            buf.append(var3_3.toRegex());
        }
        return var1_1.toString();
    }

    static {
        CONVERTER_MAP.put("i", IntegerTokenConverter.class.getName());
        CONVERTER_MAP.put("d", DateTokenConverter.class.getName());
    }
}

