/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.rolling.RolloverFailure;
import ch.qos.logback.core.rolling.helper.CompressionMode;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.WarnStatus;
import ch.qos.logback.core.util.FileUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class Compressor
extends ContextAwareBase {
    final CompressionMode compressionMode;
    static final int BUFFER_SIZE = 8192;

    /*
     * WARNING - void declaration
     */
    public Compressor(CompressionMode compressionMode) {
        void var1_1;
        this.compressionMode = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void compress(String nameOfFile2Compress, String nameOfCompressedFile, String innerEntryName) {
        switch (this.compressionMode) {
            case GZ: {
                this.gzCompress(nameOfFile2Compress, nameOfCompressedFile);
                return;
            }
            case ZIP: {
                void var3_3;
                void var2_2;
                void var1_1;
                this.zipCompress((String)var1_1, (String)var2_2, (String)var3_3);
                return;
            }
            case NONE: {
                throw new UnsupportedOperationException("compress method called in NONE compression mode");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void zipCompress(String nameOfFile2zip, String nameOfZippedFile, String innerEntryName) {
        File zippedFile;
        File file2zip = new File(nameOfFile2zip);
        if (!file2zip.exists()) {
            this.addStatus(new WarnStatus("The file to compress named [" + nameOfFile2zip + "] does not exist.", this));
            return;
        }
        if (innerEntryName == null) {
            this.addStatus(new WarnStatus("The innerEntryName parameter cannot be null", this));
            return;
        }
        if (!((String)nameOfZippedFile).endsWith(".zip")) {
            nameOfZippedFile = (String)nameOfZippedFile + ".zip";
        }
        if ((zippedFile = new File((String)nameOfZippedFile)).exists()) {
            this.addStatus(new WarnStatus("The target compressed file named [" + (String)nameOfZippedFile + "] exist already.", this));
            return;
        }
        this.addInfo("ZIP compressing [" + String.valueOf(file2zip) + "] as [" + String.valueOf(zippedFile) + "]");
        this.createMissingTargetDirsIfNecessary(zippedFile);
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(nameOfFile2zip));
             ZipOutputStream zos = new ZipOutputStream(new FileOutputStream((String)nameOfZippedFile));){
            int n;
            ZipEntry zipEntry = this.computeZipEntry(innerEntryName);
            zos.putNextEntry(zipEntry);
            byte[] inbuf = new byte[8192];
            while ((n = bis.read(inbuf)) != -1) {
                void var3_4;
                zos.write(inbuf, 0, (int)var3_4);
            }
            this.addInfo("Done ZIP compressing [" + String.valueOf(file2zip) + "] as [" + String.valueOf(zippedFile) + "]");
        }
        catch (Exception e) {
            void var2_2;
            this.addStatus(new ErrorStatus("Error occurred while compressing [" + nameOfFile2zip + "] into [" + (String)var2_2 + "].", this, e));
        }
        if (!file2zip.delete()) {
            void var1_1;
            this.addStatus(new WarnStatus("Could not delete [" + (String)var1_1 + "].", this));
        }
    }

    /*
     * WARNING - void declaration
     */
    ZipEntry computeZipEntry(File zippedFile) {
        void var1_1;
        return this.computeZipEntry(var1_1.getName());
    }

    /*
     * WARNING - void declaration
     */
    ZipEntry computeZipEntry(String filename) {
        void var1_1;
        String nameOfFileNestedWithinArchive = Compressor.computeFileNameStrWithoutCompSuffix(filename, this.compressionMode);
        return new ZipEntry((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void gzCompress(String nameOfFile2gz, String nameOfgzedFile) {
        void var3_3;
        File gzedFile;
        File file2gz = new File(nameOfFile2gz);
        if (!file2gz.exists()) {
            this.addStatus(new WarnStatus("The file to compress named [" + nameOfFile2gz + "] does not exist.", this));
            return;
        }
        if (!((String)nameOfgzedFile).endsWith(".gz")) {
            nameOfgzedFile = (String)nameOfgzedFile + ".gz";
        }
        if ((gzedFile = new File((String)nameOfgzedFile)).exists()) {
            this.addWarn("The target compressed file named [" + (String)nameOfgzedFile + "] exist already. Aborting file compression.");
            return;
        }
        this.addInfo("GZ compressing [" + String.valueOf(file2gz) + "] as [" + String.valueOf(gzedFile) + "]");
        this.createMissingTargetDirsIfNecessary(gzedFile);
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(nameOfFile2gz));
             GZIPOutputStream gzos = new GZIPOutputStream(new FileOutputStream((String)nameOfgzedFile));){
            int n;
            byte[] inbuf = new byte[8192];
            while ((n = bis.read(inbuf)) != -1) {
                gzos.write(inbuf, 0, n);
            }
            this.addInfo("Done GZ compressing [" + String.valueOf(file2gz) + "] as [" + String.valueOf(gzedFile) + "]");
        }
        catch (Exception e) {
            void var2_2;
            this.addStatus(new ErrorStatus("Error occurred while compressing [" + nameOfFile2gz + "] into [" + (String)var2_2 + "].", this, e));
        }
        if (!var3_3.delete()) {
            void var1_1;
            this.addStatus(new WarnStatus("Could not delete [" + (String)var1_1 + "].", this));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String computeFileNameStrWithoutCompSuffix(String fileNamePatternStr, CompressionMode compressionMode) {
        void var1_1;
        int len = fileNamePatternStr.length();
        switch (1.$SwitchMap$ch$qos$logback$core$rolling$helper$CompressionMode[var1_1.ordinal()]) {
            case 1: {
                if (fileNamePatternStr.endsWith(".gz")) {
                    return fileNamePatternStr.substring(0, len - 3);
                }
                return fileNamePatternStr;
            }
            case 2: {
                if (fileNamePatternStr.endsWith(".zip")) {
                    void var2_2;
                    return fileNamePatternStr.substring(0, (int)(var2_2 - 4));
                }
                return fileNamePatternStr;
            }
            case 3: {
                String string;
                return string;
            }
        }
        throw new IllegalStateException("Execution should not reach this point");
    }

    /*
     * WARNING - void declaration
     */
    void createMissingTargetDirsIfNecessary(File file) {
        boolean bl = FileUtil.createMissingParentDirectories(file);
        if (!bl) {
            void var1_1;
            this.addError("Failed to create parent directories for [" + var1_1.getAbsolutePath() + "]");
        }
    }

    public String toString() {
        return this.getClass().getName();
    }

    /*
     * WARNING - void declaration
     */
    public Future<?> asyncCompress(String nameOfFile2Compress, String nameOfCompressedFile, String innerEntryName) throws RolloverFailure {
        Future<?> future;
        void var3_3;
        ExecutorService executorService;
        CompressionRunnable runnable = new CompressionRunnable(this, nameOfFile2Compress, (String)((Object)executorService), (String)var3_3);
        executorService = this.context.getExecutorService();
        future = executorService.submit((Runnable)((Object)future));
        return future;
    }

    class CompressionRunnable
    implements Runnable {
        final String nameOfFile2Compress;
        final String nameOfCompressedFile;
        final String innerEntryName;
        final /* synthetic */ Compressor this$0;

        /*
         * WARNING - void declaration
         */
        public CompressionRunnable(Compressor this$0, String nameOfFile2Compress, String nameOfCompressedFile, String innerEntryName) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.this$0 = var1_1;
            this.nameOfFile2Compress = var2_2;
            this.nameOfCompressedFile = var3_3;
            this.innerEntryName = innerEntryName;
        }

        @Override
        public void run() {
            this.this$0.compress(this.nameOfFile2Compress, this.nameOfCompressedFile, this.innerEntryName);
        }
    }
}

