/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.net.ssl;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;

public class SecureRandomFactoryBean {
    private String algorithm;
    private String provider;

    public SecureRandom createSecureRandom() throws NoSuchProviderException, NoSuchAlgorithmException {
        try {
            if (this.getProvider() != null) {
                return SecureRandom.getInstance(this.getAlgorithm(), this.getProvider());
            }
            return SecureRandom.getInstance(this.getAlgorithm());
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new NoSuchProviderException("no such secure random provider: " + this.getProvider());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new NoSuchAlgorithmException("no such secure random algorithm: " + this.getAlgorithm());
        }
    }

    public String getAlgorithm() {
        if (this.algorithm == null) {
            return "SHA1PRNG";
        }
        return this.algorithm;
    }

    /*
     * WARNING - void declaration
     */
    public void setAlgorithm(String algorithm) {
        void var1_1;
        this.algorithm = var1_1;
    }

    public String getProvider() {
        return this.provider;
    }

    /*
     * WARNING - void declaration
     */
    public void setProvider(String provider) {
        void var1_1;
        this.provider = var1_1;
    }
}

