/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.net.server;

import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.net.server.ClientVisitor;
import ch.qos.logback.core.net.server.RemoteReceiverClient;
import ch.qos.logback.core.net.server.RemoteReceiverServerListener;
import ch.qos.logback.core.net.server.RemoteReceiverServerRunner;
import ch.qos.logback.core.net.server.ServerListener;
import ch.qos.logback.core.net.server.ServerRunner;
import ch.qos.logback.core.spi.PreSerializationTransformer;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.concurrent.Executor;
import javax.net.ServerSocketFactory;

public abstract class AbstractServerSocketAppender<E>
extends AppenderBase<E> {
    public static final int DEFAULT_BACKLOG = 50;
    public static final int DEFAULT_CLIENT_QUEUE_SIZE = 100;
    private int port = 4560;
    private int backlog = 50;
    private int clientQueueSize = 100;
    private String address;
    private ServerRunner<RemoteReceiverClient> runner;

    /*
     * WARNING - void declaration
     */
    @Override
    public void start() {
        if (this.isStarted()) {
            return;
        }
        try {
            ServerSocket socket = this.getServerSocketFactory().createServerSocket(this.getPort(), this.getBacklog(), this.getInetAddress());
            ServerListener<RemoteReceiverClient> listener = this.createServerListener(socket);
            this.runner = this.createServerRunner(listener, this.getContext().getExecutorService());
            this.runner.setContext(this.getContext());
            this.getContext().getExecutorService().execute(this.runner);
            super.start();
            return;
        }
        catch (Exception ex) {
            void var1_2;
            this.addError("server startup error: " + String.valueOf(ex), (Throwable)var1_2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected ServerListener<RemoteReceiverClient> createServerListener(ServerSocket socket) {
        void var1_1;
        return new RemoteReceiverServerListener((ServerSocket)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected ServerRunner<RemoteReceiverClient> createServerRunner(ServerListener<RemoteReceiverClient> listener, Executor executor) {
        void var2_2;
        void var1_1;
        return new RemoteReceiverServerRunner((ServerListener<RemoteReceiverClient>)var1_1, (Executor)var2_2, this.getClientQueueSize());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void stop() {
        if (!this.isStarted()) {
            return;
        }
        try {
            this.runner.stop();
            super.stop();
            return;
        }
        catch (IOException ex) {
            void var1_1;
            this.addError("server shutdown error: " + String.valueOf(ex), (Throwable)var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void append(E event) {
        void var1_1;
        if (event == null) {
            return;
        }
        this.postProcessEvent(event);
        Serializable serEvent = this.getPST().transform(event);
        this.runner.accept(new ClientVisitor<RemoteReceiverClient>(){
            final /* synthetic */ Serializable val$serEvent;
            final /* synthetic */ AbstractServerSocketAppender this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$serEvent = serializable;
            }

            @Override
            public void visit(RemoteReceiverClient client) {
                client.offer(this.val$serEvent);
            }
        });
    }

    protected abstract void postProcessEvent(E var1);

    protected abstract PreSerializationTransformer<E> getPST();

    protected ServerSocketFactory getServerSocketFactory() throws Exception {
        return ServerSocketFactory.getDefault();
    }

    protected InetAddress getInetAddress() throws UnknownHostException {
        if (this.getAddress() == null) {
            return null;
        }
        return InetAddress.getByName(this.getAddress());
    }

    public int getPort() {
        return this.port;
    }

    /*
     * WARNING - void declaration
     */
    public void setPort(int port) {
        void var1_1;
        this.port = var1_1;
    }

    public int getBacklog() {
        return this.backlog;
    }

    /*
     * WARNING - void declaration
     */
    public void setBacklog(int backlog) {
        void var1_1;
        this.backlog = var1_1;
    }

    public String getAddress() {
        return this.address;
    }

    /*
     * WARNING - void declaration
     */
    public void setAddress(String address) {
        void var1_1;
        this.address = var1_1;
    }

    public int getClientQueueSize() {
        return this.clientQueueSize;
    }

    /*
     * WARNING - void declaration
     */
    public void setClientQueueSize(int clientQueueSize) {
        void var1_1;
        this.clientQueueSize = var1_1;
    }
}

