/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.model.util;

import ch.qos.logback.core.joran.action.ActionUtil;
import ch.qos.logback.core.model.PropertyModel;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.ContextAwarePropertyContainer;
import ch.qos.logback.core.util.ContextUtil;
import ch.qos.logback.core.util.Loader;
import ch.qos.logback.core.util.OptionHelper;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;

public class PropertyModelHandlerHelper
extends ContextAwareBase {
    public static final String HANDLE_PROPERTY_MODEL_METHOD_NAME = "handlePropertyModel";

    /*
     * WARNING - void declaration
     */
    public PropertyModelHandlerHelper(ContextAware declaredOrigin) {
        super((ContextAware)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void handlePropertyModel(ContextAwarePropertyContainer capcm, String nameStr, String valueStr, String fileStr, String resourceStr, String scopeStr) {
        void var1_1;
        void var3_3;
        void var2_2;
        PropertyModel propertyModel = new PropertyModel();
        propertyModel.setName((String)var2_2);
        propertyModel.setValue((String)var3_3);
        propertyModel.setFile(fileStr);
        propertyModel.setResource(resourceStr);
        propertyModel.setScopeStr(scopeStr);
        this.handlePropertyModel((ContextAwarePropertyContainer)var1_1, propertyModel);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handlePropertyModel(ContextAwarePropertyContainer capc, PropertyModel propertyModel) {
        void var2_4;
        void e12;
        ActionUtil.Scope scope = ActionUtil.stringToScope(propertyModel.getScopeStr());
        if (PropertyModelHandlerHelper.checkFileAttributeSanity(propertyModel)) {
            String file = propertyModel.getFile();
            file = capc.subst(file);
            try (FileInputStream istream = new FileInputStream(file);){
                PropertyModelHandlerHelper.loadAndSetProperties(capc, istream, scope);
                return;
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.addError("Could not find properties file [" + file + "].");
                return;
            }
            catch (IOException | IllegalArgumentException e12) {
                this.addError("Could not read properties file [" + file + "].", e12);
            }
            return;
        }
        if (PropertyModelHandlerHelper.checkResourceAttributeSanity((PropertyModel)e12)) {
            String resource = e12.getResource();
            URL resourceURL = Loader.getResourceBySelfClassLoader(resource = capc.subst(resource));
            if (resourceURL == null) {
                this.addError("Could not find resource [" + resource + "].");
                return;
            }
            try {
                InputStream istream = var2_4.openStream();
                try {
                    PropertyModelHandlerHelper.loadAndSetProperties(capc, istream, scope);
                    return;
                }
                finally {
                    if (istream == null) return;
                    istream.close();
                }
            }
            catch (IOException e) {
                this.addError("Could not read resource file [" + resource + "].", e);
            }
            return;
        }
        if (PropertyModelHandlerHelper.checkValueNameAttributesSanity((PropertyModel)var2_4)) {
            void var3_7;
            void var1_1;
            String resource = var2_4.getValue();
            String value = resource.trim();
            value = capc.subst(value);
            ActionUtil.setProperty((ContextAwarePropertyContainer)var1_1, var2_4.getName(), value, (ActionUtil.Scope)var3_7);
            return;
        }
        this.addError("In <property> element, either the \"file\" attribute alone, or the \"resource\" element alone, or both the \"name\" and \"value\" attributes must be set.");
    }

    /*
     * WARNING - void declaration
     */
    public static boolean checkFileAttributeSanity(PropertyModel propertyModel) {
        String string;
        void var3_3;
        void var2_2;
        void var1_1;
        String file = propertyModel.getFile();
        String name = propertyModel.getName();
        String value = propertyModel.getValue();
        String resource = propertyModel.getResource();
        return !OptionHelper.isNullOrEmptyOrAllSpaces((String)var1_1) && OptionHelper.isNullOrEmptyOrAllSpaces((String)var2_2) && OptionHelper.isNullOrEmptyOrAllSpaces((String)var3_3) && OptionHelper.isNullOrEmptyOrAllSpaces(string);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean checkResourceAttributeSanity(PropertyModel propertyModel) {
        void var1_1;
        void var3_3;
        void var2_2;
        Object object;
        String file = propertyModel.getFile();
        String name = propertyModel.getName();
        String value = propertyModel.getValue();
        return !OptionHelper.isNullOrEmptyOrAllSpaces((String)(object = ((PropertyModel)object).getResource())) && OptionHelper.isNullOrEmptyOrAllSpaces((String)var2_2) && OptionHelper.isNullOrEmptyOrAllSpaces((String)var3_3) && OptionHelper.isNullOrEmptyOrAllSpaces((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean checkValueNameAttributesSanity(PropertyModel propertyModel) {
        String string;
        void var1_1;
        void var3_3;
        void var2_2;
        String file = propertyModel.getFile();
        String name = propertyModel.getName();
        String value = propertyModel.getValue();
        String resource = propertyModel.getResource();
        return !OptionHelper.isNullOrEmptyOrAllSpaces((String)var2_2) && !OptionHelper.isNullOrEmptyOrAllSpaces((String)var3_3) && OptionHelper.isNullOrEmptyOrAllSpaces((String)var1_1) && OptionHelper.isNullOrEmptyOrAllSpaces(string);
    }

    /*
     * WARNING - void declaration
     */
    public static void setProperty(ContextAwarePropertyContainer capc, String key, String value, ActionUtil.Scope scope) {
        void var3_3;
        switch (1.$SwitchMap$ch$qos$logback$core$joran$action$ActionUtil$Scope[var3_3.ordinal()]) {
            case 1: {
                capc.addSubstitutionProperty(key, value);
                return;
            }
            case 2: {
                capc.getContext().putProperty(key, value);
                return;
            }
            case 3: {
                void var2_2;
                void var1_1;
                ContextAwarePropertyContainer contextAwarePropertyContainer;
                OptionHelper.setSystemProperty(contextAwarePropertyContainer, (String)var1_1, (String)var2_2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void setProperties(ContextAwarePropertyContainer capc, Properties props, ActionUtil.Scope scope) {
        void var2_2;
        switch (1.$SwitchMap$ch$qos$logback$core$joran$action$ActionUtil$Scope[var2_2.ordinal()]) {
            case 1: {
                capc.addSubstitutionProperties(props);
                return;
            }
            case 2: {
                capc = new ContextUtil(capc.getContext());
                ((ContextUtil)capc).addProperties(props);
                return;
            }
            case 3: {
                void var1_1;
                ContextAwarePropertyContainer contextAwarePropertyContainer;
                OptionHelper.setSystemProperties(contextAwarePropertyContainer, (Properties)var1_1);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void loadAndSetProperties(ContextAwarePropertyContainer capc, InputStream istream, ActionUtil.Scope scope) throws IOException {
        void var2_2;
        void var3_3;
        ContextAwarePropertyContainer contextAwarePropertyContainer;
        void var1_1;
        Properties props = new Properties();
        props.load((InputStream)var1_1);
        PropertyModelHandlerHelper.setProperties(contextAwarePropertyContainer, (Properties)var3_3, (ActionUtil.Scope)var2_2);
    }
}

