/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.model.processor;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.SerializeModelModel;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelHandlerException;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;

public class SerializeModelModelHandler
extends ModelHandlerBase {
    /*
     * WARNING - void declaration
     */
    public SerializeModelModelHandler(Context context) {
        super((Context)var1_1);
        void var1_1;
    }

    public static ModelHandlerBase makeInstance(Context context, ModelInterpretationContext mic) {
        Context context2;
        return new SerializeModelModelHandler(context2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void handle(ModelInterpretationContext modelInterpretationContext, Model model) throws ModelHandlerException {
        void var3_3;
        Object object;
        String string;
        Object configuratorHint = modelInterpretationContext.getConfiguratorHint();
        if (configuratorHint != null && configuratorHint.getClass().getName().equals("ch.qos.logback.classic.joran.SerializedModelConfigurator")) {
            this.addInfo("Skipping model serialization as calling configurator is already model based.");
            return;
        }
        if (!(model instanceof SerializeModelModel)) {
            this.addWarn("Model parameter is not of type SerializeModelModel. Skipping serialization of model structure");
            return;
        }
        SerializeModelModel serializeModelModel = (SerializeModelModel)model;
        Model topModel = modelInterpretationContext.getTopModel();
        if (topModel == null) {
            this.addWarn("Could not find top most model. Skipping serialization of model structure.");
            return;
        }
        String fileStr = serializeModelModel.getFile();
        if (fileStr == null) {
            DateTimeFormatter dft = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HHmm");
            Instant now = Instant.now();
            string = ((DateTimeFormatter)((Object)string)).format((TemporalAccessor)object);
            object = "logback-" + string + ".scmo";
            this.addInfo("For model serialization, using default file destination [" + (String)object + "]");
        } else {
            object = ((ModelInterpretationContext)((Object)string)).subst((String)object);
        }
        this.writeModel((String)object, (Model)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private void writeModel(String fileStr, Model firstModel) {
        this.addInfo("Serializing model to file [" + fileStr + "]");
        try {
            FileOutputStream fos = new FileOutputStream(fileStr);
            try {
                void var2_2;
                ObjectOutputStream oos = new ObjectOutputStream(fos);
                oos.writeObject(var2_2);
                oos.flush();
                oos.close();
            }
            catch (Throwable throwable) {
                try {
                    void var3_4;
                    var3_4.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            fos.close();
        }
        catch (IOException iOException) {
            void var1_1;
            this.addError("IO failure while serializing Model [" + (String)var1_1 + "]");
        }
    }
}

