/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.model.processor;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.model.ResourceModel;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.spi.ContextAwarePropertyContainer;
import ch.qos.logback.core.util.Loader;
import ch.qos.logback.core.util.OptionHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;

public abstract class ResourceHandlerBase
extends ModelHandlerBase {
    protected String attributeInUse;
    protected boolean optional;

    /*
     * WARNING - void declaration
     */
    protected ResourceHandlerBase(Context context) {
        super((Context)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected InputStream openURL(URL url) {
        try {
            return url.openStream();
        }
        catch (IOException iOException) {
            void var1_1;
            this.warnIfRequired("Failed to open [" + var1_1.toString() + "]");
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected boolean checkAttributes(ResourceModel resourceModel) {
        void var1_1;
        void var3_3;
        void var2_2;
        String fileAttribute = resourceModel.getFile();
        String urlAttribute = resourceModel.getUrl();
        String resourceAttribute = resourceModel.getResource();
        int count = 0;
        if (!OptionHelper.isNullOrEmptyOrAllSpaces((String)var2_2)) {
            ++count;
        }
        if (!OptionHelper.isNullOrEmptyOrAllSpaces((String)var3_3)) {
            ++count;
        }
        if (!OptionHelper.isNullOrEmptyOrAllSpaces((String)var1_1)) {
            ++count;
        }
        if (count == 0) {
            this.addError("One of \"path\", \"resource\" or \"url\" attributes must be set.");
            return false;
        }
        if (count > 1) {
            this.addError("Only one of \"file\", \"url\" or \"resource\" attributes should be set.");
            return false;
        }
        if (count == 1) {
            return true;
        }
        throw new IllegalStateException("Count value [" + count + "] is not expected");
    }

    protected String getAttribureInUse() {
        return this.attributeInUse;
    }

    /*
     * WARNING - void declaration
     */
    protected URL getInputURL(ContextAwarePropertyContainer contextAwarePropertyContainer, ResourceModel resourceModel) {
        String fileAttribute = resourceModel.getFile();
        String urlAttribute = resourceModel.getUrl();
        String resourceAttribute = resourceModel.getResource();
        if (!OptionHelper.isNullOrEmptyOrAllSpaces(fileAttribute)) {
            void var3_3;
            this.attributeInUse = contextAwarePropertyContainer.subst((String)var3_3);
            ResourceHandlerBase resourceHandlerBase = this;
            return resourceHandlerBase.filePathAsURL(resourceHandlerBase.attributeInUse);
        }
        if (!OptionHelper.isNullOrEmptyOrAllSpaces(urlAttribute)) {
            this.attributeInUse = contextAwarePropertyContainer.subst(urlAttribute);
            ResourceHandlerBase resourceHandlerBase = this;
            return resourceHandlerBase.attributeToURL(resourceHandlerBase.attributeInUse);
        }
        if (!OptionHelper.isNullOrEmptyOrAllSpaces(resourceAttribute)) {
            void var2_2;
            void var1_1;
            this.attributeInUse = var1_1.subst((String)var2_2);
            ResourceHandlerBase resourceHandlerBase = this;
            return resourceHandlerBase.resourceAsURL(resourceHandlerBase.attributeInUse);
        }
        throw new IllegalStateException("A URL stream should have been returned at this stage");
    }

    protected URL filePathAsURL(String path) {
        MalformedURLException malformedURLException;
        URI uri = new File(path).toURI();
        try {
            return ((URI)((Object)malformedURLException)).toURL();
        }
        catch (MalformedURLException malformedURLException2) {
            malformedURLException = malformedURLException2;
            malformedURLException2.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected URL attributeToURL(String urlAttribute) {
        try {
            return new URL(urlAttribute);
        }
        catch (MalformedURLException mue) {
            void var2_2;
            void var1_1;
            String errMsg = "URL [" + urlAttribute + "] is not well formed.";
            this.addError((String)var1_1, (Throwable)var2_2);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected URL resourceAsURL(String resourceAttribute) {
        void var2_2;
        URL url = Loader.getResourceBySelfClassLoader(resourceAttribute);
        if (url == null) {
            void var1_1;
            this.warnIfRequired("Could not find resource corresponding to [" + (String)var1_1 + "]");
            return null;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    protected void warnIfRequired(String msg) {
        if (!this.optional) {
            void var1_1;
            this.addWarn((String)var1_1);
        }
    }
}

