/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.model.processor;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.GenericXMLConfigurator;
import ch.qos.logback.core.joran.event.SaxEvent;
import ch.qos.logback.core.joran.event.SaxEventRecorder;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.joran.util.ConfigurationWatchListUtil;
import ch.qos.logback.core.model.IncludeModel;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.ResourceModel;
import ch.qos.logback.core.model.processor.ModelHandlerException;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.model.processor.ResourceHandlerBase;
import ch.qos.logback.core.spi.ContextAwarePropertyContainer;
import ch.qos.logback.core.util.OptionHelper;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.function.Supplier;

public class IncludeModelHandler
extends ResourceHandlerBase {
    boolean inError = false;

    /*
     * WARNING - void declaration
     */
    public IncludeModelHandler(Context context) {
        super((Context)var1_1);
        void var1_1;
    }

    public static IncludeModelHandler makeInstance(Context context, ModelInterpretationContext mic) {
        Context context2;
        return new IncludeModelHandler(context2);
    }

    protected Class<IncludeModel> getSupportedModelClass() {
        return IncludeModel.class;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void handle(ModelInterpretationContext mic, Model model) throws ModelHandlerException {
        void var1_1;
        void var2_2;
        IncludeModel includeModel = (IncludeModel)model;
        Model modelFromIncludedFile = this.buildModelFromIncludedFile(mic, includeModel);
        if (modelFromIncludedFile == null) {
            this.warnIfRequired("Failed to build include model from included file");
            return;
        }
        this.processModelFromIncludedFile((IncludeModel)var2_2, (Model)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Model buildModelFromIncludedFile(ContextAwarePropertyContainer capc, IncludeModel includeModel) throws ModelHandlerException {
        this.optional = OptionHelper.toBoolean(includeModel.getOptional(), false);
        if (!this.checkAttributes(includeModel)) {
            this.inError = true;
            return null;
        }
        InputStream in = this.getInputStream(capc, includeModel);
        if (in == null) {
            this.inError = true;
            return null;
        }
        try {
            void var2_2;
            Model model;
            SaxEventRecorder recorder = this.populateSaxEventRecorder(in);
            List<SaxEvent> list = recorder.getSaxEventList();
            if (list.isEmpty()) {
                this.addWarn("Empty sax event list");
                return null;
            }
            Supplier<? extends GenericXMLConfigurator> jcSupplier = capc.getConfiguratorSupplier();
            if (jcSupplier == null) {
                IncludeModelHandler includeModelHandler = this;
                includeModelHandler.addError("null configurator supplier. Abandoning inclusion of [" + includeModelHandler.attributeInUse + "]");
                this.inError = true;
                return null;
            }
            GenericXMLConfigurator genericXMLConfigurator = jcSupplier.get();
            genericXMLConfigurator.getRuleStore().addPathPathMapping("included", "configuration");
            model = ((GenericXMLConfigurator)((Object)model)).buildModelFromSaxEventList(var2_2.getSaxEventList());
            return model;
        }
        catch (JoranException e) {
            void var3_4;
            this.inError = true;
            IncludeModelHandler includeModelHandler = this;
            includeModelHandler.addError("Error processing XML data in [" + includeModelHandler.attributeInUse + "]", (Throwable)var3_4);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void processModelFromIncludedFile(IncludeModel includeModel, Model modelFromIncludedFile) {
        void var2_2;
        includeModel.getSubModels().addAll(var2_2.getSubModels());
    }

    /*
     * WARNING - void declaration
     */
    public SaxEventRecorder populateSaxEventRecorder(InputStream inputStream) throws JoranException {
        void var2_2;
        void var1_1;
        SaxEventRecorder recorder = new SaxEventRecorder(this.context);
        recorder.recordEvents((InputStream)var1_1);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private InputStream getInputStream(ContextAwarePropertyContainer capc, IncludeModel includeModel) {
        void var1_1;
        void var2_2;
        URL inputURL = this.getInputURL(capc, (ResourceModel)var2_2);
        if (inputURL == null) {
            return null;
        }
        ConfigurationWatchListUtil.addToWatchList(this.context, inputURL);
        return this.openURL((URL)var1_1);
    }
}

