/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.model.processor;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.action.ActionUtil;
import ch.qos.logback.core.model.DefineModel;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelHandlerException;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.spi.ContextAwarePropertyContainer;
import ch.qos.logback.core.spi.LifeCycle;
import ch.qos.logback.core.spi.PropertyDefiner;
import ch.qos.logback.core.util.OptionHelper;

public class DefineModelHandler
extends ModelHandlerBase {
    boolean inError;
    PropertyDefiner definer;
    String propertyName;
    ActionUtil.Scope scope;

    /*
     * WARNING - void declaration
     */
    public DefineModelHandler(Context context) {
        super((Context)var1_1);
        void var1_1;
    }

    public static DefineModelHandler makeInstance(Context context, ModelInterpretationContext ic) {
        Context context2;
        return new DefineModelHandler(context2);
    }

    protected Class<DefineModel> getSupportedModelClass() {
        return DefineModel.class;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void handle(ModelInterpretationContext interpretationContext, Model model) throws ModelHandlerException {
        String className;
        this.definer = null;
        this.inError = false;
        this.propertyName = null;
        DefineModel defineModel = (DefineModel)model;
        this.propertyName = defineModel.getName();
        String scopeStr = defineModel.getScopeStr();
        this.scope = ActionUtil.stringToScope(scopeStr);
        if (OptionHelper.isNullOrEmptyOrAllSpaces(this.propertyName)) {
            this.addError("Missing property name for property definer. Near [" + model.getTag() + "] line " + model.getLineNumber());
            this.inError = true;
        }
        if (OptionHelper.isNullOrEmptyOrAllSpaces(className = defineModel.getClassName())) {
            void var2_3;
            this.addError("Missing class name for property definer. Near [" + model.getTag() + "] line " + var2_3.getLineNumber());
            this.inError = true;
        } else {
            className = interpretationContext.getImport(className);
        }
        if (this.inError) {
            return;
        }
        try {
            this.addInfo("About to instantiate property definer of type [" + className + "]");
            this.definer = (PropertyDefiner)OptionHelper.instantiateByClassName(className, PropertyDefiner.class, this.context);
            this.definer.setContext(this.context);
            interpretationContext.pushObject(this.definer);
            return;
        }
        catch (Exception oops) {
            void var1_2;
            void var3_4;
            this.inError = true;
            this.addError("Could not create an PropertyDefiner of type [" + (String)var3_4 + "].", oops);
            throw new ModelHandlerException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void postHandle(ModelInterpretationContext interpretationContext, Model model) throws ModelHandlerException {
        String propertyValue;
        if (this.inError) {
            return;
        }
        model = interpretationContext.peekObject();
        if (model != this.definer) {
            DefineModelHandler defineModelHandler = this;
            defineModelHandler.addWarn("The object at the of the stack is not the property definer for property named [" + defineModelHandler.propertyName + "] pushed earlier.");
            return;
        }
        interpretationContext.popObject();
        if (this.definer instanceof LifeCycle) {
            ((LifeCycle)((Object)this.definer)).start();
        }
        if ((propertyValue = this.definer.getPropertyValue()) != null) {
            void var2_2;
            void var1_1;
            DefineModelHandler defineModelHandler = this;
            defineModelHandler.addInfo("Setting property " + defineModelHandler.propertyName + "=" + propertyValue + " in scope " + String.valueOf((Object)this.scope));
            ActionUtil.setProperty((ContextAwarePropertyContainer)var1_1, this.propertyName, (String)var2_2, this.scope);
        }
    }
}

