/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.model.processor;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.util.beans.BeanDescriptionCache;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.ModelHandlerFactoryMethod;
import ch.qos.logback.core.model.NamedComponentModel;
import ch.qos.logback.core.model.processor.ChainedModelFilter;
import ch.qos.logback.core.model.processor.ModelFilter;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelHandlerException;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.model.processor.PhaseIndicator;
import ch.qos.logback.core.model.processor.ProcessingPhase;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.FilterReply;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;

public class DefaultProcessor
extends ContextAwareBase {
    protected final ModelInterpretationContext mic;
    final HashMap<Class<? extends Model>, ModelHandlerFactoryMethod> modelClassToHandlerMap = new HashMap();
    final HashMap<Class<? extends Model>, Supplier<ModelHandlerBase>> modelClassToDependencyAnalyserMap = new HashMap();
    ChainedModelFilter phaseOneFilter = new ChainedModelFilter();
    ChainedModelFilter phaseTwoFilter = new ChainedModelFilter();
    static final int DENIED = -1;

    /*
     * WARNING - void declaration
     */
    public DefaultProcessor(Context context, ModelInterpretationContext mic) {
        void var2_2;
        void var1_1;
        this.setContext((Context)var1_1);
        this.mic = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public void addHandler(Class<? extends Model> modelClass, ModelHandlerFactoryMethod modelFactoryMethod) {
        void var1_1;
        void var2_2;
        this.modelClassToHandlerMap.put(modelClass, modelFactoryMethod);
        ProcessingPhase phase = this.determineProcessingPhase(modelClass);
        switch (phase) {
            case FIRST: {
                this.getPhaseOneFilter().allow(modelClass);
                return;
            }
            case SECOND: {
                this.getPhaseTwoFilter().allow(modelClass);
                return;
            }
        }
        throw new IllegalArgumentException("unexpected value " + String.valueOf(var2_2) + " for model class " + var1_1.getName());
    }

    private ProcessingPhase determineProcessingPhase(Class<? extends Model> modelClass) {
        ProcessingPhase processingPhase;
        PhaseIndicator phaseIndicator = modelClass.getAnnotation(PhaseIndicator.class);
        if (phaseIndicator == null) {
            return ProcessingPhase.FIRST;
        }
        processingPhase = processingPhase.phase();
        return processingPhase;
    }

    /*
     * WARNING - void declaration
     */
    public void addAnalyser(Class<? extends Model> modelClass, Supplier<ModelHandlerBase> analyserSupplier) {
        void var2_2;
        void var1_1;
        this.modelClassToDependencyAnalyserMap.put((Class<? extends Model>)var1_1, (Supplier<ModelHandlerBase>)var2_2);
    }

    private void traversalLoop(TraverseMethod traverseMethod, Model model, ModelFilter modelfFilter, String phaseName) {
        int n;
        for (int i = 0; i < 3 && (n = traverseMethod.traverse(model, modelfFilter)) != 0; ++i) {
        }
    }

    /*
     * WARNING - void declaration
     */
    public void process(Model model) {
        void var1_1;
        if (model == null) {
            this.addError("Expecting non null model to process");
            return;
        }
        this.initialObjectPush();
        this.mainTraverse(model, this.getPhaseOneFilter());
        this.analyseDependencies(model);
        DefaultProcessor defaultProcessor = this;
        defaultProcessor.traversalLoop(defaultProcessor::secondPhaseTraverse, (Model)var1_1, this.getPhaseTwoFilter(), "phase 2");
        this.addInfo("End of configuration.");
        this.finalObjectPop();
    }

    private void finalObjectPop() {
        this.mic.popObject();
    }

    private void initialObjectPush() {
        this.mic.pushObject(this.context);
    }

    public ChainedModelFilter getPhaseOneFilter() {
        return this.phaseOneFilter;
    }

    public ChainedModelFilter getPhaseTwoFilter() {
        return this.phaseTwoFilter;
    }

    /*
     * WARNING - void declaration
     */
    protected void analyseDependencies(Model model) {
        Supplier<ModelHandlerBase> analyserSupplier = this.modelClassToDependencyAnalyserMap.get(model.getClass());
        ModelHandlerBase analyser = null;
        if (analyserSupplier != null) {
            Iterator<Model> iterator;
            analyser = (ModelHandlerBase)iterator.get();
        }
        if (analyser != null && !model.isSkipped()) {
            this.callAnalyserHandleOnModel(model, analyser);
        }
        for (Model m : model.getSubModels()) {
            this.analyseDependencies(m);
        }
        if (analyser != null && !model.isSkipped()) {
            void var3_3;
            void var1_1;
            this.callAnalyserPostHandleOnModel((Model)var1_1, (ModelHandlerBase)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void callAnalyserPostHandleOnModel(Model model, ModelHandlerBase analyser) {
        try {
            analyser.postHandle(this.mic, model);
            return;
        }
        catch (ModelHandlerException e) {
            void var2_3;
            void var1_1;
            this.addError("Failed to invoke postHandle on model " + var1_1.getTag(), (Throwable)var2_3);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void callAnalyserHandleOnModel(Model model, ModelHandlerBase analyser) {
        try {
            analyser.handle(this.mic, model);
            return;
        }
        catch (ModelHandlerException e) {
            void var2_3;
            void var1_1;
            this.addError("Failed to traverse model " + var1_1.getTag(), (Throwable)var2_3);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private ModelHandlerBase createHandler(Model model) {
        void var2_2;
        ModelHandlerFactoryMethod modelFactoryMethod = this.modelClassToHandlerMap.get(model.getClass());
        if (modelFactoryMethod == null) {
            this.addError("Can't handle model of type " + String.valueOf(model.getClass()) + "  with tag: " + model.getTag() + " at line " + model.getLineNumber());
            return null;
        }
        ModelHandlerBase handler = modelFactoryMethod.make(this.context, this.mic);
        if (handler == null) {
            return null;
        }
        if (!handler.isSupportedModelType(model)) {
            void var1_1;
            this.addWarn("Handler [" + String.valueOf(handler.getClass()) + "] does not support " + var1_1.idString());
            return null;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    protected int mainTraverse(Model model, ModelFilter modelFiler) {
        void var3_4;
        FilterReply filterReply = modelFiler.decide(model);
        if (filterReply == FilterReply.DENY) {
            return -1;
        }
        int count = 0;
        try {
            ModelHandlerBase handler = null;
            boolean unhandled = model.isUnhandled();
            if (unhandled && (handler = this.createHandler(model)) != null) {
                handler.handle(this.mic, model);
                model.markAsHandled();
                ++count;
            }
            if (!model.isSkipped()) {
                for (Model m : model.getSubModels()) {
                    count += this.mainTraverse(m, modelFiler);
                }
            }
            if (unhandled && handler != null) {
                handler.postHandle(this.mic, model);
            }
        }
        catch (ModelHandlerException e) {
            void var1_1;
            this.addError("Failed to traverse model " + var1_1.getTag(), e);
        }
        return (int)var3_4;
    }

    /*
     * WARNING - void declaration
     */
    protected int secondPhaseTraverse(Model model, ModelFilter modelFilter) {
        void var3_4;
        FilterReply filterReply = modelFilter.decide(model);
        if (filterReply == FilterReply.DENY) {
            return 0;
        }
        int count = 0;
        try {
            boolean allDependenciesStarted = this.allDependenciesStarted(model);
            ModelHandlerBase handler = null;
            if (model.isUnhandled() && allDependenciesStarted && (handler = this.createHandler(model)) != null) {
                handler.handle(this.mic, model);
                model.markAsHandled();
                ++count;
            }
            if (!allDependenciesStarted && !this.dependencyIsADirectSubmodel(model)) {
                return count;
            }
            if (!model.isSkipped()) {
                for (Model m : model.getSubModels()) {
                    count += this.secondPhaseTraverse(m, modelFilter);
                }
            }
            if (handler != null) {
                handler.postHandle(this.mic, model);
            }
        }
        catch (ModelHandlerException e) {
            void var1_1;
            this.addError("Failed to traverse model " + var1_1.getTag(), e);
        }
        return (int)var3_4;
    }

    /*
     * WARNING - void declaration
     */
    private boolean dependencyIsADirectSubmodel(Model model) {
        Iterator<Model> iterator;
        List<String> dependecyNames = this.mic.getDependeeNamesForModel(model);
        if (dependecyNames == null || dependecyNames.isEmpty()) {
            return false;
        }
        for (Model submodel : ((Model)((Object)iterator)).getSubModels()) {
            void var3_3;
            if (!(submodel instanceof NamedComponentModel)) continue;
            submodel = (NamedComponentModel)submodel;
            String subModelName = ((NamedComponentModel)submodel).getName();
            if (!dependecyNames.contains(var3_3)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean allDependenciesStarted(Model model) {
        Iterator iterator;
        List<String> dependencyNames = this.mic.getDependeeNamesForModel(model);
        if (dependencyNames == null || dependencyNames.isEmpty()) {
            return true;
        }
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_3;
            String name = (String)iterator.next();
            boolean bl = this.mic.isNamedDependeeStarted((String)var2_3);
            if (bl) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    ModelHandlerBase instantiateHandler(Class<? extends ModelHandlerBase> handlerClass) {
        try {
            Constructor<? extends ModelHandlerBase> commonConstructor = this.getWithContextConstructor(handlerClass);
            if (commonConstructor != null) {
                return commonConstructor.newInstance(this.context);
            }
            Constructor<? extends ModelHandlerBase> constructorWithBDC = this.getWithContextAndBDCConstructor(handlerClass);
            if (constructorWithBDC != null) {
                void var2_2;
                return (ModelHandlerBase)var2_2.newInstance(this.context, this.mic.getBeanDescriptionCache());
            }
            this.addError("Failed to find suitable constructor for class [" + String.valueOf(handlerClass) + "]");
            return null;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException exception) {
            void var1_1;
            this.addError("Failed to instantiate " + String.valueOf(var1_1));
            return null;
        }
    }

    private Constructor<? extends ModelHandlerBase> getWithContextConstructor(Class<? extends ModelHandlerBase> handlerClass) {
        try {
            Constructor<? extends ModelHandlerBase> constructor = handlerClass.getConstructor(Context.class);
            return constructor;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private Constructor<? extends ModelHandlerBase> getWithContextAndBDCConstructor(Class<? extends ModelHandlerBase> handlerClass) {
        try {
            Constructor<? extends ModelHandlerBase> constructor = handlerClass.getConstructor(Context.class, BeanDescriptionCache.class);
            return constructor;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    static interface TraverseMethod {
        public int traverse(Model var1, ModelFilter var2);
    }
}

