/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.model.processor;

import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.model.AppenderModel;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelHandlerException;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.spi.AppenderAttachable;
import ch.qos.logback.core.spi.LifeCycle;
import ch.qos.logback.core.util.OptionHelper;
import java.util.Map;

public class AppenderModelHandler<E>
extends ModelHandlerBase {
    Appender<E> appender;
    private boolean inError = false;
    private boolean skipped = false;
    AppenderAttachable<E> appenderAttachable;

    /*
     * WARNING - void declaration
     */
    public AppenderModelHandler(Context context) {
        super((Context)var1_1);
        void var1_1;
    }

    public static ModelHandlerBase makeInstance(Context context, ModelInterpretationContext mic) {
        Context context2;
        return new AppenderModelHandler(context2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void handle(ModelInterpretationContext mic, Model model) throws ModelHandlerException {
        this.appender = null;
        this.inError = false;
        AppenderModel appenderModel = (AppenderModel)model;
        String appenderName = mic.subst(appenderModel.getName());
        if (!mic.hasDependers(appenderName)) {
            this.addWarn("Appender named [" + appenderName + "] not referenced. Skipping further processing.");
            this.skipped = true;
            appenderModel.markAsSkipped();
            return;
        }
        this.addInfo("Processing appender named [" + appenderName + "]");
        String originalClassName = appenderModel.getClassName();
        String className = mic.getImport(originalClassName);
        try {
            void var3_4;
            this.addInfo("About to instantiate appender of type [" + className + "]");
            this.appender = (Appender)OptionHelper.instantiateByClassName(className, Appender.class, this.context);
            this.appender.setContext(this.context);
            this.appender.setName((String)var3_4);
            mic.pushObject(this.appender);
            return;
        }
        catch (Exception oops) {
            void var1_2;
            void var2_3;
            this.inError = true;
            this.addError("Could not create an Appender of type [" + (String)var2_3 + "].", oops);
            throw new ModelHandlerException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void postHandle(ModelInterpretationContext mic, Model model) throws ModelHandlerException {
        void var1_1;
        void var2_2;
        if (this.inError || this.skipped) {
            return;
        }
        if (this.appender instanceof LifeCycle) {
            this.appender.start();
        }
        mic.markStartOfNamedDependee(this.appender.getName());
        Object o = mic.peekObject();
        Map map = (Map)mic.getObjectMap().get("APPENDER_BAG");
        map.put(this.appender.getName(), this.appender);
        if (var2_2 != this.appender) {
            AppenderModelHandler appenderModelHandler = this;
            appenderModelHandler.addWarn("The object at the of the stack is not the appender named [" + appenderModelHandler.appender.getName() + "] pushed earlier.");
            return;
        }
        var1_1.popObject();
    }
}

