/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Model
implements Serializable {
    private static final long serialVersionUID = -797372668713068159L;
    boolean handled = false;
    boolean skipped = false;
    String tag;
    String bodyText;
    int lineNumber;
    List<Model> subModels = new ArrayList<Model>();

    /*
     * WARNING - void declaration
     */
    public static Model duplicate(Model that) {
        void var1_1;
        Object object;
        Model copy = that.makeNewInstance();
        copy.mirror(that);
        for (Model model : ((Model)object).subModels) {
            Model duplicate = Model.duplicate(model);
            copy.subModels.add(model);
        }
        return var1_1;
    }

    protected Model makeNewInstance() {
        return new Model();
    }

    /*
     * WARNING - void declaration
     */
    protected void mirror(Model that) {
        void var1_1;
        this.tag = that.tag;
        this.bodyText = that.bodyText;
        this.lineNumber = var1_1.lineNumber;
    }

    public void markAsSkipped() {
        this.skipped = true;
    }

    public void deepMarkAsSkipped() {
        this.markAsSkipped();
        for (Model model : this.getSubModels()) {
            model.deepMarkAsSkipped();
        }
    }

    void resetForReuse() {
        this.handled = false;
        this.skipped = false;
        for (Model model : this.subModels) {
            model.resetForReuse();
        }
    }

    public boolean isSkipped() {
        return this.skipped;
    }

    public boolean isUnhandled() {
        return !this.handled;
    }

    public boolean isHandled() {
        return this.handled;
    }

    public void markAsHandled() {
        this.handled = true;
    }

    public String getTag() {
        return this.tag;
    }

    /*
     * WARNING - void declaration
     */
    public void setTag(String tag) {
        void var1_1;
        this.tag = var1_1;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    /*
     * WARNING - void declaration
     */
    public void setLineNumber(int lineNumber) {
        void var1_1;
        this.lineNumber = var1_1;
    }

    public List<Model> getSubModels() {
        return this.subModels;
    }

    /*
     * WARNING - void declaration
     */
    public void addSubModel(Model m) {
        void var1_1;
        this.subModels.add((Model)var1_1);
    }

    public String getBodyText() {
        return this.bodyText;
    }

    /*
     * WARNING - void declaration
     */
    public void addText(String bodytext) {
        void var1_1;
        if (this.bodyText == null) {
            this.bodyText = bodytext;
            return;
        }
        this.bodyText = this.bodyText + (String)var1_1;
    }

    public String idString() {
        return "<" + this.tag + "> at line " + this.lineNumber;
    }

    public int hashCode() {
        return Objects.hash(this.bodyText, this.lineNumber, this.subModels, this.tag);
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object obj) {
        void var1_1;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Model other = (Model)obj;
        return Objects.equals(this.bodyText, other.bodyText) && this.lineNumber == other.lineNumber && Objects.equals(this.subModels, other.subModels) && Objects.equals(this.tag, var1_1.tag);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [tag=" + this.tag + ", bodyText=" + this.bodyText + ", id=" + this.hashCode() + "]";
    }
}

