/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.util;

import ch.qos.logback.core.spi.ContextAware;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;

public class StringToObjectConverter {
    private static final Class<?>[] STRING_CLASS_PARAMETER = new Class[]{String.class};

    /*
     * WARNING - void declaration
     */
    public static boolean canBeBuiltFromSimpleString(Class<?> parameterClass) {
        Class<?> clazz;
        void var1_1;
        Package p = parameterClass.getPackage();
        if (parameterClass.isPrimitive()) {
            return true;
        }
        if (p != null && "java.lang".equals(var1_1.getName())) {
            return true;
        }
        if (StringToObjectConverter.followsTheValueOfConvention(parameterClass)) {
            return true;
        }
        if (parameterClass.isEnum()) {
            return true;
        }
        return StringToObjectConverter.isOfTypeCharset(clazz);
    }

    /*
     * WARNING - void declaration
     */
    public static Object convertArg(ContextAware ca, String val, Class<?> type) {
        if (val == null) {
            return null;
        }
        String v = val.trim();
        if (String.class.isAssignableFrom(type)) {
            return v;
        }
        if (Integer.TYPE.isAssignableFrom(type)) {
            return Integer.valueOf(v);
        }
        if (Long.TYPE.isAssignableFrom(type)) {
            return Long.valueOf(v);
        }
        if (Float.TYPE.isAssignableFrom(type)) {
            return Float.valueOf(v);
        }
        if (Double.TYPE.isAssignableFrom(type)) {
            return Double.valueOf(v);
        }
        if (Boolean.TYPE.isAssignableFrom(type)) {
            if ("true".equalsIgnoreCase(v)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(v)) {
                return Boolean.FALSE;
            }
        } else {
            void var2_2;
            if (type.isEnum()) {
                return StringToObjectConverter.convertToEnum(ca, v, type);
            }
            if (StringToObjectConverter.followsTheValueOfConvention(type)) {
                void var3_3;
                return StringToObjectConverter.convertByValueOfMethod(ca, type, (String)var3_3);
            }
            if (StringToObjectConverter.isOfTypeCharset(var2_2)) {
                void var1_1;
                ContextAware contextAware;
                return StringToObjectConverter.convertToCharset(contextAware, (String)var1_1);
            }
        }
        return null;
    }

    private static boolean isOfTypeCharset(Class<?> type) {
        Class<?> clazz;
        return Charset.class.isAssignableFrom(clazz);
    }

    /*
     * WARNING - void declaration
     */
    private static Charset convertToCharset(ContextAware ca, String val) {
        if ("null".equalsIgnoreCase(val)) {
            ca.addInfo("Converting the string \"null\" as Charset.defaultCharset()");
            return Charset.defaultCharset();
        }
        try {
            return Charset.forName(val);
        }
        catch (UnsupportedCharsetException e) {
            void var2_2;
            void var1_1;
            ContextAware contextAware;
            contextAware.addError("Failed to get charset [" + (String)var1_1 + "]", (Throwable)var2_2);
            return null;
        }
    }

    public static Method getValueOfMethod(Class<?> type) {
        try {
            return type.getMethod("valueOf", STRING_CLASS_PARAMETER);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    public static boolean followsTheValueOfConvention(Class<?> parameterClass) {
        GenericDeclaration genericDeclaration;
        GenericDeclaration valueOfMethod = StringToObjectConverter.getValueOfMethod(parameterClass);
        if (valueOfMethod == null) {
            return false;
        }
        int n = ((Method)genericDeclaration).getModifiers();
        return Modifier.isStatic(n);
    }

    /*
     * WARNING - void declaration
     */
    private static Object convertByValueOfMethod(ContextAware ca, Class<?> type, String val) {
        try {
            Method method = type.getMethod("valueOf", STRING_CLASS_PARAMETER);
            return method.invoke(null, val);
        }
        catch (Exception exception) {
            void var2_2;
            void var1_1;
            ContextAware contextAware;
            contextAware.addError("Failed to invoke valueOf{} method in class [" + var1_1.getName() + "] with value [" + (String)var2_2 + "]");
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Object convertToEnum(ContextAware ca, String val, Class<? extends Enum> enumType) {
        void var1_1;
        return Enum.valueOf(enumType, (String)var1_1);
    }

    boolean isBuildableFromSimpleString() {
        return false;
    }
}

