/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.util;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.DefaultNestedComponentRegistry;
import ch.qos.logback.core.joran.util.AggregationAssessor;
import ch.qos.logback.core.joran.util.StringToObjectConverter;
import ch.qos.logback.core.joran.util.beans.BeanDescription;
import ch.qos.logback.core.joran.util.beans.BeanDescriptionCache;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.util.AggregationType;
import ch.qos.logback.core.util.PropertySetterException;
import ch.qos.logback.core.util.StringUtil;
import java.lang.reflect.Method;

public class PropertySetter
extends ContextAwareBase {
    protected final Object obj;
    protected final Class<?> objClass;
    protected final BeanDescription beanDescription;
    protected final AggregationAssessor aggregationAssessor;

    /*
     * WARNING - void declaration
     */
    public PropertySetter(BeanDescriptionCache beanDescriptionCache, Object obj) {
        void var1_1;
        void var2_2;
        this.obj = obj;
        this.objClass = var2_2.getClass();
        this.beanDescription = beanDescriptionCache.getBeanDescription(this.objClass);
        this.aggregationAssessor = new AggregationAssessor((BeanDescriptionCache)var1_1, this.objClass);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setContext(Context context) {
        void var1_1;
        super.setContext(context);
        this.aggregationAssessor.setContext((Context)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setProperty(String name, String value) {
        if (value == null) {
            return;
        }
        Method setter = this.aggregationAssessor.findSetterMethod(name);
        if (setter == null) {
            this.addWarn("No setter for property [" + name + "] in " + this.objClass.getName() + ".");
            return;
        }
        try {
            this.setProperty(setter, value);
            return;
        }
        catch (PropertySetterException ex) {
            void var3_4;
            void var2_2;
            void var1_1;
            this.addWarn("Failed to set property [" + (String)var1_1 + "] to value \"" + (String)var2_2 + "\". ", (Throwable)var3_4);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setProperty(Method setter, String value) throws PropertySetterException {
        Object arg;
        Class<?>[] paramTypes = setter.getParameterTypes();
        try {
            arg = StringToObjectConverter.convertArg(this, value, paramTypes[0]);
        }
        catch (Throwable t) {
            throw new PropertySetterException("Conversion to type [" + String.valueOf(paramTypes[0]) + "] failed. ", t);
        }
        if (arg == null) {
            void var3_5;
            throw new PropertySetterException("Conversion to type [" + String.valueOf(var3_5[0]) + "] failed.");
        }
        try {
            void var2_4;
            t.invoke(this.obj, var2_4);
            return;
        }
        catch (Exception ex) {
            void var1_3;
            throw new PropertySetterException((Throwable)var1_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public AggregationType computeAggregationType(String name) {
        void var1_1;
        return this.aggregationAssessor.computeAggregationType((String)var1_1);
    }

    public Class<?> getObjClass() {
        return this.objClass;
    }

    /*
     * WARNING - void declaration
     */
    public void addComplexProperty(String name, Object complexProperty) {
        void var1_1;
        Method adderMethod = this.aggregationAssessor.findAdderMethod(name);
        if (adderMethod != null) {
            void var2_2;
            void var3_3;
            Class<?>[] paramTypes = adderMethod.getParameterTypes();
            if (!this.isSanityCheckSuccessful(name, adderMethod, paramTypes, complexProperty)) {
                return;
            }
            this.invokeMethodWithSingleParameterOnThisObject((Method)var3_3, var2_2);
            return;
        }
        this.addError("Could not find method [add" + (String)var1_1 + "] in class [" + this.objClass.getName() + "].");
    }

    /*
     * WARNING - void declaration
     */
    void invokeMethodWithSingleParameterOnThisObject(Method method, Object parameter) {
        Class<?> ccc = parameter.getClass();
        try {
            method.invoke(this.obj, parameter);
            return;
        }
        catch (Exception e) {
            void var2_3;
            void var3_4;
            void var1_1;
            this.addError("Could not invoke method " + var1_1.getName() + " in class " + this.obj.getClass().getName() + " with parameter of type " + var3_4.getName(), (Throwable)var2_3);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addBasicProperty(String name, String strValue) {
        Object arg;
        if (strValue == null) {
            return;
        }
        Method adderMethod = this.aggregationAssessor.findAdderMethod(name = StringUtil.capitalizeFirstLetter(name));
        if (adderMethod == null) {
            this.addError("No adder for property [" + name + "].");
            return;
        }
        Class<?>[] paramTypes = adderMethod.getParameterTypes();
        this.isSanityCheckSuccessful(name, adderMethod, paramTypes, strValue);
        try {
            void var2_3;
            arg = StringToObjectConverter.convertArg(this, (String)var2_3, paramTypes[0]);
        }
        catch (Throwable t) {
            this.addError("Conversion to type [" + String.valueOf(paramTypes[0]) + "] failed. ", t);
            return;
        }
        if (arg != null) {
            void var1_1;
            void var3_4;
            this.invokeMethodWithSingleParameterOnThisObject((Method)var3_4, var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setComplexProperty(String name, Object complexProperty) {
        Method setter = this.aggregationAssessor.findSetterMethod(name);
        if (setter == null) {
            this.addWarn("Not setter method for property [" + name + "] in " + this.obj.getClass().getName());
            return;
        }
        Class<?>[] paramTypes = setter.getParameterTypes();
        if (!this.isSanityCheckSuccessful(name, setter, paramTypes, complexProperty)) {
            return;
        }
        try {
            void var2_3;
            void var3_4;
            this.invokeMethodWithSingleParameterOnThisObject((Method)var3_4, var2_3);
            return;
        }
        catch (Exception e) {
            void var1_2;
            PropertySetter propertySetter = this;
            propertySetter.addError("Could not set component " + String.valueOf(propertySetter.obj) + " for parent component " + String.valueOf(this.obj), (Throwable)var1_2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isSanityCheckSuccessful(String name, Method method, Class<?>[] params, Object complexProperty) {
        Class<?> ccc = complexProperty.getClass();
        if (params.length != 1) {
            void var1_1;
            this.addError("Wrong number of parameters in setter method for property [" + (String)var1_1 + "] in " + this.obj.getClass().getName());
            return false;
        }
        if (!params[0].isAssignableFrom(complexProperty.getClass())) {
            void var2_2;
            void var3_3;
            this.addError("A \"" + ccc.getName() + "\" object is not assignable to a \"" + params[0].getName() + "\" variable.");
            this.addError("The class \"" + params[0].getName() + "\" was loaded by ");
            this.addError("[" + String.valueOf(var3_3[0].getClassLoader()) + "] whereas object of type ");
            this.addError("\"" + ccc.getName() + "\" was loaded by [" + String.valueOf(var2_2.getClassLoader()) + "].");
            return false;
        }
        return true;
    }

    public Object getObj() {
        return this.obj;
    }

    /*
     * WARNING - void declaration
     */
    public Class<?> getClassNameViaImplicitRules(String name, AggregationType aggregationType, DefaultNestedComponentRegistry registry) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.aggregationAssessor.getClassNameViaImplicitRules((String)var1_1, (AggregationType)var2_2, (DefaultNestedComponentRegistry)var3_3);
    }
}

