/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.spi;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.action.NOPAction;
import ch.qos.logback.core.joran.event.BodyEvent;
import ch.qos.logback.core.joran.event.EndEvent;
import ch.qos.logback.core.joran.event.SaxEvent;
import ch.qos.logback.core.joran.event.StartEvent;
import ch.qos.logback.core.joran.spi.ActionException;
import ch.qos.logback.core.joran.spi.CAI_WithLocatorSupport;
import ch.qos.logback.core.joran.spi.ElementPath;
import ch.qos.logback.core.joran.spi.EventPlayer;
import ch.qos.logback.core.joran.spi.RuleStore;
import ch.qos.logback.core.joran.spi.SaxEventInterpretationContext;
import java.util.List;
import java.util.Stack;
import java.util.function.Supplier;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;

public class SaxEventInterpreter {
    private static Action NOP_ACTION_SINGLETON = new NOPAction();
    private final RuleStore ruleStore;
    private final SaxEventInterpretationContext interpretationContext;
    private Supplier<Action> implicitActionSupplier;
    private final CAI_WithLocatorSupport cai;
    private ElementPath elementPath;
    Locator locator;
    EventPlayer eventPlayer;
    Context context;
    Stack<Action> actionStack;
    ElementPath skip = null;

    /*
     * WARNING - void declaration
     */
    public SaxEventInterpreter(Context context, RuleStore rs, ElementPath initialElementPath, List<SaxEvent> saxEvents) {
        void var3_3;
        void var1_1;
        void var2_2;
        this.context = context;
        this.cai = new CAI_WithLocatorSupport(context, this);
        this.ruleStore = var2_2;
        this.interpretationContext = new SaxEventInterpretationContext((Context)var1_1, this);
        this.elementPath = var3_3;
        this.actionStack = new Stack();
        this.eventPlayer = new EventPlayer(this, saxEvents);
    }

    public EventPlayer getEventPlayer() {
        return this.eventPlayer;
    }

    public ElementPath getCopyOfElementPath() {
        return this.elementPath.duplicate();
    }

    public SaxEventInterpretationContext getSaxEventInterpretationContext() {
        return this.interpretationContext;
    }

    public void startDocument() {
    }

    /*
     * WARNING - void declaration
     */
    public void startElement(StartEvent se) {
        void var1_1;
        this.setDocumentLocator(se.getLocator());
        this.startElement(se.namespaceURI, se.localName, se.qName, var1_1.attributes);
    }

    /*
     * WARNING - void declaration
     */
    private void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
        void var1_1;
        void var3_3;
        String tagName = this.getTagName(localName, (String)var3_3);
        this.elementPath.push(tagName);
        if (this.skip != null) {
            this.pushEmptyActionOntoActionStack();
            return;
        }
        SaxEventInterpreter saxEventInterpreter = this;
        Action applicableAction = saxEventInterpreter.getApplicableAction(saxEventInterpreter.elementPath, atts);
        if (applicableAction != null) {
            void var2_2;
            this.actionStack.add(applicableAction);
            this.callBeginAction((Action)var2_2, tagName, atts);
            return;
        }
        this.pushEmptyActionOntoActionStack();
        String errMsg = "no applicable action for [" + tagName + "], current ElementPath  is [" + String.valueOf(this.elementPath) + "]";
        this.cai.addError((String)var1_1);
    }

    private void pushEmptyActionOntoActionStack() {
        this.actionStack.push(NOP_ACTION_SINGLETON);
    }

    /*
     * WARNING - void declaration
     */
    public void characters(BodyEvent be) {
        this.setDocumentLocator(be.locator);
        String body = be.getText();
        Action applicableAction = this.actionStack.peek();
        if (body != null && (body = body.trim()).length() > 0) {
            void var1_1;
            void var2_2;
            this.callBodyAction((Action)var2_2, (String)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void endElement(EndEvent endEvent) {
        void var1_1;
        this.setDocumentLocator(endEvent.locator);
        this.endElement(endEvent.namespaceURI, endEvent.localName, var1_1.qName);
    }

    /*
     * WARNING - void declaration
     */
    private void endElement(String namespaceURI, String localName, String qName) {
        Action applicableAction = this.actionStack.pop();
        if (this.skip != null) {
            if (this.skip.equals(this.elementPath)) {
                this.skip = null;
            }
        } else if (applicableAction != NOP_ACTION_SINGLETON) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.callEndAction((Action)var1_1, this.getTagName((String)var2_2, (String)var3_3));
        }
        this.elementPath.pop();
    }

    public Locator getLocator() {
        return this.locator;
    }

    /*
     * WARNING - void declaration
     */
    public void setDocumentLocator(Locator l) {
        void var1_1;
        this.locator = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    String getTagName(String localName, String qName) {
        void var1_1;
        String tagName = localName;
        if (tagName == null || tagName.length() <= 0) {
            void var2_2;
            tagName = var2_2;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setImplicitActionSupplier(Supplier<Action> actionSupplier) {
        void var1_1;
        this.implicitActionSupplier = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    Action getApplicableAction(ElementPath elementPath, Attributes attributes) {
        void var1_1;
        Supplier<Action> applicableActionSupplier = this.ruleStore.matchActions(elementPath);
        if (applicableActionSupplier != null) {
            Action applicableAction = applicableActionSupplier.get();
            applicableAction.setContext(this.context);
            return applicableAction;
        }
        Action implicitAction = this.implicitActionSupplier.get();
        implicitAction.setContext(this.context);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    void callBeginAction(Action applicableAction, String tagName, Attributes atts) {
        if (applicableAction == null) {
            return;
        }
        try {
            void var3_5;
            applicableAction.begin(this.interpretationContext, tagName, (Attributes)var3_5);
            return;
        }
        catch (ActionException e) {
            this.skip = this.elementPath.duplicate();
            this.cai.addError("ActionException in Action for tag [" + tagName + "]", e);
            return;
        }
        catch (RuntimeException e) {
            void var1_3;
            void var2_4;
            this.skip = this.elementPath.duplicate();
            this.cai.addError("RuntimeException in Action for tag [" + (String)var2_4 + "]", (Throwable)var1_3);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void callBodyAction(Action applicableAction, String body) {
        if (applicableAction == null) {
            return;
        }
        try {
            applicableAction.body(this.interpretationContext, body);
            return;
        }
        catch (ActionException ae) {
            void var2_3;
            void var1_1;
            this.cai.addError("Exception in body() method for action [" + String.valueOf(var1_1) + "]", (Throwable)var2_3);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void callEndAction(Action applicableAction, String tagName) {
        if (applicableAction == null) {
            return;
        }
        try {
            applicableAction.end(this.interpretationContext, tagName);
            return;
        }
        catch (ActionException ae) {
            this.cai.addError("ActionException in Action for tag [" + tagName + "]", ae);
            return;
        }
        catch (RuntimeException e) {
            void var1_3;
            void var2_4;
            this.cai.addError("RuntimeException in Action for tag [" + (String)var2_4 + "]", (Throwable)var1_3);
            return;
        }
    }

    public RuleStore getRuleStore() {
        return this.ruleStore;
    }
}

