/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.spi;

import ch.qos.logback.core.joran.spi.HttpUtil;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.util.MD5Util;
import java.io.File;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class ConfigurationWatchList
extends ContextAwareBase {
    public static final String HTTPS_PROTOCOL_STR = "https";
    public static final String HTTP_PROTOCOL_STR = "http";
    public static final String FILE_PROTOCOL_STR = "file";
    static final String[] WATCHABLE_PROTOCOLS = new String[]{"file", "https", "http"};
    static final byte[] BUF_ZERO = new byte[]{0};
    URL mainURL;
    List<File> fileWatchList = new ArrayList<File>();
    List<URL> urlWatchList = new ArrayList<URL>();
    List<byte[]> lastHashList = new ArrayList<byte[]>();
    List<Long> lastModifiedList = new ArrayList<Long>();

    /*
     * WARNING - void declaration
     */
    public ConfigurationWatchList buildClone() {
        void var1_1;
        ConfigurationWatchList out = new ConfigurationWatchList();
        new ConfigurationWatchList().mainURL = this.mainURL;
        out.fileWatchList = new ArrayList<File>(this.fileWatchList);
        out.lastModifiedList = new ArrayList<Long>(this.lastModifiedList);
        out.lastHashList = new ArrayList<byte[]>(this.lastHashList);
        return var1_1;
    }

    public void clear() {
        this.mainURL = null;
        this.lastModifiedList.clear();
        this.fileWatchList.clear();
        this.urlWatchList.clear();
        this.lastHashList.clear();
    }

    /*
     * WARNING - void declaration
     */
    public void setMainURL(URL mainURL) {
        this.mainURL = mainURL;
        if (mainURL != null) {
            void var1_1;
            this.addAsFileToWatch((URL)var1_1);
        }
    }

    public boolean watchPredicateFulfilled() {
        if (this.hasMainURLAndNonEmptyFileList()) {
            return true;
        }
        if (this.urlListContainsProperties()) {
            return true;
        }
        return this.fileWatchListContainsProperties();
    }

    private boolean urlListContainsProperties() {
        return this.urlWatchList.stream().anyMatch(url -> url.toString().endsWith(".properties"));
    }

    private boolean hasMainURLAndNonEmptyFileList() {
        return this.mainURL != null && !this.fileWatchList.isEmpty();
    }

    private boolean fileWatchListContainsProperties() {
        return this.fileWatchList.stream().anyMatch(file -> file.getName().endsWith(".properties"));
    }

    /*
     * WARNING - void declaration
     */
    private void addAsFileToWatch(URL url) {
        File file = this.convertToFile(url);
        if (file != null) {
            void var1_1;
            this.fileWatchList.add(file);
            this.lastModifiedList.add(var1_1.lastModified());
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isHTTP_Or_HTTPS(URL url) {
        void var1_1;
        String protocolStr = url.getProtocol();
        return this.isHTTP_Or_HTTPS((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private boolean isHTTP_Or_HTTPS(String protocolStr) {
        void var1_1;
        return protocolStr.equals(HTTP_PROTOCOL_STR) || var1_1.equals(HTTPS_PROTOCOL_STR);
    }

    /*
     * WARNING - void declaration
     */
    private void addAsHTTP_or_HTTPS_URLToWatch(URL url) {
        if (this.isHTTP_Or_HTTPS(url)) {
            void var1_1;
            this.urlWatchList.add((URL)var1_1);
            this.lastHashList.add(BUF_ZERO);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addToWatchList(URL url) {
        void var1_1;
        void var2_2;
        String protocolStr = url.getProtocol();
        if (protocolStr.equals(FILE_PROTOCOL_STR)) {
            this.addAsFileToWatch(url);
            return;
        }
        if (this.isHTTP_Or_HTTPS((String)var2_2)) {
            this.addAsHTTP_or_HTTPS_URLToWatch(url);
            return;
        }
        this.addInfo("Cannot watch [" + String.valueOf(var1_1) + "] as its protocol is not one of file, http or https.");
    }

    public URL getMainURL() {
        return this.mainURL;
    }

    public List<File> getCopyOfFileWatchList() {
        return new ArrayList<File>(this.fileWatchList);
    }

    public boolean emptyWatchLists() {
        if (this.fileWatchList != null && !this.fileWatchList.isEmpty()) {
            return false;
        }
        return this.urlWatchList == null || this.urlWatchList.isEmpty();
    }

    public File changeDetected() {
        return this.changeDetectedInFile();
    }

    /*
     * WARNING - void declaration
     */
    public File changeDetectedInFile() {
        int len = this.fileWatchList.size();
        for (int i = 0; i < len; ++i) {
            void var3_3;
            long lastModified = this.lastModifiedList.get(i);
            File file = this.fileWatchList.get(i);
            long actualModificationDate = file.lastModified();
            if (var3_3 == actualModificationDate) continue;
            this.lastModifiedList.set(i, actualModificationDate);
            return file;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public URL changeDetectedInURL() {
        int len = this.urlWatchList.size();
        if (len > 0) {
            void var2_3;
            void var3_4;
            void var1_2;
            byte[] lastHash = this.lastHashList.get(0);
            URL url = this.urlWatchList.get(0);
            HttpUtil httpGetUtil = new HttpUtil(HttpUtil.RequestMethod.GET, url);
            HttpURLConnection getConnection = httpGetUtil.connectTextTxt();
            String response = httpGetUtil.readResponse(getConnection);
            byte[] hash = this.computeHash(response);
            if (lastHash == BUF_ZERO) {
                this.lastHashList.set(0, hash);
                return null;
            }
            if (Arrays.equals((byte[])var1_2, hash)) {
                return null;
            }
            this.lastHashList.set(0, (byte[])var3_4);
            return var2_3;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private byte[] computeHash(String response) {
        if (response == null || response.trim().length() == 0) {
            return null;
        }
        try {
            byte[] byArray;
            MD5Util mD5Util = new MD5Util();
            byArray = mD5Util.md5Hash((String)byArray);
            return byArray;
        }
        catch (NoSuchAlgorithmException e) {
            void var2_3;
            this.addError("missing MD5 algorithm", (Throwable)var2_3);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    File convertToFile(URL url) {
        void var1_1;
        void var2_2;
        String protocol = url.getProtocol();
        if (FILE_PROTOCOL_STR.equals(var2_2)) {
            return new File(URLDecoder.decode(url.getFile()));
        }
        this.addInfo("URL [" + String.valueOf(var1_1) + "] is not of type file");
        return null;
    }

    public boolean hasAtLeastOneWatchableFile() {
        return !this.fileWatchList.isEmpty();
    }

    public static boolean isWatchableProtocol(URL url) {
        String string;
        if (url == null) {
            return false;
        }
        String protocolStr = url.getProtocol();
        return Arrays.stream(WATCHABLE_PROTOCOLS).anyMatch(protocol -> {
            String string;
            return protocol.equalsIgnoreCase(string);
        });
    }

    public static boolean isWatchableProtocol(String protocolStr) {
        String string;
        return Arrays.stream(WATCHABLE_PROTOCOLS).anyMatch(protocol -> {
            String string;
            return protocol.equalsIgnoreCase(string);
        });
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var2_2;
        void var1_1;
        String fileWatchListStr = this.fileWatchList.stream().map(File::getPath).collect(Collectors.joining(", "));
        String urlWatchListStr = this.urlWatchList.stream().map(URL::toString).collect(Collectors.joining(", "));
        return "ConfigurationWatchList(mainURL=" + String.valueOf(this.mainURL) + ", fileWatchList={" + (String)var1_1 + "}, urlWatchList=[" + (String)var2_2 + "})";
    }
}

