/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.event.stax;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.event.stax.BodyEvent;
import ch.qos.logback.core.joran.event.stax.EndEvent;
import ch.qos.logback.core.joran.event.stax.StartEvent;
import ch.qos.logback.core.joran.event.stax.StaxEvent;
import ch.qos.logback.core.joran.spi.ElementPath;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.spi.ContextAwareBase;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class StaxEventRecorder
extends ContextAwareBase {
    List<StaxEvent> eventList = new ArrayList<StaxEvent>();
    ElementPath globalElementPath = new ElementPath();

    /*
     * WARNING - void declaration
     */
    public StaxEventRecorder(Context context) {
        void var1_1;
        this.setContext((Context)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void recordEvents(InputStream inputStream) throws JoranException {
        try {
            XMLEventReader xmlEventReader = XMLInputFactory.newInstance().createXMLEventReader(inputStream);
            this.read(xmlEventReader);
            return;
        }
        catch (XMLStreamException e) {
            void var1_2;
            throw new JoranException("Problem parsing XML document. See previously reported errors.", (Throwable)var1_2);
        }
    }

    public List<StaxEvent> getEventList() {
        return this.eventList;
    }

    /*
     * WARNING - void declaration
     */
    private void read(XMLEventReader xmlEventReader) throws XMLStreamException {
        while (xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = xmlEventReader.nextEvent();
            switch (xmlEvent.getEventType()) {
                case 1: {
                    this.addStartElement(xmlEvent);
                    break;
                }
                case 4: {
                    this.addCharacters(xmlEvent);
                    break;
                }
                case 2: {
                    void var2_2;
                    this.addEndEvent((XMLEvent)var2_2);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addStartElement(XMLEvent xmlEvent) {
        void var1_1;
        void var2_2;
        void var3_3;
        StartElement se = xmlEvent.asStartElement();
        String tagName = se.getName().getLocalPart();
        this.globalElementPath.push(tagName);
        ElementPath current = this.globalElementPath.duplicate();
        StartEvent startEvent = new StartEvent((ElementPath)var3_3, (String)var2_2, se.getAttributes(), se.getLocation());
        this.eventList.add((StaxEvent)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void addCharacters(XMLEvent xmlEvent) {
        Characters characters = xmlEvent.asCharacters();
        StaxEvent lastEvent = this.getLastEvent();
        if (lastEvent instanceof BodyEvent) {
            void var3_3;
            xmlEvent = (BodyEvent)var3_3;
            ((BodyEvent)xmlEvent).append(characters.getData());
            return;
        }
        if (!characters.isWhiteSpace()) {
            void var1_1;
            void var2_2;
            BodyEvent bodyEvent = new BodyEvent(var2_2.getData(), xmlEvent.getLocation());
            this.eventList.add((StaxEvent)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addEndEvent(XMLEvent xmlEvent) {
        void var1_1;
        void var2_2;
        EndElement ee = xmlEvent.asEndElement();
        String tagName = ee.getName().getLocalPart();
        EndEvent endEvent = new EndEvent((String)var2_2, ee.getLocation());
        this.eventList.add((StaxEvent)var1_1);
        this.globalElementPath.pop();
    }

    /*
     * WARNING - void declaration
     */
    StaxEvent getLastEvent() {
        void var1_1;
        if (this.eventList.isEmpty()) {
            return null;
        }
        int size = this.eventList.size();
        if (size == 0) {
            return null;
        }
        return this.eventList.get((int)(var1_1 - true));
    }
}

