/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.action;

import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.spi.ActionException;
import ch.qos.logback.core.joran.spi.SaxEventInterpretationContext;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.ResourceModel;
import org.xml.sax.Attributes;

public abstract class ResourceAction
extends Action {
    private static final String FILE_ATTR = "file";
    private static final String URL_ATTR = "url";
    private static final String RESOURCE_ATTR = "resource";
    private static final String OPTIONAL_ATTR = "optional";
    Model parentModel;
    ResourceModel resourceModel;
    boolean inError = false;

    protected abstract ResourceModel makeNewResourceModel();

    /*
     * WARNING - void declaration
     */
    @Override
    public void begin(SaxEventInterpretationContext seic, String tagName, Attributes attributes) throws ActionException {
        void var1_1;
        void var2_3;
        void var3_4;
        String optionalStr = attributes.getValue(OPTIONAL_ATTR);
        this.resourceModel = this.makeNewResourceModel();
        this.resourceModel.setOptional(optionalStr);
        ResourceAction resourceAction = this;
        resourceAction.fillInIncludeModelAttributes(resourceAction.resourceModel, tagName, (Attributes)var3_4);
        if (!seic.isModelStackEmpty()) {
            this.parentModel = seic.peekModel();
        }
        int lineNumber = ResourceAction.getLineNumber(seic);
        this.resourceModel.setLineNumber((int)var2_3);
        var1_1.pushModel(this.resourceModel);
    }

    /*
     * WARNING - void declaration
     */
    private void fillInIncludeModelAttributes(ResourceModel resourceModel, String tagName, Attributes attributes) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.resourceModel.setTag(tagName);
        String fileAttribute = attributes.getValue(FILE_ATTR);
        String urlAttribute = attributes.getValue(URL_ATTR);
        String resourceAttribute = attributes.getValue(RESOURCE_ATTR);
        this.resourceModel.setFile((String)var1_1);
        this.resourceModel.setUrl((String)var2_2);
        this.resourceModel.setResource((String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void end(SaxEventInterpretationContext seic, String name) throws ActionException {
        if (this.inError) {
            return;
        }
        Model model = seic.peekModel();
        if (model != this.resourceModel) {
            ResourceAction resourceAction = this;
            resourceAction.addWarn("The object at the of the stack is not the model [" + resourceAction.resourceModel.idString() + "] pushed earlier.");
            this.addWarn("This is wholly unexpected.");
        }
        if (this.parentModel != null) {
            void var1_1;
            this.parentModel.addSubModel(this.resourceModel);
            var1_1.popModel();
        }
    }
}

