/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.helpers;

import java.util.ArrayList;
import java.util.List;

public class CyclicBuffer<E> {
    E[] ea;
    int first;
    int last;
    int numElems;
    int maxSize;

    /*
     * WARNING - void declaration
     */
    public CyclicBuffer(int maxSize) throws IllegalArgumentException {
        void var1_1;
        if (maxSize <= 0) {
            throw new IllegalArgumentException("The maxSize argument (" + maxSize + ") is not a positive integer.");
        }
        this.init((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public CyclicBuffer(CyclicBuffer<E> other) {
        void var1_1;
        this.maxSize = other.maxSize;
        this.ea = new Object[this.maxSize];
        System.arraycopy(other.ea, 0, this.ea, 0, this.maxSize);
        this.last = other.last;
        this.first = other.first;
        this.numElems = var1_1.numElems;
    }

    /*
     * WARNING - void declaration
     */
    private void init(int maxSize) {
        void var1_1;
        this.maxSize = maxSize;
        this.ea = new Object[var1_1];
        this.first = 0;
        this.last = 0;
        this.numElems = 0;
    }

    public void clear() {
        CyclicBuffer cyclicBuffer = this;
        cyclicBuffer.init(cyclicBuffer.maxSize);
    }

    /*
     * WARNING - void declaration
     */
    public void add(E event) {
        void var1_1;
        this.ea[this.last] = var1_1;
        if (++this.last == this.maxSize) {
            this.last = 0;
        }
        if (this.numElems < this.maxSize) {
            ++this.numElems;
            return;
        }
        if (++this.first == this.maxSize) {
            this.first = 0;
        }
    }

    /*
     * WARNING - void declaration
     */
    public E get(int i) {
        void var1_1;
        if (i < 0 || i >= this.numElems) {
            return null;
        }
        return this.ea[(this.first + var1_1) % this.maxSize];
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    /*
     * WARNING - void declaration
     */
    public E get() {
        void var1_1;
        Object r = null;
        if (this.numElems > 0) {
            --this.numElems;
            r = this.ea[this.first];
            this.ea[this.first] = null;
            if (++this.first == this.maxSize) {
                this.first = 0;
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public List<E> asList() {
        void var1_1;
        ArrayList<E> tList = new ArrayList<E>();
        for (int i = 0; i < this.length(); ++i) {
            tList.add(this.get(i));
        }
        return var1_1;
    }

    public int length() {
        return this.numElems;
    }

    /*
     * WARNING - void declaration
     */
    public void resize(int newSize) {
        void var3_3;
        void var1_1;
        void var2_2;
        if (newSize < 0) {
            throw new IllegalArgumentException("Negative array size [" + newSize + "] not allowed.");
        }
        if (newSize == this.numElems) {
            return;
        }
        Object[] temp = new Object[newSize];
        int loopLen = newSize < this.numElems ? newSize : this.numElems;
        for (int i = 0; i < loopLen; ++i) {
            temp[i] = this.ea[this.first];
            this.ea[this.first] = null;
            if (++this.first != this.numElems) continue;
            this.first = 0;
        }
        this.ea = var2_2;
        this.first = 0;
        this.numElems = loopLen;
        this.maxSize = newSize;
        if (loopLen == var1_1) {
            this.last = 0;
            return;
        }
        this.last = var3_3;
    }
}

